/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Container;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.JSpinner;
import javax.swing.text.JTextComponent;
import org.fest.assertions.Assertions;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JSpinnerSetValueTask;
import org.fest.swing.driver.JSpinnerValueQuery;
import org.fest.swing.driver.JTextComponentTextQuery;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.format.Formatting;
import org.fest.util.Strings;

public class JSpinnerDriver
extends JComponentDriver {
    private static final TypeMatcher EDITOR_MATCHER = new TypeMatcher(JTextComponent.class, true);
    private static final String VALUE_PROPERTY = "value";

    public JSpinnerDriver(Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void increment(JSpinner spinner, int times) {
        this.validate(times, "increment the value");
        JSpinnerDriver.validateAndIncrementValue(spinner, times);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void validateAndIncrementValue(final JSpinner spinner, final int times) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(spinner);
                JSpinnerDriver.incrementValue(spinner, times);
            }
        });
    }

    @RunsInCurrentThread
    private static void incrementValue(JSpinner spinner, int times) {
        for (int i = 0; i < times; ++i) {
            Object newValue = spinner.getNextValue();
            if (newValue == null) {
                return;
            }
            spinner.setValue(newValue);
        }
    }

    @RunsInEDT
    public void increment(JSpinner spinner) {
        JSpinnerDriver.validateAndIncrementValue(spinner);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void validateAndIncrementValue(final JSpinner spinner) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(spinner);
                Object newValue = spinner.getNextValue();
                if (newValue != null) {
                    spinner.setValue(newValue);
                }
            }
        });
    }

    @RunsInEDT
    public void decrement(JSpinner spinner, int times) {
        this.validate(times, "decrement the value");
        JSpinnerDriver.validateAndDecrementValue(spinner, times);
        this.robot.waitForIdle();
    }

    private void validate(int times, String action) {
        if (times > 0) {
            return;
        }
        throw new IllegalArgumentException(Strings.concat("The number of times to ", action, " should be greater than zero, but was <", times, ">"));
    }

    @RunsInEDT
    private static void validateAndDecrementValue(final JSpinner spinner, final int times) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(spinner);
                JSpinnerDriver.decrementValue(spinner, times);
            }
        });
    }

    @RunsInCurrentThread
    private static void decrementValue(JSpinner spinner, int times) {
        for (int i = 0; i < times; ++i) {
            Object newValue = spinner.getPreviousValue();
            if (newValue == null) {
                return;
            }
            spinner.setValue(newValue);
        }
    }

    @RunsInEDT
    public void decrement(JSpinner spinner) {
        JSpinnerDriver.validateAndDecrementValue(spinner);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void validateAndDecrementValue(final JSpinner spinner) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(spinner);
                Object newValue = spinner.getPreviousValue();
                if (newValue != null) {
                    spinner.setValue(newValue);
                }
            }
        });
    }

    @RunsInEDT
    public String textOf(JSpinner spinner) {
        JTextComponent editor = this.findEditor(spinner);
        if (editor != null) {
            return JTextComponentTextQuery.textOf(editor);
        }
        Object value = JSpinnerValueQuery.valueOf(spinner);
        return value != null ? value.toString() : null;
    }

    @RunsInEDT
    public void enterTextAndCommit(JSpinner spinner, String text) {
        this.enterText(spinner, text);
        JSpinnerDriver.commit(spinner);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void commit(final JSpinner spinner) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() throws ParseException {
                spinner.commitEdit();
            }
        });
    }

    @RunsInEDT
    public void enterText(JSpinner spinner, String text) {
        JSpinnerDriver.assertIsEnabledAndShowing(spinner);
        JTextComponent editor = this.findEditor(spinner);
        JSpinnerDriver.validate(spinner, editor);
        this.robot.waitForIdle();
        this.robot.focusAndWaitForFocusGain(editor);
        this.invokeAction(editor, "select-all");
        this.robot.enterText(text);
    }

    @RunsInEDT
    private JTextComponent findEditor(JSpinner spinner) {
        ArrayList<Component> found = new ArrayList<Component>(this.robot.finder().findAll((Container)spinner, EDITOR_MATCHER));
        if (found.size() != 1) {
            return null;
        }
        Component c = (Component)found.get(0);
        if (c instanceof JTextComponent) {
            return (JTextComponent)c;
        }
        return null;
    }

    @RunsInEDT
    private static void validate(final JSpinner spinner, final JTextComponent editor) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                if (editor == null) {
                    throw ActionFailedException.actionFailure(Strings.concat("Unable to find editor for ", Formatting.format(spinner)));
                }
            }
        });
    }

    @RunsInEDT
    public void selectValue(JSpinner spinner, Object value) {
        try {
            JSpinnerSetValueTask.setValue(spinner, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Strings.concat("Value ", Strings.quote(value), " is not valid"));
        }
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public JTextComponent editor(JSpinner spinner) {
        return (JTextComponent)this.robot.finder().find((Container)spinner, EDITOR_MATCHER);
    }

    @RunsInEDT
    public void requireValue(JSpinner spinner, Object value) {
        Assertions.assertThat(JSpinnerValueQuery.valueOf(spinner)).as(JSpinnerDriver.propertyName(spinner, VALUE_PROPERTY)).isEqualTo(value);
    }
}

