/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.regex.Pattern;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.fest.assertions.Assertions;
import org.fest.assertions.Description;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTextComponentEditableQuery;
import org.fest.swing.driver.JTextComponentSelectAllTask;
import org.fest.swing.driver.JTextComponentSelectTextTask;
import org.fest.swing.driver.JTextComponentSetTextTask;
import org.fest.swing.driver.JTextComponentTextQuery;
import org.fest.swing.driver.PointAndParentForScrollingJTextFieldQuery;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.driver.TextDisplayDriver;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.format.Formatting;
import org.fest.swing.util.Pair;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTextComponentDriver
extends JComponentDriver
implements TextDisplayDriver<JTextComponent> {
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String TEXT_PROPERTY = "text";

    public JTextComponentDriver(Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void deleteText(JTextComponent textBox) {
        this.selectAll(textBox);
        this.invokeAction(textBox, "delete-previous");
    }

    @RunsInEDT
    public void replaceText(JTextComponent textBox, String text) {
        if (text == null) {
            throw new NullPointerException("The text to enter should not be null");
        }
        if (Strings.isEmpty(text)) {
            throw new IllegalArgumentException("The text to enter should not be empty");
        }
        this.selectAll(textBox);
        this.enterText(textBox, text);
    }

    @RunsInEDT
    public void selectAll(JTextComponent textBox) {
        JTextComponentDriver.validateAndScrollToPosition(textBox, 0);
        JTextComponentSelectAllTask.selectAllText(textBox);
    }

    @RunsInEDT
    public void enterText(JTextComponent textBox, String text) {
        this.focusAndWaitForFocusGain(textBox);
        this.robot.enterText(text);
    }

    @RunsInEDT
    public void setText(JTextComponent textBox, String text) {
        this.focusAndWaitForFocusGain(textBox);
        JTextComponentSetTextTask.setTextIn(textBox, text);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public void selectText(JTextComponent textBox, String text) {
        int indexFound = JTextComponentDriver.indexOfText(textBox, text);
        if (indexFound == -1) {
            throw new IllegalArgumentException(Strings.concat("The text ", Strings.quote(text), " was not found"));
        }
        this.selectText(textBox, indexFound, indexFound + text.length());
    }

    @RunsInEDT
    private static int indexOfText(final JTextComponent textBox, final String text) {
        return GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(textBox);
                String actualText = textBox.getText();
                if (Strings.isEmpty(actualText)) {
                    return -1;
                }
                return actualText.indexOf(text);
            }
        });
    }

    @RunsInEDT
    public void selectText(JTextComponent textBox, int start, int end) {
        this.robot.moveMouse(textBox, JTextComponentDriver.validateAndScrollToPosition(textBox, start));
        this.robot.moveMouse(textBox, JTextComponentDriver.scrollToPosition(textBox, end));
        JTextComponentDriver.performAndValidateTextSelection(textBox, start, end);
    }

    @RunsInEDT
    private static Point validateAndScrollToPosition(final JTextComponent textBox, final int index) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(textBox);
                return JTextComponentDriver.scrollToVisible(textBox, index);
            }
        });
    }

    @RunsInEDT
    private static Point scrollToPosition(final JTextComponent textBox, final int index) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                return JTextComponentDriver.scrollToVisible(textBox, index);
            }
        });
    }

    @RunsInCurrentThread
    private static Point scrollToVisible(JTextComponent textBox, int index) {
        Rectangle indexLocation = JTextComponentDriver.locationOf(textBox, index);
        if (JTextComponentDriver.isRectangleVisible(textBox, indexLocation)) {
            return JTextComponentDriver.centerOf(indexLocation);
        }
        JTextComponentDriver.scrollToVisible(textBox, indexLocation);
        indexLocation = JTextComponentDriver.locationOf(textBox, index);
        if (JTextComponentDriver.isRectangleVisible(textBox, indexLocation)) {
            return JTextComponentDriver.centerOf(indexLocation);
        }
        throw ActionFailedException.actionFailure(Strings.concat("Unable to make visible the location of the index '", String.valueOf(index), "' by scrolling the point (", JTextComponentDriver.formatOriginOf(indexLocation), ") on ", Formatting.format(textBox)));
    }

    @RunsInCurrentThread
    private static Rectangle locationOf(JTextComponent textBox, int index) {
        Rectangle r = null;
        try {
            r = textBox.modelToView(index);
        }
        catch (BadLocationException e) {
            throw JTextComponentDriver.cannotGetLocation(textBox, index);
        }
        if (r != null) {
            return r;
        }
        throw JTextComponentDriver.cannotGetLocation(textBox, index);
    }

    private static ActionFailedException cannotGetLocation(JTextComponent textBox, int index) {
        throw ActionFailedException.actionFailure(Strings.concat("Unable to get location for index '", String.valueOf(index), "' in ", Formatting.format(textBox)));
    }

    @RunsInCurrentThread
    private static boolean isRectangleVisible(JTextComponent textBox, Rectangle r) {
        Rectangle visible = textBox.getVisibleRect();
        return visible.contains(r.x, r.y);
    }

    private static String formatOriginOf(Rectangle r) {
        return Strings.concat(String.valueOf(r.x), ",", String.valueOf(r.y));
    }

    @RunsInCurrentThread
    private static void scrollToVisible(JTextComponent textBox, Rectangle r) {
        textBox.scrollRectToVisible(r);
        if (JTextComponentDriver.isVisible(textBox, r)) {
            return;
        }
        JTextComponentDriver.scrollToVisibleIfIsTextField(textBox, r);
    }

    @RunsInCurrentThread
    private static void scrollToVisibleIfIsTextField(JTextComponent textBox, Rectangle r) {
        if (!(textBox instanceof JTextField)) {
            return;
        }
        Pair<Point, Container> pointAndParent = PointAndParentForScrollingJTextFieldQuery.pointAndParentForScrolling((JTextField)textBox);
        Container parent = (Container)pointAndParent.ii;
        if (parent == null || parent instanceof CellRendererPane || !(parent instanceof JComponent)) {
            return;
        }
        ((JComponent)parent).scrollRectToVisible(JTextComponentDriver.addPointToRectangle((Point)pointAndParent.i, r));
    }

    private static Rectangle addPointToRectangle(Point p, Rectangle r) {
        Rectangle destination = new Rectangle(r);
        destination.x += p.x;
        destination.y += p.y;
        return destination;
    }

    private static Point centerOf(Rectangle r) {
        return new Point(r.x + r.width / 2, r.y + r.height / 2);
    }

    @RunsInEDT
    private static void performAndValidateTextSelection(final JTextComponent textBox, final int start, final int end) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                JTextComponentSelectTextTask.selectTextInRange(textBox, start, end);
                JTextComponentDriver.verifyTextWasSelected(textBox, start, end);
            }
        });
    }

    @RunsInCurrentThread
    private static void verifyTextWasSelected(JTextComponent textBox, int start, int end) {
        int actualStart = textBox.getSelectionStart();
        int actualEnd = textBox.getSelectionEnd();
        if (actualStart == Math.min(start, end) && actualEnd == Math.max(start, end)) {
            return;
        }
        throw ActionFailedException.actionFailure(Strings.concat("Unable to select text using indices '", String.valueOf(start), "' and '", String.valueOf(end), ", current selection starts at '", String.valueOf(actualStart), "' and ends at '", String.valueOf(actualEnd), "'"));
    }

    @Override
    @RunsInEDT
    public void requireText(JTextComponent textBox, String expected) {
        TextAssert.verifyThat(this.textOf(textBox)).as(JTextComponentDriver.textProperty(textBox)).isEqualOrMatches(expected);
    }

    @Override
    @RunsInEDT
    public void requireText(JTextComponent textBox, Pattern pattern) {
        TextAssert.verifyThat(this.textOf(textBox)).as(JTextComponentDriver.textProperty(textBox)).matches(pattern);
    }

    @RunsInEDT
    public void requireEmpty(JTextComponent textBox) {
        Assertions.assertThat(this.textOf(textBox)).as(JTextComponentDriver.textProperty(textBox)).isEmpty();
    }

    @RunsInEDT
    private static Description textProperty(JTextComponent textBox) {
        return JTextComponentDriver.propertyName(textBox, TEXT_PROPERTY);
    }

    @RunsInEDT
    public void requireEditable(JTextComponent textBox) {
        this.assertEditable(textBox, true);
    }

    @RunsInEDT
    public void requireNotEditable(JTextComponent textBox) {
        this.assertEditable(textBox, false);
    }

    @RunsInEDT
    private void assertEditable(JTextComponent textBox, boolean editable) {
        Assertions.assertThat(JTextComponentEditableQuery.isEditable(textBox)).as(JTextComponentDriver.editableProperty(textBox)).isEqualTo(editable);
    }

    @RunsInEDT
    private static Description editableProperty(JTextComponent textBox) {
        return JTextComponentDriver.propertyName(textBox, EDITABLE_PROPERTY);
    }

    @Override
    @RunsInEDT
    public String textOf(JTextComponent textBox) {
        return JTextComponentTextQuery.textOf(textBox);
    }
}

