/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import org.fest.swing.format.Formatting;
import org.fest.swing.query.ComponentShowingQuery;
import org.fest.swing.timing.Condition;
import org.fest.util.Strings;

public class WaitForComponentToShowCondition
extends Condition {
    private Component c;

    public static WaitForComponentToShowCondition untilIsShowing(Component c) {
        return new WaitForComponentToShowCondition(c);
    }

    private WaitForComponentToShowCondition(Component c) {
        super(Strings.concat("Component ", Formatting.format(c), " to show on the screen"));
        if (c == null) {
            throw new NullPointerException("The component to verify should not be null");
        }
        this.c = c;
    }

    public boolean test() {
        return ComponentShowingQuery.isShowing(this.c);
    }

    protected void done() {
        this.c = null;
    }
}

