/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.junit.ant;

import junit.framework.Test;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.fest.swing.image.ImageException;
import org.fest.swing.junit.ant.ScreenshotXmlWriter;
import org.fest.swing.junit.ant.XmlJUnitResultFormatter;
import org.fest.swing.junit.xml.XmlNode;

public final class ScreenshotOnFailureResultFormatter
extends XmlJUnitResultFormatter {
    private ScreenshotXmlWriter screenshotXmlWriter;

    protected void onStartTestSuite(JUnitTest suite) {
        try {
            this.screenshotXmlWriter = new ScreenshotXmlWriter();
        }
        catch (ImageException e) {
            this.informCannotTakeScreenshots(e);
        }
    }

    private void informCannotTakeScreenshots(ImageException error) {
        XmlNode errorNode = this.xmlRootNode().addNewNode("error");
        this.writeErrorAndStackTrace(error, errorNode);
    }

    protected void onFailureOrError(Test test, Throwable error, XmlNode target) {
        if (this.screenshotXmlWriter == null) {
            return;
        }
        this.screenshotXmlWriter.writeScreenshot(target, test);
    }
}

