/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.popup;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleMenuButton;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.internal.ui.common.popup.JColorSelectorComponent;
import org.pushingpixels.flamingo.internal.ui.common.popup.JColorSelectorPanel;

public class JColorSelectorPopupMenu
extends JCommandPopupMenu {
    private ColorSelectorCallback colorSelectorCallback;
    private JColorSelectorPanel lastColorSelectorPanel;
    private static LinkedList<Color> recentlySelected = new LinkedList();

    public JColorSelectorPopupMenu(ColorSelectorCallback colorSelectorCallback) {
        this.colorSelectorCallback = colorSelectorCallback;
    }

    public void addColorSectionWithDerived(String label, Color[] primaryColors) {
        if (primaryColors == null || primaryColors.length != 10) {
            throw new IllegalArgumentException("Must pass exactly 10 colors");
        }
        MultiRowSelector selectorContainer = new MultiRowSelector(primaryColors);
        JColorSelectorPanel selector = new JColorSelectorPanel(label, selectorContainer);
        this.addMenuPanel(selector);
        this.lastColorSelectorPanel = selector;
    }

    public void addColorSection(String label, Color[] primaryColors) {
        if (primaryColors == null || primaryColors.length != 10) {
            throw new IllegalArgumentException("Must pass exactly 10 colors");
        }
        SingleRowSelector selectorContainer = new SingleRowSelector(primaryColors);
        JColorSelectorPanel selector = new JColorSelectorPanel(label, selectorContainer);
        this.addMenuPanel(selector);
        this.lastColorSelectorPanel = selector;
    }

    public void addRecentSection(String label) {
        SingleRowSelector recent = new SingleRowSelector(recentlySelected.toArray(new Color[0]));
        JColorSelectorPanel recentPanel = new JColorSelectorPanel(label, recent);
        recentPanel.setLastPanel(true);
        this.addMenuPanel(recentPanel);
        this.lastColorSelectorPanel = recentPanel;
    }

    @Override
    public void addMenuButton(JCommandMenuButton menuButton) {
        super.addMenuButton(menuButton);
        this.updateLastColorSelectorPanel();
    }

    @Override
    public void addMenuButton(JCommandToggleMenuButton menuButton) {
        super.addMenuButton(menuButton);
        this.updateLastColorSelectorPanel();
    }

    @Override
    public void addMenuSeparator() {
        super.addMenuSeparator();
        this.updateLastColorSelectorPanel();
    }

    private void updateLastColorSelectorPanel() {
        if (this.lastColorSelectorPanel != null) {
            this.lastColorSelectorPanel.setLastPanel(true);
            this.lastColorSelectorPanel = null;
        }
    }

    public ColorSelectorCallback getColorSelectorCallback() {
        return this.colorSelectorCallback;
    }

    private static void wireToLRU(JColorSelectorComponent colorSelector) {
        colorSelector.addColorSelectorCallback(new ColorSelectorCallback(){

            @Override
            public void onColorSelected(Color color) {
                JColorSelectorPopupMenu.addColorToRecentlyUsed(color);
            }

            @Override
            public void onColorRollover(Color color) {
            }
        });
    }

    public static synchronized List<Color> getRecentlyUsedColors() {
        return Collections.unmodifiableList(recentlySelected);
    }

    public static synchronized void addColorToRecentlyUsed(Color color) {
        if (recentlySelected.contains(color)) {
            recentlySelected.remove(color);
            recentlySelected.addLast(color);
            return;
        }
        if (recentlySelected.size() == 10) {
            recentlySelected.removeFirst();
        }
        recentlySelected.addLast(color);
    }

    public static interface ColorSelectorCallback {
        public void onColorRollover(Color var1);

        public void onColorSelected(Color var1);
    }

    private class MultiRowSelector
    extends JPanel {
        static final int SECONDARY_ROWS = 5;

        public MultiRowSelector(final Color ... colors) {
            final JColorSelectorComponent[][] comps = new JColorSelectorComponent[colors.length][6];
            int i = 0;
            while (i < colors.length) {
                Color primary = colors[i];
                comps[i][0] = new JColorSelectorComponent(primary, JColorSelectorPopupMenu.this.colorSelectorCallback);
                JColorSelectorPopupMenu.wireToLRU(comps[i][0]);
                this.add(comps[i][0]);
                float[] primaryHsb = new float[3];
                Color.RGBtoHSB(primary.getRed(), primary.getGreen(), primary.getBlue(), primaryHsb);
                int row = 1;
                while (row <= 5) {
                    float bFactor = (float)(row - 1) / 5.0f;
                    bFactor = (float)Math.pow(bFactor, 1.4f);
                    float brightness = 1.0f - bFactor;
                    if (primaryHsb[1] == 0.0f) {
                        float max = 0.5f + 0.5f * primaryHsb[2];
                        brightness = max * (float)(5 - row + 1) / 5.0f;
                    }
                    Color secondary = new Color(Color.HSBtoRGB(primaryHsb[0], primaryHsb[1] * (float)(row + 1) / 6.0f, brightness));
                    comps[i][row] = new JColorSelectorComponent(secondary, JColorSelectorPopupMenu.this.colorSelectorCallback);
                    comps[i][row].setTopOpen(row > 1);
                    comps[i][row].setBottomOpen(row < 5);
                    JColorSelectorPopupMenu.wireToLRU(comps[i][row]);
                    this.add(comps[i][row]);
                    ++row;
                }
                ++i;
            }
            this.setLayout(new LayoutManager(){

                @Override
                public void addLayoutComponent(String name, Component comp) {
                }

                @Override
                public void removeLayoutComponent(Component comp) {
                }

                @Override
                public Dimension minimumLayoutSize(Container parent) {
                    return new Dimension(10, 10);
                }

                @Override
                public Dimension preferredLayoutSize(Container parent) {
                    int gap = this.getGap();
                    int size = this.getSize();
                    return new Dimension(colors.length * size + (colors.length + 1) * gap, gap + size + gap + 5 * size + gap);
                }

                @Override
                public void layoutContainer(Container parent) {
                    int gap = this.getGap();
                    int size = this.getSize();
                    if (parent.getComponentOrientation().isLeftToRight()) {
                        int y = gap;
                        int row = 0;
                        while (row <= 5) {
                            int x = gap;
                            int i = 0;
                            while (i < colors.length) {
                                comps[i][row].setBounds(x, y, size, size);
                                x += size + gap;
                                ++i;
                            }
                            y += size;
                            if (row == 0) {
                                y += gap;
                            }
                            ++row;
                        }
                    } else {
                        int y = gap;
                        int row = 0;
                        while (row <= 5) {
                            int x = MultiRowSelector.this.getWidth() - gap;
                            int i = 0;
                            while (i < colors.length) {
                                comps[i][row].setBounds(x - size, y, size, size);
                                x -= size + gap;
                                ++i;
                            }
                            y += size;
                            if (row == 0) {
                                y += gap;
                            }
                            ++row;
                        }
                    }
                }

                private int getGap() {
                    return 4;
                }

                private int getSize() {
                    return 13;
                }
            });
        }
    }

    private class SingleRowSelector
    extends JPanel {
        public SingleRowSelector(final Color ... colors) {
            final JColorSelectorComponent[] comps = new JColorSelectorComponent[colors.length];
            int i = 0;
            while (i < colors.length) {
                comps[i] = new JColorSelectorComponent(colors[i], JColorSelectorPopupMenu.this.colorSelectorCallback);
                JColorSelectorPopupMenu.wireToLRU(comps[i]);
                this.add(comps[i]);
                ++i;
            }
            this.setLayout(new LayoutManager(){

                @Override
                public void addLayoutComponent(String name, Component comp) {
                }

                @Override
                public void removeLayoutComponent(Component comp) {
                }

                @Override
                public Dimension minimumLayoutSize(Container parent) {
                    return new Dimension(10, 10);
                }

                @Override
                public Dimension preferredLayoutSize(Container parent) {
                    int gap = this.getGap();
                    int size = this.getSize();
                    return new Dimension(colors.length * size + (colors.length + 1) * gap, size + 2 * gap);
                }

                @Override
                public void layoutContainer(Container parent) {
                    int gap = this.getGap();
                    int size = this.getSize();
                    if (parent.getComponentOrientation().isLeftToRight()) {
                        int x = gap;
                        int y = gap;
                        int i = 0;
                        while (i < colors.length) {
                            comps[i].setBounds(x, y, size, size);
                            x += size + gap;
                            ++i;
                        }
                    } else {
                        int x = SingleRowSelector.this.getWidth() - gap;
                        int y = gap;
                        int i = 0;
                        while (i < colors.length) {
                            comps[i].setBounds(x - size, y, size, size);
                            x -= size + gap;
                            ++i;
                        }
                    }
                }

                private int getGap() {
                    return 4;
                }

                private int getSize() {
                    return 13;
                }
            });
        }
    }
}

