/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.RadialGradientPaint;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.CompositeShapePainter;
import org.apache.batik.gvt.FillShapePainter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.gvt.StrokeShapePainter;
import org.pushingpixels.flamingo.api.svg.TranscoderListener;

abstract class SvgBaseTranscoder {
    protected TranscoderListener listener;
    protected PrintWriter externalPrintWriter;
    protected PrintWriter printWriter;
    protected String javaClassName;
    protected String javaPackageName;
    protected boolean javaToImplementResizableIconInterface;
    protected static final String TOKEN_PACKAGE = "TOKEN_PACKAGE";
    protected static final String TOKEN_CLASSNAME = "TOKEN_CLASSNAME";
    protected static final String TOKEN_PAINTING_CODE = "TOKEN_PAINTING_CODE";
    protected static final String TOKEN_ORIG_X = "TOKEN_ORIG_X";
    protected static final String TOKEN_ORIG_Y = "TOKEN_ORIG_Y";
    protected static final String TOKEN_ORIG_WIDTH = "TOKEN_ORIG_WIDTH";
    protected static final String TOKEN_ORIG_HEIGHT = "TOKEN_ORIG_HEIGHT";

    public SvgBaseTranscoder(String javaClassname) {
        this.javaClassName = javaClassname;
        this.javaToImplementResizableIconInterface = false;
    }

    public void setJavaToImplementResizableIconInterface(boolean javaToImplementResizableIconInterface) {
        this.javaToImplementResizableIconInterface = javaToImplementResizableIconInterface;
    }

    public void setJavaPackageName(String javaPackageName) {
        this.javaPackageName = javaPackageName;
    }

    public void setListener(TranscoderListener listener) {
        this.listener = listener;
        this.setPrintWriter(new PrintWriter(this.listener.getWriter()));
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.externalPrintWriter = printWriter;
    }

    public void transcode(GraphicsNode gvtRoot) {
        String template = this.javaToImplementResizableIconInterface ? "SvgTranscoderTemplateResizable.templ" : "SvgTranscoderTemplatePlain.templ";
        InputStream templateStream = SvgBaseTranscoder.class.getResourceAsStream(template);
        StringBuffer templateBuffer = new StringBuffer();
        BufferedReader templateReader = new BufferedReader(new InputStreamReader(templateStream));
        try {
            String line;
            while ((line = templateReader.readLine()) != null) {
                templateBuffer.append(String.valueOf(line) + "\n");
            }
            templateReader.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        String templateString = templateBuffer.toString();
        templateString = this.javaPackageName != null ? templateString.replaceAll(TOKEN_PACKAGE, "package " + this.javaPackageName + ";") : templateString.replaceAll(TOKEN_PACKAGE, "");
        templateString = templateString.replaceAll(TOKEN_CLASSNAME, this.javaClassName);
        templateString = templateString.replaceAll(TOKEN_CLASSNAME, this.javaClassName);
        templateString = templateString.replaceAll(TOKEN_CLASSNAME, this.javaClassName);
        ByteArrayOutputStream paintingCodeStream = new ByteArrayOutputStream();
        this.printWriter = new PrintWriter(paintingCodeStream);
        this.transcodeGraphicsNode(gvtRoot, "");
        this.printWriter.close();
        String paintingCode = new String(paintingCodeStream.toByteArray());
        templateString = templateString.replaceAll(TOKEN_PAINTING_CODE, paintingCode);
        Rectangle2D bounds = gvtRoot.getBounds();
        templateString = templateString.replaceAll(TOKEN_ORIG_X, "" + (int)Math.ceil(bounds.getX()));
        templateString = templateString.replaceAll(TOKEN_ORIG_Y, "" + (int)Math.ceil(bounds.getY()));
        templateString = templateString.replaceAll(TOKEN_ORIG_WIDTH, "" + (int)Math.ceil(bounds.getWidth()));
        templateString = templateString.replaceAll(TOKEN_ORIG_HEIGHT, "" + (int)Math.ceil(bounds.getHeight()));
        this.externalPrintWriter.println(templateString);
        this.externalPrintWriter.close();
        if (this.listener != null) {
            this.listener.finished();
        }
    }

    private void transcodePathIterator(PathIterator pathIterator) {
        float[] coords = new float[6];
        this.printWriter.println("shape = new GeneralPath();");
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(coords);
            switch (type) {
                case 3: {
                    this.printWriter.println("((GeneralPath)shape).curveTo(" + coords[0] + ", " + coords[1] + ", " + coords[2] + ", " + coords[3] + ", " + coords[4] + ", " + coords[5] + ");");
                    break;
                }
                case 2: {
                    this.printWriter.println("((GeneralPath)shape).quadTo(" + coords[0] + ", " + coords[1] + ", " + coords[2] + ", " + coords[3] + ");");
                    break;
                }
                case 0: {
                    this.printWriter.println("((GeneralPath)shape).moveTo(" + coords[0] + ", " + coords[1] + ");");
                    break;
                }
                case 1: {
                    this.printWriter.println("((GeneralPath)shape).lineTo(" + coords[0] + ", " + coords[1] + ");");
                    break;
                }
                case 4: {
                    this.printWriter.println("((GeneralPath)shape).closePath();");
                }
            }
            pathIterator.next();
        }
    }

    private void transcodeShape(Shape shape) throws UnsupportedOperationException {
        if (shape instanceof ExtendedGeneralPath) {
            this.transcodePathIterator(((ExtendedGeneralPath)shape).getPathIterator(null));
            return;
        }
        if (shape instanceof GeneralPath) {
            this.transcodePathIterator(((GeneralPath)shape).getPathIterator(null));
            return;
        }
        if (shape instanceof Rectangle2D) {
            Rectangle2D rect = (Rectangle2D)shape;
            this.printWriter.println("shape = new Rectangle2D.Double(" + rect.getX() + ", " + rect.getY() + ", " + rect.getWidth() + ", " + rect.getHeight() + ");");
            return;
        }
        if (shape instanceof RoundRectangle2D) {
            RoundRectangle2D rRect = (RoundRectangle2D)shape;
            this.printWriter.println("shape = new RoundRectangle2D.Double(" + rRect.getX() + ", " + rRect.getY() + ", " + rRect.getWidth() + ", " + rRect.getHeight() + ", " + rRect.getArcWidth() + ", " + rRect.getArcHeight() + ");");
            return;
        }
        if (shape instanceof Ellipse2D) {
            Ellipse2D ell = (Ellipse2D)shape;
            this.printWriter.println("shape = new Ellipse2D.Double(" + ell.getX() + ", " + ell.getY() + ", " + ell.getWidth() + ", " + ell.getHeight() + ");");
            return;
        }
        if (shape instanceof Line2D.Float) {
            Line2D.Float l2df = (Line2D.Float)shape;
            this.printWriter.format("shape = new Line2D.Float(%ff,%ff,%ff,%ff);\n", Float.valueOf(l2df.x1), Float.valueOf(l2df.y1), Float.valueOf(l2df.x2), Float.valueOf(l2df.y2));
            return;
        }
        throw new UnsupportedOperationException(shape.getClass().getCanonicalName());
    }

    private void transcodeLinearGradientPaint(LinearGradientPaint paint) throws IllegalArgumentException {
        int n;
        Point2D startPoint = paint.getStartPoint();
        Point2D endPoint = paint.getEndPoint();
        float[] fractions = paint.getFractions();
        Color[] colors = paint.getColors();
        MultipleGradientPaint.CycleMethodEnum cycleMethod = paint.getCycleMethod();
        MultipleGradientPaint.ColorSpaceEnum colorSpace = paint.getColorSpace();
        AffineTransform transform = paint.getTransform();
        float previousFraction = -1.0f;
        float[] fArray = fractions;
        int n2 = fractions.length;
        int n3 = 0;
        while (n3 < n2) {
            float currentFraction = fArray[n3];
            if (currentFraction < 0.0f || currentFraction > 1.0f) {
                throw new IllegalArgumentException("Fraction values must be in the range 0 to 1: " + currentFraction);
            }
            if (currentFraction < previousFraction) {
                throw new IllegalArgumentException("Keyframe fractions must be non-decreasing: " + currentFraction);
            }
            previousFraction = currentFraction;
            ++n3;
        }
        StringBuffer fractionsRep = new StringBuffer();
        if (fractions == null) {
            fractionsRep.append("null");
        } else {
            String sep = "";
            fractionsRep.append("new float[] {");
            previousFraction = -1.0f;
            float[] fArray2 = fractions;
            n = fractions.length;
            int n4 = 0;
            while (n4 < n) {
                float currentFraction = fArray2[n4];
                fractionsRep.append(sep);
                if (currentFraction == previousFraction) {
                    currentFraction += 1.0E-9f;
                }
                fractionsRep.append(String.valueOf(currentFraction) + "f");
                sep = ",";
                previousFraction = currentFraction;
                ++n4;
            }
            fractionsRep.append("}");
        }
        StringBuffer colorsRep = new StringBuffer();
        if (fractions == null) {
            colorsRep.append("null");
        } else {
            String sep = "";
            colorsRep.append("new Color[] {");
            Color[] colorArray = colors;
            int n5 = colors.length;
            n = 0;
            while (n < n5) {
                Color color = colorArray[n];
                colorsRep.append(sep);
                colorsRep.append("new Color(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ", " + color.getAlpha() + ")");
                sep = ",";
                ++n;
            }
            colorsRep.append("}");
        }
        String cycleMethodRep = null;
        if (cycleMethod == MultipleGradientPaint.NO_CYCLE) {
            cycleMethodRep = "MultipleGradientPaint.CycleMethod.NO_CYCLE";
        }
        if (cycleMethod == MultipleGradientPaint.REFLECT) {
            cycleMethodRep = "MultipleGradientPaint.CycleMethod.REFLECT";
        }
        if (cycleMethod == MultipleGradientPaint.REPEAT) {
            cycleMethodRep = "MultipleGradientPaint.CycleMethod.REPEAT";
        }
        String colorSpaceRep = null;
        if (colorSpace == MultipleGradientPaint.SRGB) {
            colorSpaceRep = "MultipleGradientPaint.ColorSpaceType.SRGB";
        }
        if (colorSpace == MultipleGradientPaint.LINEAR_RGB) {
            colorSpaceRep = "MultipleGradientPaint.ColorSpaceType.LINEAR_RGB";
        }
        double[] transfMatrix = new double[6];
        transform.getMatrix(transfMatrix);
        this.printWriter.println("paint = new LinearGradientPaint(new Point2D.Double(" + startPoint.getX() + ", " + startPoint.getY() + "), new Point2D.Double(" + endPoint.getX() + ", " + endPoint.getY() + "), " + fractionsRep.toString() + ", " + colorsRep.toString() + ", " + cycleMethodRep + ", " + colorSpaceRep + ", new AffineTransform(" + transfMatrix[0] + "f, " + transfMatrix[1] + "f, " + transfMatrix[2] + "f, " + transfMatrix[3] + "f, " + transfMatrix[4] + "f, " + transfMatrix[5] + "f));");
    }

    private void transcodeRadialGradientPaint(RadialGradientPaint paint) throws IllegalArgumentException {
        int n;
        Point2D centerPoint = paint.getCenterPoint();
        float radius = paint.getRadius();
        Point2D focusPoint = paint.getFocusPoint();
        float[] fractions = paint.getFractions();
        Color[] colors = paint.getColors();
        MultipleGradientPaint.CycleMethodEnum cycleMethod = paint.getCycleMethod();
        MultipleGradientPaint.ColorSpaceEnum colorSpace = paint.getColorSpace();
        AffineTransform transform = paint.getTransform();
        float previousFraction = -1.0f;
        float[] fArray = fractions;
        int n2 = fractions.length;
        int n3 = 0;
        while (n3 < n2) {
            float currentFraction = fArray[n3];
            if (currentFraction < 0.0f || currentFraction > 1.0f) {
                throw new IllegalArgumentException("Fraction values must be in the range 0 to 1: " + currentFraction);
            }
            if (currentFraction < previousFraction) {
                throw new IllegalArgumentException("Keyframe fractions must be non-decreasing: " + currentFraction);
            }
            previousFraction = currentFraction;
            ++n3;
        }
        StringBuffer fractionsRep = new StringBuffer();
        if (fractions == null) {
            fractionsRep.append("null");
        } else {
            String sep = "";
            fractionsRep.append("new float[] {");
            previousFraction = -1.0f;
            float[] fArray2 = fractions;
            n = fractions.length;
            int n4 = 0;
            while (n4 < n) {
                float currentFraction = fArray2[n4];
                fractionsRep.append(sep);
                if (currentFraction == previousFraction) {
                    currentFraction += 1.0E-9f;
                }
                fractionsRep.append(String.valueOf(currentFraction) + "f");
                sep = ",";
                previousFraction = currentFraction;
                ++n4;
            }
            fractionsRep.append("}");
        }
        StringBuffer colorsRep = new StringBuffer();
        if (fractions == null) {
            colorsRep.append("null");
        } else {
            String sep = "";
            colorsRep.append("new Color[] {");
            Color[] colorArray = colors;
            int n5 = colors.length;
            n = 0;
            while (n < n5) {
                Color color = colorArray[n];
                colorsRep.append(sep);
                colorsRep.append("new Color(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ", " + color.getAlpha() + ")");
                sep = ",";
                ++n;
            }
            colorsRep.append("}");
        }
        String cycleMethodRep = null;
        if (cycleMethod == MultipleGradientPaint.NO_CYCLE) {
            cycleMethodRep = "MultipleGradientPaint.CycleMethod.NO_CYCLE";
        }
        if (cycleMethod == MultipleGradientPaint.REFLECT) {
            cycleMethodRep = "MultipleGradientPaint.CycleMethod.REFLECT";
        }
        if (cycleMethod == MultipleGradientPaint.REPEAT) {
            cycleMethodRep = "MultipleGradientPaint.CycleMethod.REPEAT";
        }
        String colorSpaceRep = null;
        if (colorSpace == MultipleGradientPaint.SRGB) {
            colorSpaceRep = "MultipleGradientPaint.ColorSpaceType.SRGB";
        }
        if (colorSpace == MultipleGradientPaint.LINEAR_RGB) {
            colorSpaceRep = "MultipleGradientPaint.ColorSpaceType.LINEAR_RGB";
        }
        double[] transfMatrix = new double[6];
        transform.getMatrix(transfMatrix);
        this.printWriter.println("paint = new RadialGradientPaint(new Point2D.Double(" + centerPoint.getX() + ", " + centerPoint.getY() + "), " + radius + "f, new Point2D.Double(" + focusPoint.getX() + ", " + focusPoint.getY() + "), " + fractionsRep.toString() + ", " + colorsRep.toString() + ", " + cycleMethodRep + ", " + colorSpaceRep + ", new AffineTransform(" + transfMatrix[0] + "f, " + transfMatrix[1] + "f, " + transfMatrix[2] + "f, " + transfMatrix[3] + "f, " + transfMatrix[4] + "f, " + transfMatrix[5] + "f));");
    }

    private void transcodePaint(Paint paint) throws UnsupportedOperationException {
        if (paint instanceof RadialGradientPaint) {
            this.transcodeRadialGradientPaint((RadialGradientPaint)paint);
            return;
        }
        if (paint instanceof LinearGradientPaint) {
            this.transcodeLinearGradientPaint((LinearGradientPaint)paint);
            return;
        }
        if (paint instanceof Color) {
            Color c = (Color)paint;
            this.printWriter.println("paint = new Color(" + c.getRed() + ", " + c.getGreen() + ", " + c.getBlue() + ", " + c.getAlpha() + ");");
            return;
        }
        if (paint == null) {
            this.printWriter.println("No paint");
            return;
        }
        throw new UnsupportedOperationException(paint.getClass().getCanonicalName());
    }

    private void transcodeShapePainter(ShapePainter painter) throws UnsupportedOperationException {
        if (painter == null) {
            return;
        }
        if (painter instanceof CompositeShapePainter) {
            this.transcodeCompositeShapePainter((CompositeShapePainter)painter);
            return;
        }
        if (painter instanceof FillShapePainter) {
            this.transcodeFillShapePainter((FillShapePainter)painter);
            return;
        }
        if (painter instanceof StrokeShapePainter) {
            this.transcodeStrokeShapePainter((StrokeShapePainter)painter);
            return;
        }
        throw new UnsupportedOperationException(painter.getClass().getCanonicalName());
    }

    private void transcodeCompositeShapePainter(CompositeShapePainter painter) {
        int i = 0;
        while (i < painter.getShapePainterCount()) {
            this.transcodeShapePainter(painter.getShapePainter(i));
            ++i;
        }
    }

    private void transcodeFillShapePainter(FillShapePainter painter) {
        try {
            Field paintFld = FillShapePainter.class.getDeclaredField("paint");
            paintFld.setAccessible(true);
            Paint paint = (Paint)paintFld.get(painter);
            if (paint == null) {
                return;
            }
            this.transcodePaint(paint);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        Shape shape = painter.getShape();
        this.transcodeShape(shape);
        this.printWriter.println("g.setPaint(paint);");
        this.printWriter.println("g.fill(shape);");
    }

    private void transcodeStrokeShapePainter(StrokeShapePainter painter) {
        Shape shape = painter.getShape();
        try {
            Field paintFld = StrokeShapePainter.class.getDeclaredField("paint");
            paintFld.setAccessible(true);
            Paint paint = (Paint)paintFld.get(painter);
            if (paint == null) {
                return;
            }
            this.transcodePaint(paint);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        try {
            Field strokeFld = StrokeShapePainter.class.getDeclaredField("stroke");
            strokeFld.setAccessible(true);
            Stroke stroke = (Stroke)strokeFld.get(painter);
            BasicStroke bStroke = (BasicStroke)stroke;
            float width = bStroke.getLineWidth();
            int cap = bStroke.getEndCap();
            int join = bStroke.getLineJoin();
            float miterlimit = bStroke.getMiterLimit();
            float[] dash = bStroke.getDashArray();
            float dash_phase = bStroke.getDashPhase();
            StringBuffer dashRep = new StringBuffer();
            if (dash == null) {
                dashRep.append("null");
            } else {
                String sep = "";
                dashRep.append("new float[] {");
                float[] fArray = dash;
                int n = dash.length;
                int n2 = 0;
                while (n2 < n) {
                    float _dash = fArray[n2];
                    dashRep.append(sep);
                    dashRep.append(String.valueOf(_dash) + "f");
                    sep = ",";
                    ++n2;
                }
                dashRep.append("}");
            }
            this.printWriter.println("stroke = new BasicStroke(" + width + "f," + cap + "," + join + "," + miterlimit + "f," + dashRep + "," + dash_phase + "f);");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.transcodeShape(shape);
        this.printWriter.println("g.setPaint(paint);");
        this.printWriter.println("g.setStroke(stroke);");
        this.printWriter.println("g.draw(shape);");
    }

    private void transcodeShapeNode(ShapeNode node, String comment) {
        this.printWriter.println("// " + comment);
        ShapePainter sPainter = node.getShapePainter();
        this.transcodeShapePainter(sPainter);
    }

    private void transcodeCompositeGraphicsNode(CompositeGraphicsNode node, String comment) {
        this.printWriter.println("// " + comment);
        int count = 0;
        for (Object obj : node.getChildren()) {
            this.transcodeGraphicsNode((GraphicsNode)obj, String.valueOf(comment) + "_" + count);
            ++count;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void transcodeGraphicsNode(GraphicsNode node, String comment) throws UnsupportedOperationException {
        AlphaComposite composite = (AlphaComposite)node.getComposite();
        if (composite != null) {
            int rule = composite.getRule();
            float alpha = composite.getAlpha();
            this.printWriter.println("g.setComposite(AlphaComposite.getInstance(" + rule + ", " + alpha + "f * origAlpha));");
        }
        AffineTransform transform = node.getTransform();
        this.printWriter.println("AffineTransform defaultTransform_" + comment + " = g.getTransform();");
        if (transform != null) {
            double[] transfMatrix = new double[6];
            transform.getMatrix(transfMatrix);
            this.printWriter.println("g.transform(new AffineTransform(" + transfMatrix[0] + "f, " + transfMatrix[1] + "f, " + transfMatrix[2] + "f, " + transfMatrix[3] + "f, " + transfMatrix[4] + "f, " + transfMatrix[5] + "f));");
        }
        try {
            if (node instanceof ShapeNode) {
                this.transcodeShapeNode((ShapeNode)node, comment);
                return;
            }
            if (!(node instanceof CompositeGraphicsNode)) throw new UnsupportedOperationException(node.getClass().getCanonicalName());
            this.transcodeCompositeGraphicsNode((CompositeGraphicsNode)node, comment);
            return;
        }
        finally {
            this.printWriter.println("g.setTransform(defaultTransform_" + comment + ");");
        }
    }
}

