/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ColorConvertOp;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.AsynchronousLoadListener;
import org.pushingpixels.flamingo.api.common.AsynchronousLoading;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonStrip;
import org.pushingpixels.flamingo.api.common.PopupActionListener;
import org.pushingpixels.flamingo.api.common.icon.FilteredResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.model.ActionButtonModel;
import org.pushingpixels.flamingo.api.common.model.PopupButtonModel;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.internal.ui.common.BasicCommandButtonListener;
import org.pushingpixels.flamingo.internal.ui.common.CommandButtonUI;
import org.pushingpixels.flamingo.internal.ui.common.ResizableIconUIResource;
import org.pushingpixels.flamingo.internal.utils.ButtonSizingUtils;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.flamingo.internal.utils.RenderingUtils;

public class BasicCommandButtonUI
extends CommandButtonUI {
    protected AbstractCommandButton commandButton;
    protected boolean isUnderMouse;
    protected PropertyChangeListener propertyChangeListener;
    protected BasicCommandButtonListener basicPopupButtonListener;
    protected CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo;
    public static final String EMULATE_SQUARE_BUTTON = "flamingo.internal.commandButton.ui.emulateSquare";
    public static final String DONT_DISPOSE_POPUPS = "flamingo.internal.commandButton.ui.dontDisposePopups";
    protected ActionListener disposePopupsActionListener;
    protected PopupActionListener popupActionListener;
    protected ResizableIcon popupActionIcon;
    protected CommandButtonLayoutManager layoutManager;
    protected CellRendererPane buttonRendererPane;
    protected AbstractButton rendererButton;
    protected JSeparator rendererSeparator;

    public static ComponentUI createUI(JComponent c) {
        return new BasicCommandButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.commandButton = (AbstractCommandButton)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
        this.layoutManager = this.commandButton.getDisplayState().createLayoutManager(this.commandButton);
        this.updateCustomDimension();
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.commandButton = null;
    }

    protected void installDefaults() {
        this.configureRenderer();
        this.updateBorder();
        this.syncDisabledIcon();
    }

    protected void configureRenderer() {
        this.buttonRendererPane = new CellRendererPane();
        this.commandButton.add(this.buttonRendererPane);
        this.rendererButton = this.createRendererButton();
        this.rendererButton.setOpaque(false);
        this.rendererSeparator = new JSeparator();
        Font currFont = this.commandButton.getFont();
        if (currFont == null || currFont instanceof UIResource) {
            this.commandButton.setFont(this.rendererButton.getFont());
        }
        this.rendererButton.putClientProperty("JButton.buttonType", "square");
    }

    protected void updateBorder() {
        Border currBorder = this.commandButton.getBorder();
        if (currBorder == null || currBorder instanceof UIResource) {
            int tb = (int)(this.commandButton.getVGapScaleFactor() * 4.0);
            int lr = (int)(this.commandButton.getHGapScaleFactor() * 6.0);
            this.commandButton.setBorder(new BorderUIResource.EmptyBorderUIResource(tb, lr, tb, lr));
        }
    }

    protected AbstractButton createRendererButton() {
        return new JButton("");
    }

    protected void installComponents() {
        this.updatePopupActionIcon();
        ResizableIcon buttonIcon = this.commandButton.getIcon();
        if (buttonIcon instanceof AsynchronousLoading) {
            ((AsynchronousLoading)((Object)buttonIcon)).addAsynchronousLoadListener(new AsynchronousLoadListener(){

                @Override
                public void completed(boolean success) {
                    if (success && BasicCommandButtonUI.this.commandButton != null) {
                        BasicCommandButtonUI.this.commandButton.repaint();
                    }
                }
            });
        }
        if (this.commandButton instanceof JCommandButton) {
            this.popupActionIcon = this.createPopupActionIcon();
        }
    }

    protected void installListeners() {
        this.basicPopupButtonListener = this.createButtonListener(this.commandButton);
        if (this.basicPopupButtonListener != null) {
            this.commandButton.addMouseListener(this.basicPopupButtonListener);
            this.commandButton.addMouseMotionListener(this.basicPopupButtonListener);
            this.commandButton.addFocusListener(this.basicPopupButtonListener);
            this.commandButton.addChangeListener(this.basicPopupButtonListener);
        }
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("icon".equals(evt.getPropertyName())) {
                    Icon newIcon = (Icon)evt.getNewValue();
                    if (newIcon instanceof AsynchronousLoading) {
                        AsynchronousLoading async = (AsynchronousLoading)((Object)newIcon);
                        async.addAsynchronousLoadListener(new AsynchronousLoadListener(){

                            @Override
                            public void completed(boolean success) {
                                if (success && (this).BasicCommandButtonUI.this.commandButton != null) {
                                    BasicCommandButtonUI.this.syncIconDimension();
                                    BasicCommandButtonUI.this.syncDisabledIcon();
                                    (this).BasicCommandButtonUI.this.commandButton.repaint();
                                }
                            }
                        });
                        if (!async.isLoading()) {
                            BasicCommandButtonUI.this.syncIconDimension();
                            BasicCommandButtonUI.this.syncDisabledIcon();
                            BasicCommandButtonUI.this.commandButton.repaint();
                        }
                    } else {
                        BasicCommandButtonUI.this.syncIconDimension();
                        BasicCommandButtonUI.this.syncDisabledIcon();
                        BasicCommandButtonUI.this.commandButton.revalidate();
                        BasicCommandButtonUI.this.commandButton.repaint();
                    }
                }
                if ("commandButtonKind".equals(evt.getPropertyName())) {
                    BasicCommandButtonUI.this.updatePopupActionIcon();
                }
                if ("popupOrientationKind".equals(evt.getPropertyName())) {
                    BasicCommandButtonUI.this.updatePopupActionIcon();
                }
                if ("customDimension".equals(evt.getPropertyName())) {
                    BasicCommandButtonUI.this.updateCustomDimension();
                }
                if ("hgapScaleFactor".equals(evt.getPropertyName())) {
                    BasicCommandButtonUI.this.updateBorder();
                }
                if ("vgapScaleFactor".equals(evt.getPropertyName())) {
                    BasicCommandButtonUI.this.updateBorder();
                }
                if ("popupModel".equals(evt.getPropertyName())) {
                    PopupButtonModel oldModel = (PopupButtonModel)evt.getOldValue();
                    PopupButtonModel newModel = (PopupButtonModel)evt.getNewValue();
                    if (oldModel != null) {
                        oldModel.removePopupActionListener(BasicCommandButtonUI.this.popupActionListener);
                        BasicCommandButtonUI.this.popupActionListener = null;
                    }
                    if (newModel != null) {
                        BasicCommandButtonUI.this.popupActionListener = BasicCommandButtonUI.this.createPopupActionListener();
                        newModel.addPopupActionListener(BasicCommandButtonUI.this.popupActionListener);
                    }
                }
                if ("displayState".equals(evt.getPropertyName())) {
                    BasicCommandButtonUI.this.syncIconDimension();
                    BasicCommandButtonUI.this.syncDisabledIcon();
                    BasicCommandButtonUI.this.commandButton.invalidate();
                    BasicCommandButtonUI.this.commandButton.revalidate();
                    BasicCommandButtonUI.this.commandButton.doLayout();
                }
                if (BasicCommandButtonUI.this.layoutManager != null) {
                    BasicCommandButtonUI.this.layoutManager.propertyChange(evt);
                }
                if ("componentOrientation".equals(evt.getPropertyName())) {
                    BasicCommandButtonUI.this.updatePopupActionIcon();
                    BasicCommandButtonUI.this.commandButton.repaint();
                }
            }
        };
        this.commandButton.addPropertyChangeListener(this.propertyChangeListener);
        this.disposePopupsActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCommandPopupMenu menu;
                boolean toDismiss;
                boolean bl = toDismiss = !Boolean.TRUE.equals(BasicCommandButtonUI.this.commandButton.getClientProperty(BasicCommandButtonUI.DONT_DISPOSE_POPUPS));
                if (toDismiss && (menu = (JCommandPopupMenu)SwingUtilities.getAncestorOfClass(JCommandPopupMenu.class, BasicCommandButtonUI.this.commandButton)) != null) {
                    toDismiss = menu.isToDismissOnChildClick();
                }
                if (toDismiss) {
                    if (SwingUtilities.getAncestorOfClass(JPopupPanel.class, BasicCommandButtonUI.this.commandButton) != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).BasicCommandButtonUI.this.commandButton != null) {
                                    (this).BasicCommandButtonUI.this.commandButton.getActionModel().setPressed(false);
                                    (this).BasicCommandButtonUI.this.commandButton.getActionModel().setRollover(false);
                                    (this).BasicCommandButtonUI.this.commandButton.getActionModel().setArmed(false);
                                }
                            }
                        });
                    }
                    PopupPanelManager.defaultManager().hidePopups(null);
                }
            }
        };
        this.commandButton.addActionListener(this.disposePopupsActionListener);
        if (this.commandButton instanceof JCommandButton) {
            this.popupActionListener = this.createPopupActionListener();
            ((JCommandButton)this.commandButton).getPopupModel().addPopupActionListener(this.popupActionListener);
        }
    }

    protected ResizableIcon createPopupActionIcon() {
        return FlamingoUtilities.getCommandButtonPopupActionIcon((JCommandButton)this.commandButton);
    }

    protected BasicCommandButtonListener createButtonListener(AbstractCommandButton b) {
        return new BasicCommandButtonListener();
    }

    protected void installKeyboardActions() {
        if (this.basicPopupButtonListener != null) {
            this.basicPopupButtonListener.installKeyboardActions(this.commandButton);
        }
    }

    protected void uninstallDefaults() {
        this.unconfigureRenderer();
    }

    protected void unconfigureRenderer() {
        if (this.buttonRendererPane != null) {
            this.commandButton.remove(this.buttonRendererPane);
        }
        this.buttonRendererPane = null;
    }

    protected void uninstallComponents() {
    }

    protected void uninstallListeners() {
        if (this.basicPopupButtonListener != null) {
            this.commandButton.removeMouseListener(this.basicPopupButtonListener);
            this.commandButton.removeMouseListener(this.basicPopupButtonListener);
            this.commandButton.removeMouseMotionListener(this.basicPopupButtonListener);
            this.commandButton.removeFocusListener(this.basicPopupButtonListener);
            this.commandButton.removeChangeListener(this.basicPopupButtonListener);
        }
        this.commandButton.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.commandButton.removeActionListener(this.disposePopupsActionListener);
        this.disposePopupsActionListener = null;
        if (this.commandButton instanceof JCommandButton) {
            ((JCommandButton)this.commandButton).getPopupModel().removePopupActionListener(this.popupActionListener);
            this.popupActionListener = null;
        }
    }

    protected void uninstallKeyboardActions() {
        if (this.basicPopupButtonListener != null) {
            this.basicPopupButtonListener.uninstallKeyboardActions(this.commandButton);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RenderingUtils.installDesktopHints(g2d);
        super.update(g2d, c);
        g2d.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        g.setFont(FlamingoUtilities.getFont(this.commandButton, "Ribbon.font", "Button.font", "Panel.font"));
        this.layoutInfo = this.layoutManager.getLayoutInfo(this.commandButton, g);
        this.commandButton.putClientProperty("icon.bounds", this.layoutInfo.iconRect);
        if (this.isPaintingBackground()) {
            this.paintButtonBackground(g, new Rectangle(0, 0, this.commandButton.getWidth(), this.commandButton.getHeight()));
        }
        if (this.layoutInfo.iconRect != null) {
            this.paintButtonIcon(g, this.layoutInfo.iconRect);
        }
        if (this.layoutInfo.popupActionRect.getWidth() > 0.0) {
            this.paintPopupActionIcon(g, this.layoutInfo.popupActionRect);
        }
        FontMetrics fm = g.getFontMetrics();
        boolean isTextPaintedEnabled = this.commandButton.isEnabled();
        if (this.commandButton instanceof JCommandButton) {
            JCommandButton jCommandButton = (JCommandButton)this.commandButton;
            isTextPaintedEnabled = this.layoutInfo.isTextInActionArea ? jCommandButton.getActionModel().isEnabled() : jCommandButton.getPopupModel().isEnabled();
        }
        g.setColor(this.getForegroundColor(isTextPaintedEnabled));
        if (this.layoutInfo.textLayoutInfoList != null) {
            for (CommandButtonLayoutManager.TextLayoutInfo mainTextLayoutInfo : this.layoutInfo.textLayoutInfoList) {
                if (mainTextLayoutInfo.text == null) continue;
                BasicGraphicsUtils.drawString(g, mainTextLayoutInfo.text, -1, mainTextLayoutInfo.textRect.x, mainTextLayoutInfo.textRect.y + fm.getAscent());
            }
        }
        if (isTextPaintedEnabled) {
            g.setColor(FlamingoUtilities.getColor(Color.gray, "Label.disabledForeground"));
        } else {
            g.setColor(FlamingoUtilities.getColor(Color.gray, "Label.disabledForeground").brighter());
        }
        if (this.layoutInfo.extraTextLayoutInfoList != null) {
            for (CommandButtonLayoutManager.TextLayoutInfo extraTextLayoutInfo : this.layoutInfo.extraTextLayoutInfoList) {
                if (extraTextLayoutInfo.text == null) continue;
                BasicGraphicsUtils.drawString(g, extraTextLayoutInfo.text, -1, extraTextLayoutInfo.textRect.x, extraTextLayoutInfo.textRect.y + fm.getAscent());
            }
        }
        if (this.isPaintingSeparators() && this.layoutInfo.separatorArea != null) {
            if (this.layoutInfo.separatorOrientation == CommandButtonLayoutManager.CommandButtonSeparatorOrientation.HORIZONTAL) {
                this.paintButtonHorizontalSeparator(g, this.layoutInfo.separatorArea);
            } else {
                this.paintButtonVerticalSeparator(g, this.layoutInfo.separatorArea);
            }
        }
    }

    protected Color getForegroundColor(boolean isTextPaintedEnabled) {
        if (isTextPaintedEnabled) {
            return FlamingoUtilities.getColor(Color.black, "Button.foreground");
        }
        return FlamingoUtilities.getColor(Color.gray, "Label.disabledForeground");
    }

    protected void paintPopupActionIcon(Graphics g, Rectangle popupActionRect) {
        int size = Math.max(popupActionRect.width - 2, 7);
        if (size % 2 == 0) {
            --size;
        }
        this.popupActionIcon.setDimension(new Dimension(size, size));
        this.popupActionIcon.paintIcon(this.commandButton, g, popupActionRect.x + (popupActionRect.width - size) / 2, popupActionRect.y + (popupActionRect.height - size) / 2);
    }

    protected Icon getIconToPaint() {
        return this.toUseDisabledIcon() && this.commandButton.getDisabledIcon() != null ? this.commandButton.getDisabledIcon() : this.commandButton.getIcon();
    }

    protected boolean toUseDisabledIcon() {
        boolean toUseDisabledIcon = this.commandButton instanceof JCommandButton && ((JCommandButton)this.commandButton).getCommandButtonKind() == JCommandButton.CommandButtonKind.POPUP_ONLY ? !((JCommandButton)this.commandButton).getPopupModel().isEnabled() : !this.commandButton.getActionModel().isEnabled();
        return toUseDisabledIcon;
    }

    protected void paintButtonVerticalSeparator(Graphics graphics, Rectangle separatorArea) {
        this.buttonRendererPane.setBounds(0, 0, this.commandButton.getWidth(), this.commandButton.getHeight());
        Graphics2D g2d = (Graphics2D)graphics.create();
        this.rendererSeparator.setOrientation(1);
        this.buttonRendererPane.paintComponent(g2d, this.rendererSeparator, this.commandButton, separatorArea.x, 2, 2, this.commandButton.getHeight() - 4, true);
        g2d.dispose();
    }

    protected void paintButtonHorizontalSeparator(Graphics graphics, Rectangle separatorArea) {
        this.buttonRendererPane.setBounds(0, 0, this.commandButton.getWidth(), this.commandButton.getHeight());
        Graphics2D g2d = (Graphics2D)graphics.create();
        this.rendererSeparator.setOrientation(0);
        this.buttonRendererPane.paintComponent(g2d, this.rendererSeparator, this.commandButton, 2, separatorArea.y, this.commandButton.getWidth() - 4, 2, true);
        g2d.dispose();
    }

    protected void paintButtonBackground(Graphics graphics, Rectangle toFill) {
        ActionButtonModel actionModel = this.commandButton.getActionModel();
        PopupButtonModel popupModel = this.commandButton instanceof JCommandButton ? ((JCommandButton)this.commandButton).getPopupModel() : null;
        this.paintButtonBackground(graphics, toFill, actionModel, popupModel);
        Rectangle actionArea = this.getLayoutInfo().actionClickArea;
        Rectangle popupArea = this.getLayoutInfo().popupClickArea;
        if (actionArea != null && !actionArea.isEmpty()) {
            Graphics2D graphicsAction = (Graphics2D)graphics.create();
            graphicsAction.clip(actionArea);
            float actionAlpha = 0.4f;
            if (popupModel != null && !popupModel.isEnabled()) {
                actionAlpha = 1.0f;
            }
            graphicsAction.setComposite(AlphaComposite.SrcOver.derive(actionAlpha));
            this.paintButtonBackground(graphicsAction, toFill, actionModel);
            graphicsAction.dispose();
        }
        if (popupArea != null && !popupArea.isEmpty()) {
            Graphics2D graphicsPopup = (Graphics2D)graphics.create();
            graphicsPopup.clip(popupArea);
            float popupAlpha = 0.4f;
            if (!actionModel.isEnabled()) {
                popupAlpha = 1.0f;
            }
            graphicsPopup.setComposite(AlphaComposite.SrcOver.derive(popupAlpha));
            this.paintButtonBackground(graphicsPopup, toFill, popupModel);
            graphicsPopup.dispose();
        }
    }

    protected void paintButtonBackground(Graphics graphics, Rectangle toFill, ButtonModel ... modelToUse) {
        if (modelToUse.length == 0) {
            return;
        }
        if (modelToUse.length == 1 && modelToUse[0] == null) {
            return;
        }
        this.buttonRendererPane.setBounds(toFill.x, toFill.y, toFill.width, toFill.height);
        this.rendererButton.setRolloverEnabled(true);
        boolean isEnabled = true;
        boolean isRollover = false;
        boolean isPressed = true;
        boolean isArmed = true;
        boolean isSelected = true;
        ButtonModel[] buttonModelArray = modelToUse;
        int n = modelToUse.length;
        int n2 = 0;
        while (n2 < n) {
            ButtonModel model = buttonModelArray[n2];
            if (model != null) {
                isEnabled = isEnabled && model.isEnabled();
                isRollover = isRollover || model.isRollover();
                isPressed = isPressed && model.isPressed();
                isArmed = isArmed && model.isArmed();
                boolean bl = isSelected = isSelected && model.isSelected();
                if (model instanceof PopupButtonModel) {
                    isRollover = isRollover || ((PopupButtonModel)model).isPopupShowing();
                }
            }
            ++n2;
        }
        this.rendererButton.getModel().setEnabled(isEnabled);
        this.rendererButton.getModel().setRollover(isRollover);
        this.rendererButton.getModel().setPressed(isPressed);
        this.rendererButton.getModel().setArmed(isArmed);
        this.rendererButton.getModel().setSelected(isSelected);
        Graphics2D g2d = (Graphics2D)graphics.create();
        Color borderColor = FlamingoUtilities.getBorderColor();
        if (Boolean.TRUE.equals(this.commandButton.getClientProperty(EMULATE_SQUARE_BUTTON))) {
            this.buttonRendererPane.paintComponent(g2d, this.rendererButton, this.commandButton, toFill.x - toFill.width / 2, toFill.y - toFill.height / 2, 2 * toFill.width, 2 * toFill.height, true);
            g2d.setColor(borderColor);
            g2d.drawRect(toFill.x, toFill.y, toFill.width - 1, toFill.height - 1);
        } else {
            Insets outsets;
            AbstractCommandButton.CommandButtonLocationOrderKind locationKind = this.commandButton.getLocationOrderKind();
            Insets insets = outsets = this.rendererButton instanceof JToggleButton ? ButtonSizingUtils.getInstance().getToggleOutsets() : ButtonSizingUtils.getInstance().getOutsets();
            if (locationKind != null) {
                if (locationKind == AbstractCommandButton.CommandButtonLocationOrderKind.ONLY) {
                    this.buttonRendererPane.paintComponent(g2d, this.rendererButton, this.commandButton, toFill.x - outsets.left, toFill.y - outsets.top, toFill.width + outsets.left + outsets.right, toFill.height + outsets.top + outsets.bottom, true);
                } else {
                    Container parent = this.commandButton.getParent();
                    if (parent instanceof JCommandButtonStrip && ((JCommandButtonStrip)parent).getOrientation() == JCommandButtonStrip.StripOrientation.VERTICAL) {
                        switch (locationKind) {
                            case FIRST: {
                                this.buttonRendererPane.paintComponent(g2d, this.rendererButton, this.commandButton, toFill.x - outsets.left, toFill.y - outsets.top, toFill.width + outsets.left + outsets.right, 2 * toFill.height, true);
                                g2d.setColor(borderColor);
                                g2d.drawLine(toFill.x + 1, toFill.y + toFill.height - 1, toFill.x + toFill.width - 2, toFill.y + toFill.height - 1);
                                break;
                            }
                            case LAST: {
                                this.buttonRendererPane.paintComponent(g2d, this.rendererButton, this.commandButton, toFill.x - outsets.left, toFill.y - toFill.height, toFill.width + outsets.left + outsets.right, 2 * toFill.height + outsets.bottom, true);
                                break;
                            }
                            case MIDDLE: {
                                this.buttonRendererPane.paintComponent(g2d, this.rendererButton, this.commandButton, toFill.x - outsets.left, toFill.y - toFill.height, toFill.width + outsets.left + outsets.right, 3 * toFill.height, true);
                                g2d.setColor(borderColor);
                                g2d.drawLine(toFill.x + 1, toFill.y + toFill.height - 1, toFill.x + toFill.width - 2, toFill.y + toFill.height - 1);
                            }
                        }
                    } else {
                        boolean ltr = this.commandButton.getComponentOrientation().isLeftToRight();
                        if (locationKind == AbstractCommandButton.CommandButtonLocationOrderKind.MIDDLE) {
                            this.buttonRendererPane.paintComponent(g2d, this.rendererButton, this.commandButton, toFill.x - toFill.width, toFill.y - outsets.top, 3 * toFill.width, toFill.height + outsets.top + outsets.bottom, true);
                            g2d.setColor(borderColor);
                            g2d.drawLine(toFill.x + toFill.width - 1, toFill.y + 1, toFill.x + toFill.width - 1, toFill.y + toFill.height - 2);
                        } else {
                            boolean curveOnLeft;
                            boolean bl = curveOnLeft = ltr && locationKind == AbstractCommandButton.CommandButtonLocationOrderKind.FIRST || !ltr && locationKind == AbstractCommandButton.CommandButtonLocationOrderKind.LAST;
                            if (curveOnLeft) {
                                this.buttonRendererPane.paintComponent(g2d, this.rendererButton, this.commandButton, toFill.x - outsets.left, toFill.y - outsets.top, 2 * toFill.width, toFill.height + outsets.top + outsets.bottom, true);
                                g2d.setColor(borderColor);
                                g2d.drawLine(toFill.x + toFill.width - 1, toFill.y + 1, toFill.x + toFill.width - 1, toFill.y + toFill.height - 2);
                            } else {
                                this.buttonRendererPane.paintComponent(g2d, this.rendererButton, this.commandButton, toFill.x - toFill.width, toFill.y - outsets.top, 2 * toFill.width + outsets.right, toFill.height + outsets.top + outsets.bottom, true);
                            }
                        }
                    }
                }
            } else {
                this.buttonRendererPane.paintComponent(g2d, this.rendererButton, this.commandButton, toFill.x - outsets.left, toFill.y - outsets.top, toFill.width + outsets.left + outsets.right, toFill.height + outsets.top + outsets.bottom, true);
            }
        }
        g2d.dispose();
    }

    protected void updateCustomDimension() {
        int dimension = this.commandButton.getCustomDimension();
        if (dimension > 0) {
            this.commandButton.getIcon().setDimension(new Dimension(dimension, dimension));
            this.commandButton.setDisplayState(CommandButtonDisplayState.FIT_TO_ICON);
            this.commandButton.invalidate();
            this.commandButton.revalidate();
            this.commandButton.doLayout();
            this.commandButton.repaint();
        }
    }

    protected void updatePopupActionIcon() {
        JCommandButton button = (JCommandButton)this.commandButton;
        this.popupActionIcon = button.getCommandButtonKind().hasPopup() ? this.createPopupActionIcon() : null;
    }

    protected void paintButtonIcon(Graphics g, Rectangle iconRect) {
        Icon iconToPaint = this.getIconToPaint();
        if (iconRect == null || iconToPaint == null || iconRect.width == 0 || iconRect.height == 0) {
            return;
        }
        iconToPaint.paintIcon(this.commandButton, g, iconRect.x, iconRect.y);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractCommandButton button = (AbstractCommandButton)c;
        return this.layoutManager.getPreferredSize(button);
    }

    @Override
    public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo() {
        if (this.layoutInfo != null) {
            return this.layoutInfo;
        }
        this.layoutInfo = this.layoutManager.getLayoutInfo(this.commandButton, this.commandButton.getGraphics());
        return this.layoutInfo;
    }

    protected int getLayoutGap() {
        Font font = this.commandButton.getFont();
        if (font == null) {
            font = UIManager.getFont("Button.font");
        }
        return (font.getSize() - 4) / 4;
    }

    protected boolean isPaintingSeparators() {
        boolean isPopupRollover;
        PopupButtonModel popupModel = this.commandButton instanceof JCommandButton ? ((JCommandButton)this.commandButton).getPopupModel() : null;
        boolean isActionRollover = this.commandButton.getActionModel().isRollover();
        boolean bl = isPopupRollover = popupModel != null && popupModel.isRollover();
        return isActionRollover || isPopupRollover;
    }

    protected boolean isPaintingBackground() {
        boolean isPopupArmed;
        PopupButtonModel popupModel = this.commandButton instanceof JCommandButton ? ((JCommandButton)this.commandButton).getPopupModel() : null;
        boolean isActionSelected = this.commandButton.getActionModel().isSelected();
        boolean isPopupSelected = popupModel != null && popupModel.isSelected();
        boolean isActionRollover = this.commandButton.getActionModel().isRollover();
        boolean isPopupRollover = popupModel != null && popupModel.isRollover();
        boolean isPopupShowing = popupModel != null && popupModel.isPopupShowing();
        boolean isActionArmed = this.commandButton.getActionModel().isArmed();
        boolean bl = isPopupArmed = popupModel != null && popupModel.isArmed();
        return isActionSelected || isPopupSelected || isActionRollover || isPopupRollover || isPopupShowing || isActionArmed || isPopupArmed || !this.commandButton.isFlat();
    }

    protected PopupActionListener createPopupActionListener() {
        return new PopupActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicCommandButtonUI.this.processPopupAction();
            }
        };
    }

    protected void processPopupAction() {
        JPopupPanel popupPanel;
        boolean wasPopupShowing = false;
        if (this.commandButton instanceof JCommandButton) {
            wasPopupShowing = ((JCommandButton)this.commandButton).getPopupModel().isPopupShowing();
        }
        PopupPanelManager.defaultManager().hidePopups(this.commandButton);
        if (!(this.commandButton instanceof JCommandButton)) {
            return;
        }
        if (wasPopupShowing) {
            return;
        }
        JCommandButton jcb = (JCommandButton)this.commandButton;
        PopupPanelCallback popupCallback = jcb.getPopupCallback();
        JPopupPanel jPopupPanel = popupPanel = popupCallback != null ? popupCallback.getPopupPanel(jcb) : null;
        if (popupPanel != null) {
            popupPanel.applyComponentOrientation(jcb.getComponentOrientation());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int ph;
                    if (BasicCommandButtonUI.this.commandButton == null || popupPanel == null) {
                        return;
                    }
                    if (!BasicCommandButtonUI.this.commandButton.isShowing()) {
                        return;
                    }
                    popupPanel.doLayout();
                    int x = 0;
                    int y = 0;
                    JPopupPanel.PopupPanelCustomizer customizer = popupPanel.getCustomizer();
                    boolean ltr = BasicCommandButtonUI.this.commandButton.getComponentOrientation().isLeftToRight();
                    if (customizer == null) {
                        switch (((JCommandButton)BasicCommandButtonUI.this.commandButton).getPopupOrientationKind()) {
                            case DOWNWARD: {
                                x = ltr ? BasicCommandButtonUI.this.commandButton.getLocationOnScreen().x : BasicCommandButtonUI.this.commandButton.getLocationOnScreen().x + BasicCommandButtonUI.this.commandButton.getWidth() - popupPanel.getPreferredSize().width;
                                y = BasicCommandButtonUI.this.commandButton.getLocationOnScreen().y + BasicCommandButtonUI.this.commandButton.getSize().height;
                                break;
                            }
                            case SIDEWARD: {
                                x = ltr ? BasicCommandButtonUI.this.commandButton.getLocationOnScreen().x + BasicCommandButtonUI.this.commandButton.getWidth() : BasicCommandButtonUI.this.commandButton.getLocationOnScreen().x - popupPanel.getPreferredSize().width;
                                y = BasicCommandButtonUI.this.commandButton.getLocationOnScreen().y + BasicCommandButtonUI.this.getLayoutInfo().popupClickArea.y;
                            }
                        }
                    } else {
                        Rectangle placementRect = customizer.getScreenBounds();
                        x = placementRect.x;
                        y = placementRect.y;
                    }
                    Rectangle scrBounds = BasicCommandButtonUI.this.commandButton.getGraphicsConfiguration().getBounds();
                    int pw = popupPanel.getPreferredSize().width;
                    if (x + pw > scrBounds.x + scrBounds.width) {
                        x = scrBounds.x + scrBounds.width - pw;
                    }
                    if (y + (ph = popupPanel.getPreferredSize().height) > scrBounds.y + scrBounds.height) {
                        y = scrBounds.y + scrBounds.height - ph;
                    }
                    if (customizer != null) {
                        Rectangle placementRect = customizer.getScreenBounds();
                        popupPanel.setPreferredSize(new Dimension(placementRect.width, placementRect.height));
                    }
                    Popup popup = PopupFactory.getSharedInstance().getPopup(BasicCommandButtonUI.this.commandButton, popupPanel, x, y);
                    PopupPanelManager.defaultManager().addPopup(BasicCommandButtonUI.this.commandButton, popup, popupPanel);
                }
            });
            return;
        }
    }

    protected void syncDisabledIcon() {
        ResizableIcon currDisabledIcon = this.commandButton.getDisabledIcon();
        ResizableIcon icon = this.commandButton.getIcon();
        if (currDisabledIcon == null || currDisabledIcon instanceof UIResource) {
            if (icon != null) {
                this.commandButton.setDisabledIcon(new ResizableIconUIResource(new FilteredResizableIcon(icon, new ColorConvertOp(ColorSpace.getInstance(1003), null))));
            } else {
                this.commandButton.setDisabledIcon(null);
            }
        } else if (icon != null) {
            this.commandButton.getDisabledIcon().setDimension(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        }
    }

    protected void syncIconDimension() {
        ResizableIcon icon = this.commandButton.getIcon();
        CommandButtonDisplayState commandButtonState = this.commandButton.getDisplayState();
        this.layoutManager = commandButtonState.createLayoutManager(this.commandButton);
        if (icon == null) {
            return;
        }
        int maxHeight = this.layoutManager.getPreferredIconSize();
        if (maxHeight < 0) {
            maxHeight = this.commandButton.getIcon().getIconHeight();
        }
        if (commandButtonState != CommandButtonDisplayState.FIT_TO_ICON) {
            Dimension newDim = new Dimension(maxHeight, maxHeight);
            icon.setDimension(newDim);
        }
    }

    @Override
    public Point getKeyTipAnchorCenterPoint() {
        return this.layoutManager.getKeyTipAnchorCenterPoint(this.commandButton);
    }
}

