/*
 * Decompiled with CFR 0.152.
 */
package test.bcb;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarExceptionHandler;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathEvent;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathListener;
import org.pushingpixels.flamingo.api.bcb.JBreadcrumbBar;
import org.pushingpixels.flamingo.api.bcb.core.BreadcrumbMultiSvnSelector;
import org.pushingpixels.flamingo.api.common.AbstractFileViewPanel;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import test.MessageListDialog;
import test.common.ExplorerFileViewPanel;

public class MultiSvnBreadCrumbTest
extends JFrame {
    private ExplorerFileViewPanel<String> filePanel;
    private BreadcrumbMultiSvnSelector bar = new BreadcrumbMultiSvnSelector(new BreadcrumbMultiSvnSelector.SvnRepositoryInfo("SVNKit", "http://svn.svnkit.com/repos/svnkit", "anonymous", "anonymous"), new BreadcrumbMultiSvnSelector.SvnRepositoryInfo("KDE", "svn://anonsvn.kde.org/home/kde/trunk", "anonymous", "anonymous"), new BreadcrumbMultiSvnSelector.SvnRepositoryInfo("Apache", "http://svn.apache.org/repos/asf", "anonymous", "anonymous"));

    public MultiSvnBreadCrumbTest() {
        super("BreadCrumb test");
        this.bar.setThrowsExceptions(true);
        this.bar.addExceptionHandler(new BreadcrumbBarExceptionHandler(){

            @Override
            public void onException(Throwable t) {
                MessageListDialog.showMessageDialog((Frame)MultiSvnBreadCrumbTest.this, "Error", t);
            }
        });
        this.bar.getModel().addPathListener(new BreadcrumbPathListener(){

            @Override
            public void breadcrumbPathEvent(BreadcrumbPathEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        final List newPath = MultiSvnBreadCrumbTest.this.bar.getModel().getItems();
                        System.out.println("New path is ");
                        for (BreadcrumbItem item : newPath) {
                            System.out.println("\t" + (String)item.getData());
                        }
                        if (newPath.size() > 0) {
                            SwingWorker<List<StringValuePair<String>>, Void> worker = new SwingWorker<List<StringValuePair<String>>, Void>(){

                                @Override
                                protected List<StringValuePair<String>> doInBackground() {
                                    return MultiSvnBreadCrumbTest.this.bar.getCallback().getLeafs(newPath);
                                }

                                @Override
                                protected void done() {
                                    try {
                                        List leafs = (List)this.get();
                                        MultiSvnBreadCrumbTest.this.filePanel.setFolder(leafs);
                                    }
                                    catch (Exception exc) {
                                        MessageListDialog.showMessageDialog((Frame)MultiSvnBreadCrumbTest.this, exc.getMessage(), exc);
                                    }
                                }
                            };
                            worker.execute();
                        }
                    }
                });
            }
        });
        JToolBar toolbar = new JToolBar();
        toolbar.setLayout(new BorderLayout(3, 0));
        toolbar.setFloatable(false);
        toolbar.add((Component)this.bar, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)toolbar, "North");
        this.filePanel = new ExplorerFileViewPanel<String>((JBreadcrumbBar)this.bar, CommandButtonDisplayState.MEDIUM, null){

            @Override
            protected void configureCommandButton(AbstractFileViewPanel.Leaf leaf, JCommandButton button, ResizableIcon icon) {
                long size = (Long)leaf.getLeafProp("size");
                Date date = (Date)leaf.getLeafProp("date");
                SimpleDateFormat sdf = new SimpleDateFormat("d MMM yyyy");
                button.setExtraText(String.valueOf(size) + " bytes, " + sdf.format(date));
            }
        };
        this.filePanel.setUseNativeIcons(true);
        JScrollPane fileListScrollPane = new JScrollPane(this.filePanel);
        this.add((Component)fileListScrollPane, "Center");
    }

    public static void main(String ... args) {
        try {
            System.setProperty("java.net.useSystemProxies", "true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MultiSvnBreadCrumbTest test = new MultiSvnBreadCrumbTest();
                test.setSize(550, 385);
                test.setLocationRelativeTo(null);
                test.setVisible(true);
                test.setDefaultCloseOperation(3);
            }
        });
    }

    public static class SvnFolderListModel
    extends AbstractListModel {
        private ArrayList<String> entries = new ArrayList();

        public void add(String entry) {
            this.entries.add(entry);
        }

        public void sort() {
            Collections.sort(this.entries);
        }

        @Override
        public Object getElementAt(int index) {
            return this.entries.get(index);
        }

        @Override
        public int getSize() {
            return this.entries.size();
        }
    }
}

