/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import test.common.TestCommandToggleButtons;
import test.svg.transcoded.edit_paste;

public class TestCommandToggleButtonsNoIcon
extends TestCommandToggleButtons {
    @Override
    protected JCommandToggleButton createToggleButton(CommandButtonDisplayState state, String title) {
        JCommandToggleButton mainButton = new JCommandToggleButton(title);
        mainButton.setExtraText(this.resourceBundle.getString("SelectAll.textExtra"));
        mainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(String.valueOf(TestCommandToggleButtonsNoIcon.stamp()) + ": Main selection");
            }
        });
        mainButton.setDisplayState(state);
        mainButton.setFlat(false);
        return mainButton;
    }

    @Override
    protected void configureControlPanel(JPanel controlPanel) {
        super.configureControlPanel(controlPanel);
        final JCheckBox noIcon = new JCheckBox("no icon");
        noIcon.setSelected(true);
        noIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TestCommandToggleButtonsNoIcon.apply(TestCommandToggleButtonsNoIcon.this, new Command(){

                            @Override
                            public void apply(JCommandToggleButton button) {
                                button.setIcon(noIcon.isSelected() ? null : new edit_paste());
                            }
                        });
                        TestCommandToggleButtonsNoIcon.this.getContentPane().invalidate();
                        TestCommandToggleButtonsNoIcon.this.getContentPane().validate();
                    }
                });
            }
        });
        controlPanel.add(noIcon);
    }

    private static void apply(Container cont, Command cmd) {
        int i = 0;
        while (i < cont.getComponentCount()) {
            Component comp = cont.getComponent(i);
            if (comp instanceof JCommandToggleButton) {
                JCommandToggleButton cb = (JCommandToggleButton)comp;
                cmd.apply(cb);
            }
            if (comp instanceof Container) {
                TestCommandToggleButtonsNoIcon.apply((Container)comp, cmd);
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(new MetalLookAndFeel());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                TestCommandToggleButtonsNoIcon frame = new TestCommandToggleButtonsNoIcon();
                frame.setSize(800, 400);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                frame.setDefaultCloseOperation(2);
            }
        });
    }

    private static interface Command {
        public void apply(JCommandToggleButton var1);
    }
}

