/*
 * Decompiled with CFR 0.152.
 */
package test.ribbon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.internal.utils.RenderingUtils;

public class NumberedResizableIcon
implements ResizableIcon {
    private int currWidth;
    private int currHeight;
    private int origWidth;
    private int origHeight;
    private int count;

    public NumberedResizableIcon(int count, int startWidth, int startHeight) {
        this.origWidth = startWidth;
        this.origHeight = startHeight;
        this.currWidth = startWidth;
        this.currHeight = startHeight;
        this.count = count;
    }

    @Override
    public void setDimension(Dimension newDimension) {
        this.currWidth = newDimension.width;
        this.currHeight = newDimension.height;
    }

    @Override
    public int getIconHeight() {
        return this.currHeight;
    }

    @Override
    public int getIconWidth() {
        return this.currWidth;
    }

    public void setHeight(int height) {
        double coef = (double)height / (double)this.currHeight;
        this.currWidth = (int)(coef * (double)this.currWidth);
        this.currHeight = height;
    }

    public void setWidth(int width) {
        double coef = (double)width / (double)this.currWidth;
        this.currHeight = (int)(coef * (double)this.currHeight);
        this.currWidth = width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RenderingUtils.installDesktopHints(graphics);
        graphics.setColor(new Color(40, 70, 20));
        graphics.setFont(new Font("Tahoma", 1, 14));
        String toPrint = "" + this.count;
        int strWidth = graphics.getFontMetrics().stringWidth(toPrint);
        int strHeight = graphics.getFontMetrics().getHeight();
        graphics.drawString(toPrint, x + (this.currWidth - strWidth) / 2, y + (this.currHeight + strHeight) / 2);
        graphics.drawRect(x, y, this.currWidth - 2, this.currHeight - 2);
        graphics.dispose();
    }

    public void revertToOriginalDimension() {
        this.currHeight = this.origHeight;
        this.currWidth = this.origWidth;
    }
}

