/*
 * Decompiled with CFR 0.152.
 */
package test.ribbon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.common.icon.DecoratedResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonGallery;
import test.ribbon.DisabledResizableIcon;

public class RibbonGalleryCheck
extends JRibbonFrame {
    JCommandToggleButton[][] buttons = new JCommandToggleButton[4][10];
    JRibbonGallery gallery;
    JRibbonBand ribbonBand;
    static final String GALLERY_NAME = "Gallery";

    public RibbonGalleryCheck() {
        super("Ribbon gallery check");
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 10) {
                this.buttons[i][j] = new JCommandToggleButton("Button " + i + ":" + j, new DecoratedResizableIcon(new DisabledResizableIcon(RibbonElementPriority.TOP, 32, 32), new TopLeftDecoration(i), new BottomRightDecoration(j)));
                ++j;
            }
            ++i;
        }
        this.ribbonBand = new JRibbonBand("Band", new EmptyResizableIcon(32));
        HashMap<RibbonElementPriority, Integer> visibleButtonCounts = new HashMap<RibbonElementPriority, Integer>();
        visibleButtonCounts.put(RibbonElementPriority.LOW, 4);
        visibleButtonCounts.put(RibbonElementPriority.MEDIUM, 5);
        visibleButtonCounts.put(RibbonElementPriority.TOP, 6);
        ArrayList<StringValuePair<List<JCommandToggleButton>>> galleryButtons = new ArrayList<StringValuePair<List<JCommandToggleButton>>>();
        int i2 = 0;
        while (i2 < 4) {
            ArrayList<JCommandToggleButton> galleryButtonsList = new ArrayList<JCommandToggleButton>();
            int j = 0;
            while (j < 10) {
                galleryButtonsList.add(this.buttons[i2][j]);
                ++j;
            }
            galleryButtons.add(new StringValuePair("Group " + i2, galleryButtonsList));
            ++i2;
        }
        this.ribbonBand.addRibbonGallery(GALLERY_NAME, galleryButtons, visibleButtonCounts, 6, 4, RibbonElementPriority.TOP);
        this.gallery = ((JBandControlPanel)this.ribbonBand.getControlPanel()).getRibbonGallery(GALLERY_NAME);
        this.getRibbon().addTask(new RibbonTask("Task 1", this.ribbonBand));
        JPanel controlPanel = new JPanel(new FlowLayout(2));
        JButton addToGroup0 = new JButton("Add one to 0");
        addToGroup0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCommandToggleButton toAdd = new JCommandToggleButton("Button 0 new", new DecoratedResizableIcon(new DisabledResizableIcon(RibbonElementPriority.TOP, 32, 32), new TopLeftDecoration(0), new BottomRightDecoration(99)));
                RibbonGalleryCheck.this.ribbonBand.addRibbonGalleryButtons(RibbonGalleryCheck.GALLERY_NAME, "Group 0", toAdd);
            }
        });
        controlPanel.add(addToGroup0);
        JButton addToGroup2 = new JButton("Add two to 2");
        addToGroup2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCommandToggleButton toAdd = new JCommandToggleButton("Button 2 new", new DecoratedResizableIcon(new DisabledResizableIcon(RibbonElementPriority.TOP, 32, 32), new TopLeftDecoration(2), new BottomRightDecoration(99)));
                JCommandToggleButton toAdd2 = new JCommandToggleButton("Button 2 new 2", new DecoratedResizableIcon(new DisabledResizableIcon(RibbonElementPriority.TOP, 32, 32), new TopLeftDecoration(2), new BottomRightDecoration(66)));
                RibbonGalleryCheck.this.ribbonBand.addRibbonGalleryButtons(RibbonGalleryCheck.GALLERY_NAME, "Group 2", toAdd, toAdd2);
            }
        });
        controlPanel.add(addToGroup2);
        this.add((Component)controlPanel, "South");
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RibbonGalleryCheck c = new RibbonGalleryCheck();
                Rectangle r = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                c.setPreferredSize(new Dimension(r.width, r.height / 2));
                c.pack();
                c.setLocation(r.x, r.y);
                c.setVisible(true);
                c.setDefaultCloseOperation(2);
            }
        });
    }

    private static class BottomRightDecoration
    implements DecoratedResizableIcon.IconDecorator {
        int number;

        public BottomRightDecoration(int number) {
            this.number = number;
        }

        @Override
        public void paintIconDecoration(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.red.darker());
            g.drawString("" + this.number, x + width - g.getFontMetrics().stringWidth("" + this.number) - 2, y + height - g.getFontMetrics().getDescent());
        }
    }

    private static class TopLeftDecoration
    implements DecoratedResizableIcon.IconDecorator {
        int number;

        public TopLeftDecoration(int number) {
            this.number = number;
        }

        @Override
        public void paintIconDecoration(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.blue.darker());
            g.drawString("" + this.number, x + 2, y + g.getFontMetrics().getAscent());
        }
    }
}

