/*
 * Decompiled with CFR 0.152.
 */
package utest.common;

import java.awt.FlowLayout;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JSeparator;
import org.fest.assertions.Assertions;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.junit.testcase.FestSwingJUnitTestCase;
import org.junit.Before;
import org.junit.Test;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import test.svg.transcoded.edit_cut;
import test.svg.transcoded.edit_paste;

public class CommandButtonNoIconSizesTestCase
extends FestSwingJUnitTestCase {
    JFrame buttonFrame;
    JCommandButton button1;
    JCommandButton button2;

    @Override
    @Before
    public void onSetUp() {
        edit_paste icon1 = new edit_paste();
        edit_cut icon2 = new edit_cut();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.buttonFrame = new JFrame();
                CommandButtonNoIconSizesTestCase.this.buttonFrame.setLayout(new FlowLayout());
                CommandButtonNoIconSizesTestCase.this.button1 = new JCommandButton("test");
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.BIG);
                CommandButtonNoIconSizesTestCase.this.buttonFrame.add(CommandButtonNoIconSizesTestCase.this.button1);
                CommandButtonNoIconSizesTestCase.this.button2 = new JCommandButton("test");
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.BIG);
                CommandButtonNoIconSizesTestCase.this.buttonFrame.add(CommandButtonNoIconSizesTestCase.this.button2);
                CommandButtonNoIconSizesTestCase.this.buttonFrame.setSize(300, 200);
                CommandButtonNoIconSizesTestCase.this.buttonFrame.setLocationRelativeTo(null);
                CommandButtonNoIconSizesTestCase.this.buttonFrame.setDefaultCloseOperation(2);
                CommandButtonNoIconSizesTestCase.this.buttonFrame.setVisible(true);
            }
        });
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                Point locOnScreen = CommandButtonNoIconSizesTestCase.this.buttonFrame.getLocationOnScreen();
                locOnScreen.move(10, 20);
                CommandButtonNoIconSizesTestCase.this.robot().moveMouse(locOnScreen);
            }
        });
    }

    @Test
    public void actionOnlyBigAndActionOnlyBigHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.BIG);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.BIG);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().height - CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void splitBigAndSplitBigHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.BIG);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.BIG);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().height - CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void popupOnlyBigAndSplitBigHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.BIG);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.BIG);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().height - CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlyBigAndActionOnlyTileHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.BIG);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.TILE);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().height - CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlyTileAndActionOnlyTileHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.TILE);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.TILE);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().height - CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlyTileAndActionOnlyBigHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.TILE);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.BIG);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().height - CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlyTileAndSplitTileHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.TILE);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.TILE);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().height - CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlyTileAndSplit2TileHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.TILE);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.TILE);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().height - CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlyTileAndPopupOnlyTileHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.TILE);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.TILE);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().height - CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void splitTileAndSplitTileHaveDifferentWidth() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.TILE);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.TILE);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().width - CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().width;
            }
        })).isEqualTo(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return new JSeparator((int)1).getPreferredSize().width;
            }
        }));
    }

    @Test
    public void popupOnlyTileAndSplitTileHaveSameWidth() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.TILE);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.TILE);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().width - CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().width;
            }
        })).isZero();
    }

    @Test
    public void actionOnlyMediumAndActionOnlyMediumHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.MEDIUM);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.MEDIUM);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().height - CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlyMediumAndSplitMediumHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.MEDIUM);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.MEDIUM);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().height - CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlyMediumAndSplit2MediumHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.MEDIUM);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.MEDIUM);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().height - CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlyMediumAndPopupOnlyMediumHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.MEDIUM);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.MEDIUM);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().height - CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void splitMediumAndSplitMediumHaveDifferentWidth() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.MEDIUM);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.MEDIUM);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().width - CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().width;
            }
        })).isEqualTo(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return new JSeparator((int)1).getPreferredSize().width;
            }
        }));
    }

    @Test
    public void popupOnlyMediumAndSplitMediumHaveSameWidth() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.MEDIUM);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.MEDIUM);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().width - CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().width;
            }
        })).isZero();
    }

    @Test
    public void actionOnlyMediumAndActionOnlySmallHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.MEDIUM);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.SMALL);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().height - CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlySmallAndActionOnlySmallHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.SMALL);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.SMALL);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().height - CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlySmallAndSplitSmallHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.SMALL);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.SMALL);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().height - CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlySmallAndSplit2SmallHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.SMALL);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.SMALL);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().height - CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlySmallAndPopupOnlySmallHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.SMALL);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.SMALL);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().height - CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void splitSmallAndSplitSmallHaveSameWidth() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.SMALL);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.SMALL);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().width - CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().width;
            }
        })).isZero();
    }

    @Test
    public void popupOnlySmallAndSplitSmallHaveSameWidth() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonNoIconSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                CommandButtonNoIconSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonNoIconSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.SMALL);
                CommandButtonNoIconSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.SMALL);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonNoIconSizesTestCase.this.button2.getPreferredSize().width - CommandButtonNoIconSizesTestCase.this.button1.getPreferredSize().width;
            }
        })).isZero();
    }
}

