/*
 * Decompiled with CFR 0.152.
 */
package utest.ribbon;

import java.awt.Color;
import org.fest.assertions.Assertions;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.junit.testcase.FestSwingJUnitTestCase;
import org.junit.Test;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;

public class RibbonBandTestCase
extends FestSwingJUnitTestCase {
    private JRibbonFrame frame;
    private JRibbonBand band11;
    private JRibbonBand band12;
    private JRibbonBand band21;
    private JRibbonBand band22;
    private RibbonTask task1;
    private RibbonTask task2;
    private RibbonTask taskCont1_1;
    private RibbonTask taskCont1_2;
    private RibbonTask taskCont1_3;
    private RibbonContextualTaskGroup taskGroup1;
    private RibbonContextualTaskGroup taskGroup2;

    @Override
    protected void onSetUp() {
        GuiActionRunner.execute(new GuiTask(){

            private JRibbonBand createBand(int buttonCount, String title, String titlePrefix) {
                JRibbonBand result = new JRibbonBand(title, new EmptyResizableIcon(32));
                int i = 0;
                while (i < buttonCount) {
                    result.addCommandButton(new JCommandButton(String.valueOf(titlePrefix) + (i + 1), new EmptyResizableIcon(32)), RibbonElementPriority.TOP);
                    ++i;
                }
                return result;
            }

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandTestCase.this.frame = new JRibbonFrame();
                JRibbon ribbon = RibbonBandTestCase.this.frame.getRibbon();
                RibbonBandTestCase.this.band11 = this.createBand(5, "Band 11", "Test 11");
                RibbonBandTestCase.this.band12 = this.createBand(6, "Band 12", "Test 12");
                RibbonBandTestCase.this.task1 = new RibbonTask("Task1", RibbonBandTestCase.this.band11, RibbonBandTestCase.this.band12);
                ribbon.addTask(RibbonBandTestCase.this.task1);
                RibbonBandTestCase.this.band21 = this.createBand(5, "Band 21", "Test 21");
                RibbonBandTestCase.this.band22 = this.createBand(6, "Band 22", "Test 22");
                RibbonBandTestCase.this.task2 = new RibbonTask("Task2", RibbonBandTestCase.this.band21, RibbonBandTestCase.this.band22);
                ribbon.addTask(RibbonBandTestCase.this.task2);
                RibbonBandTestCase.this.taskCont1_1 = new RibbonTask("Context task 1 1", this.createBand(6, "Context 11", "Test 11"));
                RibbonBandTestCase.this.taskCont1_2 = new RibbonTask("Context task 1 2", this.createBand(6, "Context 12", "Test 12"));
                RibbonBandTestCase.this.taskCont1_3 = new RibbonTask("Context task 1 3", this.createBand(6, "Context 13", "Test 13"));
                RibbonBandTestCase.this.taskGroup1 = new RibbonContextualTaskGroup("Context 1", Color.red, RibbonBandTestCase.this.taskCont1_1, RibbonBandTestCase.this.taskCont1_2, RibbonBandTestCase.this.taskCont1_3);
                ribbon.addContextualTaskGroup(RibbonBandTestCase.this.taskGroup1);
                RibbonTask taskCont2_1 = new RibbonTask("Context task 2 1", this.createBand(6, "Context 21", "Test 21"));
                RibbonTask taskCont2_2 = new RibbonTask("Context task 2 2", this.createBand(6, "Context 22", "Test 22"));
                RibbonBandTestCase.this.taskGroup2 = new RibbonContextualTaskGroup("Context 2", Color.blue, taskCont2_1, taskCont2_2);
                ribbon.addContextualTaskGroup(RibbonBandTestCase.this.taskGroup2);
                RibbonBandTestCase.this.frame.setSize(600, 300);
                RibbonBandTestCase.this.frame.setLocationRelativeTo(null);
                RibbonBandTestCase.this.frame.setDefaultCloseOperation(2);
                RibbonBandTestCase.this.frame.setVisible(true);
            }
        });
    }

    @Test
    public void testBands() {
        Assertions.assertThat(this.task1.getBandCount()).isEqualTo(2);
        Assertions.assertThat(this.frame.getRibbon().getSelectedTask().getBandCount()).isEqualTo(2);
        Assertions.assertThat(this.frame.getRibbon().getSelectedTask().getBands().size()).isEqualTo(2);
    }

    @Test
    public void testSelectedTask() {
        Assertions.assertThat(this.frame.getRibbon().getSelectedTask()).isEqualTo(this.task1);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandTestCase.this.frame.getRibbon().setSelectedTask(RibbonBandTestCase.this.task1);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.frame.getRibbon().getSelectedTask()).isEqualTo(this.task1);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandTestCase.this.frame.getRibbon().setSelectedTask(RibbonBandTestCase.this.task1);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.frame.getRibbon().getSelectedTask()).isEqualTo(this.task1);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandTestCase.this.frame.getRibbon().setSelectedTask(RibbonBandTestCase.this.task2);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.frame.getRibbon().getSelectedTask()).isEqualTo(this.task2);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandTestCase.this.frame.getRibbon().setSelectedTask(RibbonBandTestCase.this.task2);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.frame.getRibbon().getSelectedTask()).isEqualTo(this.task2);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandTestCase.this.frame.getRibbon().setSelectedTask(RibbonBandTestCase.this.task1);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.frame.getRibbon().getSelectedTask()).isEqualTo(this.task1);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandTestCase.this.frame.getRibbon().setSelectedTask(RibbonBandTestCase.this.task2);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.frame.getRibbon().getSelectedTask()).isEqualTo(this.task2);
    }

    @Test
    public void testSetTaskTitle() {
        Assertions.assertThat(this.task1.getTitle()).isEqualTo("Task1");
        Assertions.assertThat(this.task2.getTitle()).isEqualTo("Task2");
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandTestCase.this.task1.setTitle("NewTask1");
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.task1.getTitle()).isEqualTo("NewTask1");
        Assertions.assertThat(this.task2.getTitle()).isEqualTo("Task2");
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandTestCase.this.task1.setTitle("NewTask11");
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.task1.getTitle()).isEqualTo("NewTask11");
        Assertions.assertThat(this.task2.getTitle()).isEqualTo("Task2");
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandTestCase.this.task2.setTitle("NewTask2");
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.task1.getTitle()).isEqualTo("NewTask11");
        Assertions.assertThat(this.task2.getTitle()).isEqualTo("NewTask2");
        Assertions.assertThat(this.task1.getTitle()).isEqualTo("NewTask11");
        Assertions.assertThat(this.task2.getTitle()).isEqualTo("NewTask2");
        Assertions.assertThat(this.taskCont1_1.getTitle()).isEqualTo("Context task 1 1");
        Assertions.assertThat(this.taskCont1_2.getTitle()).isEqualTo("Context task 1 2");
        Assertions.assertThat(this.taskCont1_3.getTitle()).isEqualTo("Context task 1 3");
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandTestCase.this.taskCont1_1.setTitle("New Context task 1 1");
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.task1.getTitle()).isEqualTo("NewTask11");
        Assertions.assertThat(this.task2.getTitle()).isEqualTo("NewTask2");
        Assertions.assertThat(this.taskCont1_1.getTitle()).isEqualTo("New Context task 1 1");
        Assertions.assertThat(this.taskCont1_2.getTitle()).isEqualTo("Context task 1 2");
        Assertions.assertThat(this.taskCont1_3.getTitle()).isEqualTo("Context task 1 3");
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandTestCase.this.taskCont1_2.setTitle("New Context task 1 2");
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.task1.getTitle()).isEqualTo("NewTask11");
        Assertions.assertThat(this.task2.getTitle()).isEqualTo("NewTask2");
        Assertions.assertThat(this.taskCont1_1.getTitle()).isEqualTo("New Context task 1 1");
        Assertions.assertThat(this.taskCont1_2.getTitle()).isEqualTo("New Context task 1 2");
        Assertions.assertThat(this.taskCont1_3.getTitle()).isEqualTo("Context task 1 3");
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandTestCase.this.taskCont1_3.setTitle("New Context task 1 3");
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.task1.getTitle()).isEqualTo("NewTask11");
        Assertions.assertThat(this.task2.getTitle()).isEqualTo("NewTask2");
        Assertions.assertThat(this.taskCont1_1.getTitle()).isEqualTo("New Context task 1 1");
        Assertions.assertThat(this.taskCont1_2.getTitle()).isEqualTo("New Context task 1 2");
        Assertions.assertThat(this.taskCont1_3.getTitle()).isEqualTo("New Context task 1 3");
    }

    @Test
    public void testSetBandTitle() {
        Assertions.assertThat(this.band11.getTitle()).isEqualTo("Band 11");
        Assertions.assertThat(this.band12.getTitle()).isEqualTo("Band 12");
        Assertions.assertThat(this.band21.getTitle()).isEqualTo("Band 21");
        Assertions.assertThat(this.band22.getTitle()).isEqualTo("Band 22");
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandTestCase.this.band11.setTitle("New Band 1 1");
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.band11.getTitle()).isEqualTo("New Band 1 1");
        Assertions.assertThat(this.band12.getTitle()).isEqualTo("Band 12");
        Assertions.assertThat(this.band21.getTitle()).isEqualTo("Band 21");
        Assertions.assertThat(this.band22.getTitle()).isEqualTo("Band 22");
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandTestCase.this.band12.setTitle("New Band 1 2");
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.band11.getTitle()).isEqualTo("New Band 1 1");
        Assertions.assertThat(this.band12.getTitle()).isEqualTo("New Band 1 2");
        Assertions.assertThat(this.band21.getTitle()).isEqualTo("Band 21");
        Assertions.assertThat(this.band22.getTitle()).isEqualTo("Band 22");
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandTestCase.this.band21.setTitle("New Band 2 1");
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.band11.getTitle()).isEqualTo("New Band 1 1");
        Assertions.assertThat(this.band12.getTitle()).isEqualTo("New Band 1 2");
        Assertions.assertThat(this.band21.getTitle()).isEqualTo("New Band 2 1");
        Assertions.assertThat(this.band22.getTitle()).isEqualTo("Band 22");
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandTestCase.this.band22.setTitle("New Band 2 2");
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.band11.getTitle()).isEqualTo("New Band 1 1");
        Assertions.assertThat(this.band12.getTitle()).isEqualTo("New Band 1 2");
        Assertions.assertThat(this.band21.getTitle()).isEqualTo("New Band 2 1");
        Assertions.assertThat(this.band22.getTitle()).isEqualTo("New Band 2 2");
    }

    @Test
    public void testSetContextualTaskGroupTitle() {
        Assertions.assertThat(this.taskGroup1.getTitle()).isEqualTo("Context 1");
        Assertions.assertThat(this.taskGroup2.getTitle()).isEqualTo("Context 2");
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandTestCase.this.taskGroup1.setTitle("New Context 1");
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.taskGroup1.getTitle()).isEqualTo("New Context 1");
        Assertions.assertThat(this.taskGroup2.getTitle()).isEqualTo("Context 2");
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandTestCase.this.taskGroup2.setTitle("New Context 2");
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.taskGroup1.getTitle()).isEqualTo("New Context 1");
        Assertions.assertThat(this.taskGroup2.getTitle()).isEqualTo("New Context 2");
    }
}

