/*
 * Decompiled with CFR 0.152.
 */
package utest.ribbon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.UIManager;
import junit.framework.TestCase;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.DecoratedResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.flamingo.api.ribbon.resize.IconRibbonBandResizePolicy;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonTaskToggleButton;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.flamingo.internal.utils.RenderingUtils;
import test.common.SamplePopupMenu;
import test.svg.transcoded.edit_copy;
import test.svg.transcoded.edit_cut;
import test.svg.transcoded.edit_paste;
import test.svg.transcoded.font_x_generic;

public class RibbonMinimizedTestCase
extends TestCase {
    private JRibbonFrame ribbonFrame;
    private JRibbon ribbon;

    private JRibbonBand getClipboardBand() {
        JRibbonBand clipboardBand = new JRibbonBand("Clipboard", new edit_paste());
        clipboardBand.setExpandButtonKeyTip("FO");
        JCommandButton mainButton = new JCommandButton("Paste", new edit_paste());
        mainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Pasted!");
            }
        });
        mainButton.setPopupCallback(new PopupPanelCallback(){

            @Override
            public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                return new SamplePopupMenu(commandButton.getComponentOrientation());
            }
        });
        mainButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
        RichTooltip mainRichTooltip = new RichTooltip();
        mainRichTooltip.setTitle("Paste");
        mainRichTooltip.addDescriptionSection("Paste the contents of the Clipboard");
        mainButton.setActionRichTooltip(mainRichTooltip);
        mainButton.setPopupKeyTip("V");
        RichTooltip mainPopupRichTooltip = new RichTooltip();
        mainPopupRichTooltip.setTitle("Paste");
        mainPopupRichTooltip.addDescriptionSection("Click here for more options such as pasting only the values or formatting");
        mainButton.setPopupRichTooltip(mainPopupRichTooltip);
        clipboardBand.addCommandButton(mainButton, RibbonElementPriority.TOP);
        JCommandButton cutButton = new JCommandButton("Cut", new edit_cut());
        cutButton.setPopupCallback(new PopupPanelCallback(){

            @Override
            public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                return new SamplePopupMenu(commandButton.getComponentOrientation());
            }
        });
        cutButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
        RichTooltip cutRichTooltip = new RichTooltip();
        cutRichTooltip.setTitle("Cut");
        cutRichTooltip.addDescriptionSection("Cut the selection from the document and put it on the Clipboard");
        cutButton.setActionRichTooltip(cutRichTooltip);
        cutButton.setPopupKeyTip("X");
        clipboardBand.addCommandButton(cutButton, RibbonElementPriority.MEDIUM);
        JCommandButton copyButton = new JCommandButton("Copy", new edit_copy());
        copyButton.setPopupCallback(new PopupPanelCallback(){

            @Override
            public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                return new SamplePopupMenu(commandButton.getComponentOrientation());
            }
        });
        copyButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
        copyButton.setPopupKeyTip("C");
        clipboardBand.addCommandButton(copyButton, RibbonElementPriority.MEDIUM);
        JCommandButton formatButton = new JCommandButton("Format", new edit_paste());
        formatButton.setPopupCallback(new PopupPanelCallback(){

            @Override
            public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                JCommandPopupMenu popupMenu = new JCommandPopupMenu(new QuickStylesPanel(), 5, 3);
                JCommandMenuButton saveSelectionButton = new JCommandMenuButton("Save Selection", new EmptyResizableIcon(16));
                saveSelectionButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("Save Selection activated");
                    }
                });
                saveSelectionButton.setActionKeyTip("SS");
                popupMenu.addMenuButton(saveSelectionButton);
                JCommandMenuButton clearSelectionButton = new JCommandMenuButton("Clear Selection", new EmptyResizableIcon(16));
                clearSelectionButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("Clear Selection activated");
                    }
                });
                clearSelectionButton.setActionKeyTip("SC");
                popupMenu.addMenuButton(clearSelectionButton);
                popupMenu.addMenuSeparator();
                JCommandMenuButton applyStylesButton = new JCommandMenuButton("Apply Styles", new EmptyResizableIcon(16));
                applyStylesButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("Apply Styles activated");
                    }
                });
                applyStylesButton.setActionKeyTip("SA");
                popupMenu.addMenuButton(applyStylesButton);
                return popupMenu;
            }
        });
        formatButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        formatButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        formatButton.setPopupKeyTip("FP");
        clipboardBand.addCommandButton(formatButton, RibbonElementPriority.MEDIUM);
        ArrayList<RibbonBandResizePolicy> resizePolicies = new ArrayList<RibbonBandResizePolicy>();
        resizePolicies.add(new CoreRibbonResizePolicies.Mirror((JBandControlPanel)clipboardBand.getControlPanel()));
        resizePolicies.add(new CoreRibbonResizePolicies.Mid2Low((JBandControlPanel)clipboardBand.getControlPanel()));
        resizePolicies.add(new IconRibbonBandResizePolicy((AbstractBandControlPanel)clipboardBand.getControlPanel()));
        clipboardBand.setResizePolicies(resizePolicies);
        return clipboardBand;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.ribbonFrame = new JRibbonFrame();
        this.ribbon = this.ribbonFrame.getRibbon();
        RibbonTask task = new RibbonTask("Task", this.getClipboardBand());
        this.ribbon.addTask(task);
        Rectangle r = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        this.ribbonFrame.setPreferredSize(new Dimension(r.width, r.height / 2));
        this.ribbonFrame.pack();
        this.ribbonFrame.setLocation(r.x, r.y);
        this.ribbonFrame.setVisible(true);
        this.ribbonFrame.setDefaultCloseOperation(2);
    }

    public void testMinimizeWithAPI() throws Exception {
        RibbonMinimizedTestCase.assertFalse(this.ribbon.isMinimized());
        this.ribbon.setMinimized(true);
        RibbonMinimizedTestCase.assertTrue(this.ribbon.isMinimized());
    }

    public void testMinimizeWithKeyboard() throws Exception {
        RibbonMinimizedTestCase.assertFalse(this.ribbon.isMinimized());
        Robot robot = new Robot();
        robot.setAutoDelay(300);
        robot.keyPress(17);
        robot.keyPress(112);
        robot.keyRelease(112);
        robot.keyRelease(17);
        RibbonMinimizedTestCase.assertTrue(this.ribbon.isMinimized());
    }

    public void testMinimizeWithMouse() throws Exception {
        RibbonMinimizedTestCase.assertFalse(this.ribbon.isMinimized());
        JRibbonTaskToggleButton taskButton = RibbonMinimizedTestCase.getTaskButton(this.ribbon, "Task");
        RibbonMinimizedTestCase.assertNotNull(taskButton);
        Robot robot = new Robot();
        robot.setAutoDelay(20);
        Point taskButtonLoc = taskButton.getLocationOnScreen();
        robot.mouseMove(taskButtonLoc.x + taskButton.getWidth() / 2, taskButtonLoc.y + taskButton.getHeight() / 2);
        robot.mousePress(16);
        robot.mouseRelease(16);
        robot.mousePress(16);
        robot.mouseRelease(16);
        RibbonMinimizedTestCase.assertTrue(this.ribbon.isMinimized());
    }

    public void testMinimizeAndPopup() throws Exception {
        this.ribbon.setMinimized(true);
        JRibbonTaskToggleButton taskButton = RibbonMinimizedTestCase.getTaskButton(this.ribbon, "Task");
        RibbonMinimizedTestCase.assertNotNull(taskButton);
        Robot robot = new Robot();
        Point taskButtonLoc = taskButton.getLocationOnScreen();
        robot.mouseMove(taskButtonLoc.x + taskButton.getWidth() / 2, taskButtonLoc.y + taskButton.getHeight() / 2);
        robot.mousePress(16);
        Thread.sleep(100L);
        RibbonMinimizedTestCase.assertTrue(this.ribbon.isMinimized());
        RibbonMinimizedTestCase.assertTrue(FlamingoUtilities.isShowingMinimizedRibbonInPopup(this.ribbon));
        robot.mouseRelease(16);
        RibbonMinimizedTestCase.assertTrue(this.ribbon.isMinimized());
        RibbonMinimizedTestCase.assertTrue(FlamingoUtilities.isShowingMinimizedRibbonInPopup(this.ribbon));
        Thread.sleep(100L);
        robot.mousePress(16);
        Thread.sleep(100L);
        RibbonMinimizedTestCase.assertTrue(this.ribbon.isMinimized());
        RibbonMinimizedTestCase.assertFalse(FlamingoUtilities.isShowingMinimizedRibbonInPopup(this.ribbon));
        robot.mouseRelease(16);
        RibbonMinimizedTestCase.assertTrue(this.ribbon.isMinimized());
        RibbonMinimizedTestCase.assertFalse(FlamingoUtilities.isShowingMinimizedRibbonInPopup(this.ribbon));
    }

    private static JRibbonTaskToggleButton getTaskButton(Component c, String title) {
        if (c instanceof JRibbonTaskToggleButton && title.equals(((JRibbonTaskToggleButton)c).getText())) {
            return (JRibbonTaskToggleButton)c;
        }
        if (c instanceof Container) {
            Container cont = (Container)c;
            int i = 0;
            while (i < cont.getComponentCount()) {
                JRibbonTaskToggleButton result = RibbonMinimizedTestCase.getTaskButton(cont.getComponent(i), title);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        }
        return null;
    }

    public void testCommandButtonPopupInMinimizedRibbon() throws Exception {
        this.ribbon.setMinimized(true);
        JRibbonTaskToggleButton taskButton = RibbonMinimizedTestCase.getTaskButton(this.ribbon, "Task");
        RibbonMinimizedTestCase.assertNotNull(taskButton);
        Robot robot = new Robot();
        Point taskButtonLoc = taskButton.getLocationOnScreen();
        robot.mouseMove(taskButtonLoc.x + taskButton.getWidth() / 2, taskButtonLoc.y + taskButton.getHeight() / 2);
        robot.mousePress(16);
        Thread.sleep(200L);
        robot.mouseRelease(16);
        RibbonMinimizedTestCase.assertTrue(this.ribbon.isMinimized());
        RibbonMinimizedTestCase.assertTrue(FlamingoUtilities.isShowingMinimizedRibbonInPopup(this.ribbon));
        List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
        RibbonMinimizedTestCase.assertTrue(popups.size() > 0);
        JPopupPanel currPopupPanel = popups.get(popups.size() - 1).getPopupPanel();
        JCommandButton cutButton = RibbonMinimizedTestCase.getCommandButton(currPopupPanel, "Cut");
        RibbonMinimizedTestCase.assertNotNull(cutButton);
        Point cutButtonLoc = cutButton.getLocationOnScreen();
        Rectangle cutPopupArea = cutButton.getUI().getLayoutInfo().popupClickArea;
        robot.mouseMove(cutButtonLoc.x + cutPopupArea.x + cutPopupArea.width / 2, cutButtonLoc.y + cutPopupArea.y + cutPopupArea.height / 2);
        robot.mousePress(16);
        Thread.sleep(100L);
        robot.mouseRelease(16);
        RibbonMinimizedTestCase.assertTrue(this.ribbon.isMinimized());
        RibbonMinimizedTestCase.assertTrue(FlamingoUtilities.isShowingMinimizedRibbonInPopup(this.ribbon));
        RibbonMinimizedTestCase.assertTrue(cutButton.getPopupModel().isPopupShowing());
        robot.mousePress(16);
        Thread.sleep(100L);
        robot.mouseRelease(16);
        RibbonMinimizedTestCase.assertTrue(this.ribbon.isMinimized());
        RibbonMinimizedTestCase.assertTrue(FlamingoUtilities.isShowingMinimizedRibbonInPopup(this.ribbon));
        RibbonMinimizedTestCase.assertFalse(cutButton.getPopupModel().isPopupShowing());
    }

    public void testCommandButtonPopupInMinimizedRibbon2() throws Exception {
        this.ribbon.setMinimized(true);
        JRibbonTaskToggleButton taskButton = RibbonMinimizedTestCase.getTaskButton(this.ribbon, "Task");
        RibbonMinimizedTestCase.assertNotNull(taskButton);
        Robot robot = new Robot();
        Point taskButtonLoc = taskButton.getLocationOnScreen();
        robot.mouseMove(taskButtonLoc.x + taskButton.getWidth() / 2, taskButtonLoc.y + taskButton.getHeight() / 2);
        robot.mousePress(16);
        Thread.sleep(200L);
        robot.mouseRelease(16);
        RibbonMinimizedTestCase.assertTrue(this.ribbon.isMinimized());
        RibbonMinimizedTestCase.assertTrue(FlamingoUtilities.isShowingMinimizedRibbonInPopup(this.ribbon));
        List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
        RibbonMinimizedTestCase.assertTrue(popups.size() > 0);
        JPopupPanel currPopupPanel = popups.get(popups.size() - 1).getPopupPanel();
        JCommandButton cutButton = RibbonMinimizedTestCase.getCommandButton(currPopupPanel, "Cut");
        RibbonMinimizedTestCase.assertNotNull(cutButton);
        JCommandButton pasteButton = RibbonMinimizedTestCase.getCommandButton(currPopupPanel, "Paste");
        RibbonMinimizedTestCase.assertNotNull(pasteButton);
        Point cutButtonLoc = cutButton.getLocationOnScreen();
        Rectangle cutPopupArea = cutButton.getUI().getLayoutInfo().popupClickArea;
        Point pasteButtonLoc = pasteButton.getLocationOnScreen();
        Rectangle pastePopupArea = pasteButton.getUI().getLayoutInfo().popupClickArea;
        robot.setAutoDelay(500);
        robot.mouseMove(cutButtonLoc.x + cutPopupArea.x + cutPopupArea.width / 2, cutButtonLoc.y + cutPopupArea.y + cutPopupArea.height / 2);
        robot.mousePress(16);
        Thread.sleep(100L);
        robot.mouseRelease(16);
        RibbonMinimizedTestCase.assertTrue(this.ribbon.isMinimized());
        RibbonMinimizedTestCase.assertTrue(FlamingoUtilities.isShowingMinimizedRibbonInPopup(this.ribbon));
        RibbonMinimizedTestCase.assertTrue(cutButton.getPopupModel().isPopupShowing());
        RibbonMinimizedTestCase.assertFalse(pasteButton.getPopupModel().isPopupShowing());
        Thread.sleep(100L);
        robot.mouseMove(pasteButtonLoc.x + pastePopupArea.x + pastePopupArea.width / 2, pasteButtonLoc.y + pastePopupArea.y + pastePopupArea.height / 2);
        robot.mousePress(16);
        Thread.sleep(100L);
        robot.mouseRelease(16);
        RibbonMinimizedTestCase.assertTrue(this.ribbon.isMinimized());
        RibbonMinimizedTestCase.assertTrue(FlamingoUtilities.isShowingMinimizedRibbonInPopup(this.ribbon));
        RibbonMinimizedTestCase.assertFalse(cutButton.getPopupModel().isPopupShowing());
        RibbonMinimizedTestCase.assertTrue(pasteButton.getPopupModel().isPopupShowing());
        robot.mousePress(16);
        Thread.sleep(100L);
        robot.mouseRelease(16);
        RibbonMinimizedTestCase.assertTrue(this.ribbon.isMinimized());
        RibbonMinimizedTestCase.assertTrue(FlamingoUtilities.isShowingMinimizedRibbonInPopup(this.ribbon));
        RibbonMinimizedTestCase.assertFalse(cutButton.getPopupModel().isPopupShowing());
        RibbonMinimizedTestCase.assertFalse(pasteButton.getPopupModel().isPopupShowing());
    }

    private static JCommandButton getCommandButton(Component c, String title) {
        if (c instanceof JCommandButton && title.equals(((JCommandButton)c).getText())) {
            return (JCommandButton)c;
        }
        if (c instanceof Container) {
            Container cont = (Container)c;
            int i = 0;
            while (i < cont.getComponentCount()) {
                JCommandButton result = RibbonMinimizedTestCase.getCommandButton(cont.getComponent(i), title);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        }
        return null;
    }

    protected static class QuickStylesPanel
    extends JCommandButtonPanel {
        public QuickStylesPanel() {
            super(32);
            int groupIndex = 0;
            while (groupIndex < 4) {
                String iconGroupName = "Styles " + groupIndex;
                this.addButtonGroup(iconGroupName, groupIndex);
                int i = 0;
                while (i < 15) {
                    final int index = i;
                    font_x_generic fontIcon = new font_x_generic();
                    DecoratedResizableIcon finalIcon = new DecoratedResizableIcon(fontIcon, new DecoratedResizableIcon.IconDecorator(){

                        @Override
                        public void paintIconDecoration(Component c, Graphics g, int x, int y, int width, int height) {
                            Graphics2D g2d = (Graphics2D)g.create();
                            g2d.setColor(Color.black);
                            g2d.setFont(UIManager.getFont("Label.font"));
                            RenderingUtils.installDesktopHints(g2d);
                            g2d.drawString("" + index, x + 2, y + height - 2);
                            g2d.dispose();
                        }
                    });
                    JCommandToggleButton jrb = new JCommandToggleButton(null, finalIcon);
                    jrb.setName("Group " + groupIndex + ", index " + i);
                    jrb.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            System.out.println("Invoked action on " + index);
                        }
                    });
                    jrb.setActionRichTooltip(new RichTooltip("Index " + i, "Sample tooltip for " + i));
                    this.addButtonToLastGroup(jrb);
                    ++i;
                }
                ++groupIndex;
            }
            this.setSingleSelectionMode(true);
        }
    }
}

