/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import javax.swing.JSlider;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JSliderLocation;
import org.fest.swing.driver.JSliderSetValueTask;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.GenericRange;
import org.fest.swing.util.Pair;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSliderDriver
extends JComponentDriver {
    private final JSliderLocation location = new JSliderLocation();

    public JSliderDriver(Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void slideToMaximum(JSlider slider) {
        this.slide(slider, JSliderDriver.validateAndFindSlideToMaximumInfo(slider, this.location));
    }

    @RunsInEDT
    private static Pair<Integer, GenericRange<Point>> validateAndFindSlideToMaximumInfo(final JSlider slider, final JSliderLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Integer, GenericRange<Point>>>(){

            @Override
            protected Pair<Integer, GenericRange<Point>> executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(slider);
                int value = slider.getMaximum();
                GenericRange fromAndTo = JSliderDriver.slideInfo(slider, location, value);
                return new Pair<Integer, GenericRange<Point>>(value, fromAndTo);
            }
        });
    }

    @RunsInEDT
    public void slideToMinimum(JSlider slider) {
        this.slide(slider, JSliderDriver.validateAndFindSlideToMinimumInfo(slider, this.location));
    }

    @RunsInEDT
    private static Pair<Integer, GenericRange<Point>> validateAndFindSlideToMinimumInfo(final JSlider slider, final JSliderLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Integer, GenericRange<Point>>>(){

            @Override
            protected Pair<Integer, GenericRange<Point>> executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(slider);
                int value = slider.getMinimum();
                GenericRange fromAndTo = JSliderDriver.slideInfo(slider, location, value);
                return new Pair<Integer, GenericRange<Point>>(value, fromAndTo);
            }
        });
    }

    @RunsInEDT
    private void slide(JSlider slider, Pair<Integer, GenericRange<Point>> slideInfo) {
        this.slide(slider, (Integer)slideInfo.i, (GenericRange)slideInfo.ii);
    }

    @RunsInEDT
    public void slide(JSlider slider, int value) {
        GenericRange<Point> slideInfo = JSliderDriver.validateAndFindSlideInfo(slider, this.location, value);
        this.slide(slider, value, slideInfo);
    }

    @RunsInEDT
    private void slide(JSlider slider, int value, GenericRange<Point> fromAndTo) {
        this.moveMouseIgnoringAnyError(slider, (Point)fromAndTo.from);
        this.moveMouseIgnoringAnyError(slider, (Point)fromAndTo.to);
        JSliderSetValueTask.setValue(slider, value);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static GenericRange<Point> validateAndFindSlideInfo(final JSlider slider, final JSliderLocation location, final int value) {
        return GuiActionRunner.execute(new GuiQuery<GenericRange<Point>>(){

            @Override
            protected GenericRange<Point> executeInEDT() {
                JSliderDriver.validateValue(slider, value);
                ComponentStateValidator.validateIsEnabledAndShowing(slider);
                return JSliderDriver.slideInfo(slider, location, value);
            }
        });
    }

    @RunsInCurrentThread
    private static void validateValue(JSlider slider, int value) {
        int min = slider.getMinimum();
        int max = slider.getMaximum();
        if (value >= min && value <= max) {
            return;
        }
        throw new IllegalArgumentException(Strings.concat("Value <", value, "> is not within the JSlider bounds of <", min, "> and <", max, ">"));
    }

    @RunsInCurrentThread
    private static GenericRange<Point> slideInfo(JSlider slider, JSliderLocation location, int value) {
        Point from = location.pointAt(slider, slider.getValue());
        Point to = location.pointAt(slider, value);
        return new GenericRange<Point>(from, to);
    }
}

