/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.regex.Pattern;
import org.fest.assertions.Assert;
import org.fest.assertions.AssertExtension;
import org.fest.assertions.Description;
import org.fest.swing.util.Strings;

class TextAssert
extends Assert
implements AssertExtension {
    private final String actual;

    static TextAssert assertThat(String s) {
        return new TextAssert(s);
    }

    static TextAssert verifyThat(String s) {
        return new TextAssert(s);
    }

    TextAssert(String actual) {
        this.actual = actual;
    }

    TextAssert as(String description) {
        this.description(description);
        return this;
    }

    TextAssert as(Description description) {
        this.description(description);
        return this;
    }

    TextAssert isEqualOrMatches(String s) {
        if (Strings.areEqualOrMatch(s, this.actual)) {
            return this;
        }
        throw this.failure(org.fest.util.Strings.concat("actual value:<", org.fest.util.Strings.quote(this.actual), "> is not equal to or does not match pattern:<", org.fest.util.Strings.quote(s), ">"));
    }

    TextAssert matches(Pattern pattern) {
        if (Strings.match(pattern, this.actual)) {
            return this;
        }
        throw this.failure(org.fest.util.Strings.concat("actual value:<", org.fest.util.Strings.quote(this.actual), "> does not match pattern:<", org.fest.util.Strings.quote(pattern.pattern()), ">"));
    }
}

