/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.timing;

import org.fest.assertions.BasicDescription;
import org.fest.assertions.Description;
import org.fest.util.Strings;

public abstract class Condition {
    protected static final String EMPTY_TEXT = "";
    private final Description description;

    public Condition(String description) {
        this(new BasicDescription(description));
    }

    public Condition(Description description) {
        this.description = description;
    }

    public abstract boolean test();

    public final String toString() {
        String descriptionText = this.description != null ? this.description.value() : this.defaultDescription();
        String addendum = this.descriptionAddendum();
        return Strings.concat(descriptionText, addendum != null ? addendum : EMPTY_TEXT);
    }

    private String defaultDescription() {
        return Strings.concat("condition of type [", this.getClass().getName(), "]");
    }

    protected String descriptionAddendum() {
        return EMPTY_TEXT;
    }

    protected void done() {
    }
}

