/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstancePainterUtils {
    public static Point getOffsetInRootPaneCoords(Component comp) {
        JRootPane rootPane = SwingUtilities.getRootPane(comp);
        int dx = 0;
        int dy = 0;
        JComponent titlePane = null;
        if (rootPane != null && (titlePane = SubstanceCoreUtilities.getTitlePane(rootPane)) != null) {
            if (comp.isShowing() && titlePane.isShowing()) {
                dx += comp.getLocationOnScreen().x - titlePane.getLocationOnScreen().x;
                dy += comp.getLocationOnScreen().y - titlePane.getLocationOnScreen().y;
            } else {
                Component c = comp;
                dx = 0;
                dy = 0;
                while (c != rootPane) {
                    dx += c.getX();
                    dy += c.getY();
                    c = c.getParent();
                }
                c = titlePane;
                if (c != null && c.getParent() != null) {
                    while (c != rootPane) {
                        dx -= c.getX();
                        dy -= c.getY();
                        c = c.getParent();
                    }
                }
            }
        }
        return new Point(dx, dy);
    }

    public static Component getTopMostParentWithDecorationAreaType(Component comp, DecorationAreaType type) {
        Component c;
        Component topMostWithSameDecorationAreaType = c = comp;
        while (c != null) {
            if (DecorationPainterUtils.getImmediateDecorationType(c) == type) {
                topMostWithSameDecorationAreaType = c;
            }
            c = c.getParent();
        }
        return topMostWithSameDecorationAreaType;
    }
}

