/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.decoration;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.FractionBasedPainter;
import org.pushingpixels.substance.api.painter.SubstancePainterUtils;
import org.pushingpixels.substance.api.painter.decoration.SubstanceDecorationPainter;

public class FractionBasedDecorationPainter
extends FractionBasedPainter
implements SubstanceDecorationPainter {
    private Set<DecorationAreaType> decoratedAreas = new HashSet<DecorationAreaType>();

    public FractionBasedDecorationPainter(String displayName, float[] fractions, ColorSchemeSingleColorQuery[] colorQueries) {
        this(displayName, fractions, colorQueries, DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE);
    }

    public FractionBasedDecorationPainter(String displayName, float[] fractions, ColorSchemeSingleColorQuery[] colorQueries, DecorationAreaType ... decorationAreas) {
        super(displayName, fractions, colorQueries);
        if (decorationAreas != null) {
            DecorationAreaType[] decorationAreaTypeArray = decorationAreas;
            int n = decorationAreas.length;
            int n2 = 0;
            while (n2 < n) {
                DecorationAreaType decorationArea = decorationAreaTypeArray[n2];
                this.decoratedAreas.add(decorationArea);
                ++n2;
            }
        }
    }

    @Override
    public void paintDecorationArea(Graphics2D graphics, Component comp, DecorationAreaType decorationAreaType, int width, int height, SubstanceSkin skin) {
        if (this.decoratedAreas.contains(decorationAreaType)) {
            this.paintDecoratedBackground(graphics, comp, decorationAreaType, width, height, skin.getBackgroundColorScheme(decorationAreaType));
        } else {
            this.paintSolidBackground(graphics, comp, width, height, skin.getBackgroundColorScheme(decorationAreaType));
        }
    }

    private void paintDecoratedBackground(Graphics2D graphics, Component comp, DecorationAreaType decorationAreaType, int width, int height, SubstanceColorScheme scheme) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        Color[] fillColors = new Color[this.fractions.length];
        int i = 0;
        while (i < this.fractions.length) {
            ColorSchemeSingleColorQuery colorQuery = this.colorQueries[i];
            fillColors[i] = colorQuery.query(scheme);
            ++i;
        }
        Component topMostWithSameDecorationAreaType = SubstancePainterUtils.getTopMostParentWithDecorationAreaType(comp, decorationAreaType);
        Point inTopMost = SwingUtilities.convertPoint(comp, new Point(0, 0), topMostWithSameDecorationAreaType);
        int dy = inTopMost.y;
        LinearGradientPaint gradient = new LinearGradientPaint(0.0f, 0.0f, 0.0f, topMostWithSameDecorationAreaType.getHeight(), this.fractions, fillColors, MultipleGradientPaint.CycleMethod.REPEAT);
        g2d.setPaint(gradient);
        g2d.translate(0, -dy);
        g2d.fillRect(0, 0, width, topMostWithSameDecorationAreaType.getHeight());
        g2d.dispose();
    }

    private void paintSolidBackground(Graphics2D graphics, Component comp, int width, int height, SubstanceColorScheme scheme) {
        graphics.setColor(scheme.getMidColor());
        graphics.fillRect(0, 0, width, height);
    }
}

