/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextAreaUI;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.RolloverTextControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;

public class SubstanceTextAreaUI
extends BasicTextAreaUI
implements TransitionAwareUI {
    protected StateTransitionTracker stateTransitionTracker;
    protected JTextArea textArea;
    protected PropertyChangeListener substancePropertyChangeListener;
    private RolloverTextControlListener substanceRolloverListener;
    private ButtonModel transitionModel;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceTextAreaUI(comp);
    }

    public SubstanceTextAreaUI(JComponent c) {
        this.textArea = (JTextArea)c;
        this.transitionModel = new DefaultButtonModel();
        this.transitionModel.setArmed(false);
        this.transitionModel.setSelected(false);
        this.transitionModel.setPressed(false);
        this.transitionModel.setRollover(false);
        this.transitionModel.setEnabled(this.textArea.isEnabled());
        this.stateTransitionTracker = new StateTransitionTracker(this.textArea, this.transitionModel);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceRolloverListener = new RolloverTextControlListener(this.textArea, this, this.transitionModel);
        this.substanceRolloverListener.registerListeners();
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int caretPos = (this).SubstanceTextAreaUI.this.textArea.getCaretPosition();
                            (this).SubstanceTextAreaUI.this.textArea.updateUI();
                            (this).SubstanceTextAreaUI.this.textArea.setCaretPosition(caretPos);
                            Container parent = (this).SubstanceTextAreaUI.this.textArea.getParent();
                            if (parent != null) {
                                parent.invalidate();
                                parent.validate();
                            }
                        }
                    });
                }
                if ("componentOrientation".equals(evt.getPropertyName())) {
                    SubstanceTextAreaUI.this.getComponent().setText(SubstanceTextAreaUI.this.getComponent().getText());
                }
                if ("enabled".equals(evt.getPropertyName())) {
                    SubstanceTextAreaUI.this.transitionModel.setEnabled(SubstanceTextAreaUI.this.textArea.isEnabled());
                }
            }
        };
        this.textArea.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
        this.textArea.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
                    return;
                }
                if (SubstanceTextAreaUI.this.textArea == null) {
                    return;
                }
                Color foregr = SubstanceTextAreaUI.this.textArea.getForeground();
                if (foregr == null || foregr instanceof UIResource) {
                    SubstanceTextAreaUI.this.textArea.setForeground(SubstanceColorUtilities.getForegroundColor(SubstanceLookAndFeel.getCurrentSkin(SubstanceTextAreaUI.this.textArea).getEnabledColorScheme(SubstanceLookAndFeel.getDecorationType(SubstanceTextAreaUI.this.textArea))));
                }
            }
        });
    }

    @Override
    protected void paintBackground(Graphics g) {
        SubstanceTextUtilities.paintTextCompBackground(g, this.textArea);
    }

    @Override
    public boolean isInside(MouseEvent me) {
        return true;
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }
}

