/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextPaneUI;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.RolloverTextControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;

public class SubstanceTextPaneUI
extends BasicTextPaneUI
implements TransitionAwareUI {
    protected StateTransitionTracker stateTransitionTracker;
    protected JTextPane textPane;
    protected PropertyChangeListener substancePropertyChangeListener;
    private RolloverTextControlListener substanceRolloverListener;
    private ButtonModel transitionModel;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceTextPaneUI(comp);
    }

    public SubstanceTextPaneUI(JComponent c) {
        this.textPane = (JTextPane)c;
        this.transitionModel = new DefaultButtonModel();
        this.transitionModel.setArmed(false);
        this.transitionModel.setSelected(false);
        this.transitionModel.setPressed(false);
        this.transitionModel.setRollover(false);
        this.transitionModel.setEnabled(this.textPane.isEnabled());
        this.stateTransitionTracker = new StateTransitionTracker(this.textPane, this.transitionModel);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceRolloverListener = new RolloverTextControlListener(this.textPane, this, this.transitionModel);
        this.substanceRolloverListener.registerListeners();
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int caretPos = (this).SubstanceTextPaneUI.this.textPane.getCaretPosition();
                            (this).SubstanceTextPaneUI.this.textPane.updateUI();
                            (this).SubstanceTextPaneUI.this.textPane.setCaretPosition(caretPos);
                            Container parent = (this).SubstanceTextPaneUI.this.textPane.getParent();
                            if (parent != null) {
                                parent.invalidate();
                                parent.validate();
                            }
                        }
                    });
                }
                if ("enabled".equals(evt.getPropertyName())) {
                    SubstanceTextPaneUI.this.transitionModel.setEnabled(SubstanceTextPaneUI.this.textPane.isEnabled());
                }
            }
        };
        this.textPane.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
        this.textPane.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SubstanceTextPaneUI.this.textPane == null) {
                    return;
                }
                Color foregr = SubstanceTextPaneUI.this.textPane.getForeground();
                if (foregr == null || foregr instanceof UIResource) {
                    SubstanceTextPaneUI.this.textPane.setForeground(SubstanceColorUtilities.getForegroundColor(SubstanceLookAndFeel.getCurrentSkin(SubstanceTextPaneUI.this.textPane).getEnabledColorScheme(SubstanceLookAndFeel.getDecorationType(SubstanceTextPaneUI.this.textPane))));
                }
            }
        });
    }

    @Override
    protected void paintBackground(Graphics g) {
        SubstanceTextUtilities.paintTextCompBackground(g, this.textPane);
    }

    @Override
    public boolean isInside(MouseEvent me) {
        return true;
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }
}

