/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Set;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FontUIResource;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.pushingpixels.lafwidget.tabbed.DefaultTabPreviewPainter;
import org.pushingpixels.lafwidget.utils.LafConstants;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.fonts.FontSet;
import org.pushingpixels.substance.api.skin.SkinChangeListener;
import org.pushingpixels.substance.api.skin.SubstanceGeminiLookAndFeel;
import org.pushingpixels.substance.api.tabbed.TabCloseCallback;
import org.pushingpixels.substance.api.tabbed.TabCloseListener;
import org.pushingpixels.substance.api.tabbed.VetoableMultipleTabCloseListener;
import org.pushingpixels.substance.api.tabbed.VetoableTabCloseListener;
import test.SubstanceLogo;
import test.check.ButtonsPanel;
import test.check.CardPanel;
import test.check.CellsPanel;
import test.check.ColoredControlsPanel;
import test.check.ColorizedControlsPanel;
import test.check.CombosPanel;
import test.check.ControlPanelFactory;
import test.check.Controllable;
import test.check.Deferrable;
import test.check.DesktopPanel;
import test.check.FileTreePanel;
import test.check.HAlignmentPanel;
import test.check.ListPanel;
import test.check.ProgressBarPanel;
import test.check.SampleMenuFactory;
import test.check.ScrollPanel;
import test.check.SizesPanel;
import test.check.SliderPanel;
import test.check.SpinnerPanel;
import test.check.SplitPanel;
import test.check.TabPanel;
import test.check.TablePanel;
import test.check.TextFieldsPanel;
import test.check.TreePanel;
import test.check.VAlignmentPanel;
import test.check.statusbar.FontSizePanel;

public class Check
extends JFrame {
    private JTabbedPane jtp;
    private MyMainTabPreviewPainter mainTabPreviewPainter;
    private JXTaskPaneContainer taskPaneContainer;
    private JXTaskPane currentSpecificTaskPane;
    private JXTaskPane mainTaskPane;
    private JToolBar toolbar;

    public Check() {
        super("Substance test with very very very very very very very very very very very very very very long title");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel) {
            this.setIconImage(SubstanceLogo.getLogoImage(SubstanceLookAndFeel.getCurrentSkin(this.getRootPane()).getColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED)));
        }
        SubstanceLookAndFeel.registerSkinChangeListener(new SkinChangeListener(){

            @Override
            public void skinChanged() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Check.this.setIconImage(SubstanceLogo.getLogoImage(SubstanceLookAndFeel.getCurrentSkin(Check.this.getRootPane()).getColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED)));
                    }
                });
            }
        });
        this.setLayout(new BorderLayout());
        this.jtp = new JTabbedPane();
        try {
            this.mainTabPreviewPainter = new MyMainTabPreviewPainter();
            this.jtp.putClientProperty("lafwidgets.tabbedpanePreviewPainter", (Object)this.mainTabPreviewPainter);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.jtp.getModel().addChangeListener(new TabSwitchListener());
        JXPanel jxPanel = new JXPanel(new BorderLayout());
        this.toolbar = Check.getToolbar("", 22, true);
        jxPanel.add((Component)this.toolbar, "North");
        JXStatusBar statusBar = Check.getStatusBar(jxPanel, this.jtp);
        this.add((Component)statusBar, "South");
        this.taskPaneContainer = new JXTaskPaneContainer(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return false;
            }
        };
        this.taskPaneContainer.setScrollableTracksViewportHeight(false);
        this.taskPaneContainer.setScrollableTracksViewportWidth(false);
        this.mainTaskPane = new JXTaskPane();
        this.mainTaskPane.setLayout(new BorderLayout());
        JPanel mainControlPanel = ControlPanelFactory.getMainControlPanel(this, this.jtp, this.mainTabPreviewPainter, this.toolbar);
        this.mainTaskPane.add((Component)mainControlPanel, "Center");
        this.mainTaskPane.setTitle("General settings");
        this.mainTaskPane.setIcon(Check.getIcon("JFrameColor16"));
        this.mainTaskPane.setCollapsed(true);
        this.taskPaneContainer.add(this.mainTaskPane);
        JPanel dialogControlPanel = ControlPanelFactory.getDialogControlPanel(this);
        JXTaskPane dialogTaskPane = new JXTaskPane();
        dialogTaskPane.setLayout(new BorderLayout());
        dialogTaskPane.add((Component)dialogControlPanel, "Center");
        dialogTaskPane.setTitle("Frames & Dialogs");
        dialogTaskPane.setIcon(Check.getIcon("JDialogColor16"));
        dialogTaskPane.setCollapsed(true);
        this.taskPaneContainer.add(dialogTaskPane);
        this.currentSpecificTaskPane = null;
        final JScrollPane scrollPane = new JScrollPane(this.taskPaneContainer, 22, 30);
        SubstanceLookAndFeel.setDecorationType(scrollPane, DecorationAreaType.GENERAL);
        JPanel mainPanel = new JPanel();
        mainPanel.add(scrollPane);
        mainPanel.add(this.jtp);
        mainPanel.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                Dimension min1 = scrollPane.getMinimumSize();
                Dimension min2 = Check.this.jtp.getMinimumSize();
                return new Dimension(min1.width + min2.width, min1.height + min2.height);
            }

            @Override
            public void layoutContainer(Container parent) {
                int width = parent.getWidth();
                int height = parent.getHeight();
                scrollPane.setBounds(0, 0, (int)(0.3 * (double)width), height);
                Check.this.jtp.setBounds((int)(0.3 * (double)width), 0, width - (int)(0.3 * (double)width), height);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                Dimension pref1 = scrollPane.getPreferredSize();
                Dimension pref2 = Check.this.jtp.getPreferredSize();
                return new Dimension(pref1.width + pref2.width, pref1.height + pref2.height);
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }
        });
        jxPanel.add((Component)mainPanel, "Center");
        this.add((Component)jxPanel, "Center");
        this.setPreferredSize(new Dimension(400, 400));
        this.setSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
        ButtonsPanel buttonsPanel = new ButtonsPanel();
        this.jtp.addTab("Buttons", Check.getIcon("JButtonColor16"), buttonsPanel);
        this.getRootPane().setDefaultButton(buttonsPanel.defaultButton);
        this.jtp.addTab("Combo box", Check.getIcon("JComboBoxColor16"), new CombosPanel());
        this.jtp.addTab("Scroll pane", Check.getIcon("JScrollPaneColor16"), new ScrollPanel());
        TabCloseCallback closeCallback = new TabCloseCallback(){

            @Override
            public SubstanceConstants.TabCloseKind onAreaClick(JTabbedPane tabbedPane, int tabIndex, MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 3) {
                    return SubstanceConstants.TabCloseKind.NONE;
                }
                if (mouseEvent.isShiftDown()) {
                    return SubstanceConstants.TabCloseKind.ALL;
                }
                return SubstanceConstants.TabCloseKind.THIS;
            }

            @Override
            public SubstanceConstants.TabCloseKind onCloseButtonClick(JTabbedPane tabbedPane, int tabIndex, MouseEvent mouseEvent) {
                if (mouseEvent.isAltDown()) {
                    return SubstanceConstants.TabCloseKind.ALL_BUT_THIS;
                }
                if (mouseEvent.isShiftDown()) {
                    return SubstanceConstants.TabCloseKind.ALL;
                }
                return SubstanceConstants.TabCloseKind.THIS;
            }

            @Override
            public String getAreaTooltip(JTabbedPane tabbedPane, int tabIndex) {
                return null;
            }

            @Override
            public String getCloseButtonTooltip(JTabbedPane tabbedPane, int tabIndex) {
                StringBuffer result = new StringBuffer();
                result.append("<html><body>");
                result.append("Mouse click closes <b>" + tabbedPane.getTitleAt(tabIndex) + "</b> tab");
                result.append("<br><b>Alt</b>-Mouse click closes all tabs but <b>" + tabbedPane.getTitleAt(tabIndex) + "</b> tab");
                result.append("<br><b>Shift</b>-Mouse click closes all tabs");
                result.append("</body></html>");
                return result.toString();
            }
        };
        try {
            TabPanel tp = new TabPanel();
            tp.jtp.putClientProperty("substancelaf.tabbedpanecloseCallback", closeCallback);
            this.jtp.addTab("Tabs", Check.getIcon("JTabbedPaneColor16"), tp);
        }
        catch (NoClassDefFoundError tp) {
            // empty catch block
        }
        this.jtp.addTab("Split", new SplitPanel());
        this.jtp.addTab("Desktop", Check.getIcon("JDesktopPaneColor16"), new DesktopPanel());
        this.jtp.addTab("Text fields", Check.getIcon("JTextPaneColor16"), new TextFieldsPanel());
        this.jtp.addTab("Table", Check.getIcon("JTableColor16"), new TablePanel());
        try {
            this.jtp.addTab("List", Check.getIcon("JListColor16"), new ListPanel());
        }
        catch (NoClassDefFoundError tp) {
            // empty catch block
        }
        this.jtp.addTab("Slider", Check.getIcon("JSliderColor16"), new SliderPanel());
        this.jtp.addTab("Progress bar", Check.getIcon("JProgressBarColor16"), new ProgressBarPanel());
        this.jtp.addTab("Spinner", Check.getIcon("JSpinnerColor16"), new SpinnerPanel());
        this.jtp.addTab("Tree", Check.getIcon("JTreeColor16"), new TreePanel());
        this.jtp.addTab("File tree", Check.getIcon("JTreeColor16"), new FileTreePanel());
        this.jtp.addTab("Cards", new CardPanel());
        JPanel verticalButtonPanel = new JPanel();
        verticalButtonPanel.setLayout(new GridLayout(1, 3));
        verticalButtonPanel.add(new JButton("Vert button 1"));
        verticalButtonPanel.add(new JButton("Vert button 2"));
        JPanel smallVerticalButtonPanel = new JPanel();
        smallVerticalButtonPanel.setLayout(new GridLayout(4, 4));
        int row = 0;
        while (row < 4) {
            int col = 0;
            while (col < 4) {
                JButton vertButton = new JButton("vert");
                vertButton.setToolTipText("Vertical button " + row + ":" + col);
                smallVerticalButtonPanel.add(vertButton);
                ++col;
            }
            ++row;
        }
        verticalButtonPanel.add(smallVerticalButtonPanel);
        this.jtp.addTab("V-Buttons", verticalButtonPanel);
        this.jtp.addTab("Colored", new ColoredControlsPanel());
        this.jtp.addTab("Colorized", new ColorizedControlsPanel());
        this.jtp.addTab("Cells", new CellsPanel());
        this.jtp.addTab("Sizes", new SizesPanel());
        this.jtp.addTab("H-Align", new HAlignmentPanel());
        this.jtp.addTab("V-Align", new VAlignmentPanel());
        JMenuBar jmb = new JMenuBar();
        if (UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel) {
            jmb.add(SampleMenuFactory.getSkinMenu());
            jmb.add(SampleMenuFactory.getTransformMenu());
        }
        JMenu coloredMenu = new JMenu("Colors");
        coloredMenu.setMnemonic('0');
        JMenuItem coloredMI = new JMenuItem("Italic red");
        coloredMI.setFont(coloredMI.getFont().deriveFont(2));
        coloredMI.setForeground(Color.red);
        coloredMenu.add(coloredMI);
        JRadioButtonMenuItem coloredRBMI = new JRadioButtonMenuItem("Bold green");
        coloredRBMI.setFont(coloredRBMI.getFont().deriveFont(1));
        coloredRBMI.setForeground(Color.green);
        coloredMenu.add(coloredRBMI);
        JCheckBoxMenuItem coloredCBMI = new JCheckBoxMenuItem("Big blue");
        coloredCBMI.setFont(coloredCBMI.getFont().deriveFont(32.0f));
        coloredCBMI.setForeground(Color.blue);
        coloredMenu.add(coloredCBMI);
        JMenu coloredM = new JMenu("Always big magenta");
        coloredM.setForeground(Color.magenta);
        coloredM.setFont(coloredM.getFont().deriveFont(24.0f));
        coloredMenu.add(coloredM);
        jmb.add(coloredMenu);
        JMenu testMenu = SampleMenuFactory.getTestMenu();
        jmb.add(testMenu);
        JMenu jm4 = new JMenu("Disabled");
        jm4.add(new JMenuItem("dummy4"));
        jm4.setMnemonic('4');
        jmb.add(jm4);
        jm4.setEnabled(false);
        jmb.add(SampleMenuFactory.getLookAndFeelMenu(this));
        this.setJMenuBar(jmb);
        TabCloseCallback closeCallbackMain = new TabCloseCallback(){

            @Override
            public SubstanceConstants.TabCloseKind onAreaClick(JTabbedPane tabbedPane, int tabIndex, MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 2) {
                    return SubstanceConstants.TabCloseKind.NONE;
                }
                if (mouseEvent.isShiftDown()) {
                    return SubstanceConstants.TabCloseKind.ALL;
                }
                return SubstanceConstants.TabCloseKind.THIS;
            }

            @Override
            public SubstanceConstants.TabCloseKind onCloseButtonClick(JTabbedPane tabbedPane, int tabIndex, MouseEvent mouseEvent) {
                if (mouseEvent.isAltDown()) {
                    return SubstanceConstants.TabCloseKind.ALL_BUT_THIS;
                }
                if (mouseEvent.isShiftDown()) {
                    return SubstanceConstants.TabCloseKind.ALL;
                }
                return SubstanceConstants.TabCloseKind.THIS;
            }

            @Override
            public String getAreaTooltip(JTabbedPane tabbedPane, int tabIndex) {
                return null;
            }

            @Override
            public String getCloseButtonTooltip(JTabbedPane tabbedPane, int tabIndex) {
                StringBuffer result = new StringBuffer();
                result.append("<html><body>");
                result.append("Mouse click closes <b>" + tabbedPane.getTitleAt(tabIndex) + "</b> tab");
                result.append("<br><b>Alt</b>-Mouse click closes all tabs but <b>" + tabbedPane.getTitleAt(tabIndex) + "</b> tab");
                result.append("<br><b>Shift</b>-Mouse click closes all tabs");
                result.append("</body></html>");
                return result.toString();
            }
        };
        this.jtp.putClientProperty("substancelaf.tabbedpanecloseCallback", closeCallbackMain);
        SubstanceLookAndFeel.registerTabCloseChangeListener(new TabCloseListener(){

            @Override
            public void tabClosed(JTabbedPane tabbedPane, Component tabComponent) {
                Check.out("Closed tab");
            }

            @Override
            public void tabClosing(JTabbedPane tabbedPane, Component tabComponent) {
                Check.out("Closing tab");
            }
        });
        SubstanceLookAndFeel.registerTabCloseChangeListener(this.jtp, new VetoableTabCloseListener(){

            @Override
            public void tabClosed(JTabbedPane tabbedPane, Component tabComponent) {
                Check.out("Closed tab - specific");
            }

            @Override
            public void tabClosing(JTabbedPane tabbedPane, Component tabComponent) {
                Check.out("Closing tab - specific");
            }

            @Override
            public boolean vetoTabClosing(JTabbedPane tabbedPane, Component tabComponent) {
                int userCloseAnswer = JOptionPane.showConfirmDialog(Check.this, "Are you sure you want to close '" + tabbedPane.getTitleAt(tabbedPane.indexOfComponent(tabComponent)) + "' tab?", "Confirm dialog", 0);
                return userCloseAnswer == 1;
            }
        });
        SubstanceLookAndFeel.registerTabCloseChangeListener(this.jtp, new VetoableMultipleTabCloseListener(){

            @Override
            public void tabsClosed(JTabbedPane tabbedPane, Set<Component> tabComponents) {
                Check.out("Closed " + tabComponents.size() + " tabs - specific");
            }

            @Override
            public void tabsClosing(JTabbedPane tabbedPane, Set<Component> tabComponents) {
                Check.out("Closing " + tabComponents.size() + " tabs - specific");
            }

            @Override
            public boolean vetoTabsClosing(JTabbedPane tabbedPane, Set<Component> tabComponents) {
                int userCloseAnswer = JOptionPane.showConfirmDialog(Check.this, "Are you sure you want to close " + tabComponents.size() + " tabs?", "Confirm dialog", 0);
                return userCloseAnswer == 1;
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                System.out.println("Size " + Check.this.getSize());
            }
        });
    }

    protected static JXStatusBar getStatusBar(final JXPanel jxPanel, final JTabbedPane mainTabbedPane) {
        JXStatusBar statusBar = new JXStatusBar();
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> urls = cl.getResources("META-INF/MANIFEST.MF");
            String substanceVer = null;
            String substanceBuildStamp = null;
            while (urls.hasMoreElements()) {
                String line22;
                InputStream is = urls.nextElement().openStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((line22 = br.readLine()) != null) {
                    int firstColonIndex = line22.indexOf(":");
                    if (firstColonIndex < 0) continue;
                    String name = line22.substring(0, firstColonIndex).trim();
                    String val = line22.substring(firstColonIndex + 1).trim();
                    if (name.compareTo("Substance-Version") == 0) {
                        substanceVer = val;
                    }
                    if (name.compareTo("Substance-BuildStamp") != 0) continue;
                    substanceBuildStamp = val;
                }
                try {
                    br.close();
                }
                catch (IOException line22) {
                    // empty catch block
                }
            }
            if (substanceVer != null) {
                JLabel statusLabel = new JLabel(String.valueOf(substanceVer) + " [built on " + substanceBuildStamp + "]");
                JXStatusBar.Constraint cStatusLabel = new JXStatusBar.Constraint();
                cStatusLabel.setFixedWidth(300);
                statusBar.add((Component)statusLabel, cStatusLabel);
            }
        }
        catch (IOException cl) {
            // empty catch block
        }
        JXStatusBar.Constraint c2 = new JXStatusBar.Constraint(JXStatusBar.Constraint.ResizeBehavior.FILL);
        final JLabel tabLabel = new JLabel("");
        statusBar.add((Component)tabLabel, c2);
        mainTabbedPane.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int selectedIndex = mainTabbedPane.getSelectedIndex();
                if (selectedIndex < 0) {
                    tabLabel.setText("No selected tab");
                } else {
                    tabLabel.setText("Tab " + mainTabbedPane.getTitleAt(selectedIndex) + " selected");
                }
            }
        });
        JPanel fontSizePanel = FontSizePanel.getPanel();
        JXStatusBar.Constraint fontSizePanelConstraints = new JXStatusBar.Constraint();
        fontSizePanelConstraints.setFixedWidth(270);
        statusBar.add((Component)fontSizePanel, fontSizePanelConstraints);
        JPanel alphaPanel = new JPanel(new FlowLayout(3, 0, 0));
        final JLabel alphaLabel = new JLabel("100%");
        final JSlider alphaSlider = new JSlider(0, 100, 100);
        alphaSlider.setFocusable(false);
        alphaSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int currValue = alphaSlider.getValue();
                alphaLabel.setText(String.valueOf(currValue) + "%");
                jxPanel.setAlpha((float)currValue / 100.0f);
            }
        });
        alphaSlider.setToolTipText("Changes the global opacity. Is not Substance-specific");
        alphaSlider.setPreferredSize(new Dimension(120, alphaSlider.getPreferredSize().height));
        alphaPanel.add(alphaLabel);
        alphaPanel.add(alphaSlider);
        JXStatusBar.Constraint alphaPanelConstraints = new JXStatusBar.Constraint();
        alphaPanelConstraints.setFixedWidth(160);
        statusBar.add((Component)alphaPanel, alphaPanelConstraints);
        return statusBar;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean hasLafSpecified = false;
                try {
                    hasLafSpecified = System.getProperty("swing.defaultlaf") != null;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (!hasLafSpecified) {
                        Check.out(" CREATING LAF ");
                        long time0 = System.currentTimeMillis();
                        SubstanceGeminiLookAndFeel laf = new SubstanceGeminiLookAndFeel();
                        long time1 = System.currentTimeMillis();
                        Check.out(" LAF CREATED " + (time1 - time0));
                        Check.out(" SETTING LAF ");
                        long time2 = System.currentTimeMillis();
                        UIManager.setLookAndFeel(laf);
                        long time3 = System.currentTimeMillis();
                        Check.out(" LAF SET " + (time3 - time2));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                SubstanceLookAndFeel.setToUseConstantThemesOnDialogs(true);
                UIManager.put("substancelaf.tabbedpanehasclosebuttons", Boolean.TRUE);
                UIManager.put("substancelaf.addWidgets", Boolean.TRUE);
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
                long time2 = System.currentTimeMillis();
                Check c = new Check();
                c.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        super.componentResized(e);
                        ((JFrame)e.getComponent()).getRootPane().repaint();
                    }
                });
                c.setPreferredSize(new Dimension(820, 560));
                c.setMinimumSize(new Dimension(150, 100));
                c.pack();
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                c.setLocation((d.width - c.getWidth()) / 2, (d.height - c.getHeight()) / 2);
                c.setVisible(true);
                c.setDefaultCloseOperation(System.getProperty("javawebstart.version") != null ? 3 : 2);
                long time3 = System.currentTimeMillis();
                Check.out("App " + (time3 - time2));
            }
        });
    }

    public static void out(Object obj) {
        try {
            System.out.println(obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Icon getIcon(String iconName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource("test/check/icons/" + iconName + ".gif");
        if (url != null) {
            return new ImageIcon(url);
        }
        url = cl.getResource("test/check/icons/" + iconName + ".png");
        if (url != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    public static JToolBar getToolbar(String label, int size, boolean hasStrings) {
        JToolBar toolBar = new JToolBar();
        JButton buttonCut = new JButton(hasStrings ? "cut" : null, Check.getIcon(String.valueOf(size) + "/edit-cut"));
        buttonCut.putClientProperty("substancelaf.buttonnominsize", Boolean.TRUE);
        toolBar.add(buttonCut);
        JButton buttonCopy = new JButton(hasStrings ? "copy" : null, Check.getIcon(String.valueOf(size) + "/edit-copy"));
        buttonCopy.putClientProperty("substancelaf.buttonnominsize", Boolean.TRUE);
        buttonCopy.setEnabled(false);
        toolBar.add(buttonCopy);
        JButton buttonPaste = new JButton(Check.getIcon(String.valueOf(size) + "/edit-paste"));
        toolBar.add(buttonPaste);
        JButton buttonSelectAll = new JButton(Check.getIcon(String.valueOf(size) + "/edit-select-all"));
        toolBar.add(buttonSelectAll);
        JButton buttonDelete = new JButton(Check.getIcon(String.valueOf(size) + "/edit-delete"));
        toolBar.add(buttonDelete);
        toolBar.addSeparator();
        JToolBar innerToolbar = new JToolBar(0);
        innerToolbar.setFloatable(false);
        JToggleButton buttonFormatCenter = new JToggleButton(Check.getIcon(String.valueOf(size) + "/format-justify-center"));
        buttonFormatCenter.putClientProperty("substancelaf.cornerRadius", Float.valueOf(5.0f));
        innerToolbar.add(buttonFormatCenter);
        JToggleButton buttonFormatLeft = new JToggleButton(Check.getIcon(String.valueOf(size) + "/format-justify-left"));
        innerToolbar.add(buttonFormatLeft);
        JToggleButton buttonFormatRight = new JToggleButton(Check.getIcon(String.valueOf(size) + "/format-justify-right"));
        innerToolbar.add(buttonFormatRight);
        JToggleButton buttonFormatFill = new JToggleButton(Check.getIcon(String.valueOf(size) + "/format-justify-fill"));
        buttonFormatFill.putClientProperty("substancelaf.cornerRadius", Float.valueOf(0.0f));
        innerToolbar.add(buttonFormatFill);
        toolBar.add(innerToolbar);
        toolBar.addSeparator();
        if (size > 20) {
            JToolBar innerToolbar2 = new JToolBar(0);
            innerToolbar2.setFloatable(false);
            JPanel innerPanel = new JPanel(new FlowLayout(0, 0, 0));
            innerToolbar2.add((Component)innerPanel, "Center");
            JToggleButton buttonStyleBold = new JToggleButton(Check.getIcon(String.valueOf(size) + "/format-text-bold"));
            EnumSet<SubstanceConstants.Side> rightSide = EnumSet.of(SubstanceConstants.Side.RIGHT);
            buttonStyleBold.putClientProperty("substancelaf.buttonopenSide", rightSide);
            buttonStyleBold.putClientProperty("substancelaf.cornerRadius", Float.valueOf(3.0f));
            JToggleButton buttonStyleItalic = new JToggleButton(Check.getIcon(String.valueOf(size) + "/format-text-italic"));
            buttonStyleItalic.putClientProperty("substancelaf.cornerRadius", Float.valueOf(0.0f));
            buttonStyleItalic.putClientProperty("substancelaf.buttonopenSide", rightSide);
            JToggleButton buttonStyleUnderline = new JToggleButton(Check.getIcon(String.valueOf(size) + "/format-text-underline"));
            buttonStyleUnderline.putClientProperty("substancelaf.cornerRadius", Float.valueOf(0.0f));
            buttonStyleUnderline.putClientProperty("substancelaf.buttonopenSide", rightSide);
            JToggleButton buttonStyleStrikethrough = new JToggleButton(Check.getIcon(String.valueOf(size) + "/format-text-strikethrough"));
            buttonStyleStrikethrough.putClientProperty("substancelaf.buttonside", EnumSet.of(SubstanceConstants.Side.LEFT));
            buttonStyleStrikethrough.putClientProperty("substancelaf.cornerRadius", Float.valueOf(3.0f));
            buttonStyleBold.setSelected(true);
            innerPanel.add(buttonStyleBold);
            innerPanel.add(buttonStyleItalic);
            innerPanel.add(buttonStyleUnderline);
            innerPanel.add(buttonStyleStrikethrough);
            toolBar.add(innerToolbar2);
        }
        toolBar.add(Box.createGlue());
        JButton buttonExit = new JButton(Check.getIcon(String.valueOf(size) + "/process-stop"));
        buttonExit.setToolTipText("Closes the test application");
        buttonExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        toolBar.add(buttonExit);
        return toolBar;
    }

    public void setSpecificTaskPane(JPanel contents, String title, Icon icon) {
        if (this.currentSpecificTaskPane != null) {
            this.taskPaneContainer.remove(this.currentSpecificTaskPane);
        }
        this.currentSpecificTaskPane = new JXTaskPane();
        this.currentSpecificTaskPane.setLayout(new BorderLayout());
        this.currentSpecificTaskPane.setTitle(title);
        this.currentSpecificTaskPane.setIcon(icon);
        SwingUtilities.updateComponentTreeUI(contents);
        this.currentSpecificTaskPane.add((Component)contents, "Center");
        this.taskPaneContainer.add(this.currentSpecificTaskPane);
    }

    public void clearSpecificTaskPane() {
        if (this.currentSpecificTaskPane != null) {
            this.taskPaneContainer.remove(this.currentSpecificTaskPane);
        }
        this.currentSpecificTaskPane = null;
    }

    public JTabbedPane getMainTabbedPane() {
        return this.jtp;
    }

    public static class MyMainTabPreviewPainter
    extends DefaultTabPreviewPainter {
        protected LafConstants.TabOverviewKind tabOverviewKind;

        public void setTabOverviewKind(LafConstants.TabOverviewKind tabOverviewKind) {
            this.tabOverviewKind = tabOverviewKind;
        }

        public LafConstants.TabOverviewKind getOverviewKind(JTabbedPane tabPane) {
            if (this.tabOverviewKind == null) {
                return super.getOverviewKind(tabPane);
            }
            return this.tabOverviewKind;
        }
    }

    public class TabSwitchListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            Deferrable deferrable;
            Component selected = Check.this.jtp.getSelectedComponent();
            if (selected instanceof Deferrable && !(deferrable = (Deferrable)((Object)selected)).isInitialized()) {
                deferrable.initialize();
            }
            if (selected instanceof Controllable) {
                JPanel controlPanel = ((Controllable)((Object)selected)).getControlPanel();
                if (controlPanel == null) {
                    Check.this.clearSpecificTaskPane();
                } else {
                    Check.this.setSpecificTaskPane(controlPanel, Check.this.jtp.getTitleAt(Check.this.jtp.getSelectedIndex()), Check.this.jtp.getIconAt(Check.this.jtp.getSelectedIndex()));
                }
            } else {
                Check.this.clearSpecificTaskPane();
            }
        }
    }

    private static class WrapperFontSet
    implements FontSet {
        private int extra;
        private FontSet delegate;

        public WrapperFontSet(FontSet delegate, int extra) {
            this.delegate = delegate;
            this.extra = extra;
        }

        private FontUIResource getWrappedFont(FontUIResource systemFont) {
            return new FontUIResource(systemFont.getFontName(), systemFont.getStyle(), systemFont.getSize() + this.extra);
        }

        @Override
        public FontUIResource getControlFont() {
            return this.getWrappedFont(this.delegate.getControlFont());
        }

        @Override
        public FontUIResource getMenuFont() {
            return this.getWrappedFont(this.delegate.getMenuFont());
        }

        @Override
        public FontUIResource getMessageFont() {
            return this.getWrappedFont(this.delegate.getMessageFont());
        }

        @Override
        public FontUIResource getSmallFont() {
            return this.getWrappedFont(this.delegate.getSmallFont());
        }

        @Override
        public FontUIResource getTitleFont() {
            return this.getWrappedFont(this.delegate.getTitleFont());
        }

        @Override
        public FontUIResource getWindowTitleFont() {
            return this.getWrappedFont(this.delegate.getWindowTitleFont());
        }
    }
}

