/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;

public class NumberedPanel
extends JPanel {
    public NumberedPanel(int number) {
        this.setLayout(new BorderLayout());
        this.add(new ColoredNumberedPanel(number));
    }

    protected static class ColoredNumberedPanel
    extends JPanel {
        private int number;

        public ColoredNumberedPanel(int number) {
            this.number = number;
            this.setBackground(new Color(255 - (int)(50.0 * Math.random()), 255 - (int)(50.0 * Math.random()), 255 - (int)(50.0 * Math.random())));
        }

        @Override
        protected void paintComponent(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this));
            if (UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel && SubstanceLookAndFeel.getCurrentSkin(this).getActiveColorScheme(SubstanceLookAndFeel.getDecorationType(this)).isDark()) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(Color.white);
            }
            graphics.fillRect(0, 0, w, h);
            graphics.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this, (float)0.6f));
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, w, h);
            graphics.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this));
            if (UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel && SubstanceLookAndFeel.getCurrentSkin(this).getActiveColorScheme(SubstanceLookAndFeel.getDecorationType(this)).isDark()) {
                graphics.setColor(Color.white);
            } else {
                graphics.setColor(Color.black);
            }
            int size = Math.min(60, Math.min(w, h) / 2);
            graphics.setFont(new Font("Arial", 1, size));
            graphics.drawString("" + this.number, (w - size) / 2, (h / 2 + size) / 2);
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
            String currDate = sdf.format(new Date());
            int size2 = Math.min(50, Math.min(w, h) / 3);
            graphics.setFont(new Font("Arial", 1, size2));
            int timeLen = graphics.getFontMetrics().stringWidth(currDate);
            graphics.drawString(currDate, (w - timeLen) / 2, (h + size) / 2);
            graphics.dispose();
        }
    }
}

