/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;

public class SubstanceCoffeeBeansWatermark
implements SubstanceWatermark {
    private static Image watermarkImage = null;

    @Override
    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        graphics.drawImage(watermarkImage, x, y, x + width, y + height, x + dx, y + dy, x + dx + width, y + dy + height, null);
    }

    @Override
    public boolean updateWatermarkImage(SubstanceSkin skin) {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = screenDim.width;
        int screenHeight = screenDim.height;
        watermarkImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(screenWidth, screenHeight, 3);
        Graphics2D graphics = (Graphics2D)watermarkImage.getGraphics().create();
        boolean status = this.drawWatermarkImage(skin, graphics, 0, 0, screenWidth, screenHeight);
        graphics.dispose();
        return status;
    }

    @Override
    public void previewWatermark(Graphics g, SubstanceSkin skin, int x, int y, int width, int height) {
        this.drawWatermarkImage(skin, (Graphics2D)g, x, y, width, height);
    }

    private boolean drawWatermarkImage(SubstanceSkin skin, Graphics2D graphics, int x, int y, int width, int height) {
        Color stampColor = skin.getWatermarkColorScheme().isDark() ? new Color(255, 255, 255, 25) : new Color(0, 0, 0, 15);
        int minBubbleRadius = 10;
        int maxBubbleRadius = 20;
        int cellSize = minBubbleRadius + maxBubbleRadius;
        int rowCount = height / cellSize;
        int columnCount = width / cellSize;
        graphics.setColor(stampColor);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int col = 0;
        while (col <= columnCount) {
            int row = 0;
            while (row <= rowCount) {
                int xc = x + (int)((double)(col * cellSize) + (double)cellSize * Math.random());
                int yc = y + (int)((double)(row * cellSize) + (double)cellSize * Math.random());
                int r = minBubbleRadius + (int)(Math.random() * (double)(maxBubbleRadius - minBubbleRadius));
                AffineTransform oldTransform = graphics.getTransform();
                graphics.setTransform(AffineTransform.getRotateInstance(Math.PI * 2 * Math.random(), xc, yc));
                GeneralPath bean = new GeneralPath();
                bean.moveTo(xc - r, (float)yc - 0.1f * (float)r);
                bean.quadTo(xc - r, (float)yc - 0.6f * (float)r, xc, (float)yc - 0.6f * (float)r);
                bean.quadTo(xc + r, (float)yc - 0.6f * (float)r, xc + r, (float)yc - 0.1f * (float)r);
                bean.lineTo(xc + r, (float)yc + 0.1f * (float)r);
                bean.quadTo(xc + r, (float)yc + 0.6f * (float)r, xc, (float)yc + 0.6f * (float)r);
                bean.quadTo(xc - r, (float)yc + 0.6f * (float)r, xc - r, (float)yc + 0.1f * (float)r);
                bean.lineTo(xc - r, (float)yc - 0.1f * (float)r);
                bean.lineTo(xc + r, (float)yc - 0.1f * (float)r);
                bean.lineTo(xc + r, (float)yc + 0.1f * (float)r);
                bean.lineTo(xc - r, (float)yc + 0.1f * (float)r);
                graphics.draw(bean);
                graphics.setTransform(oldTransform);
                ++row;
            }
            ++col;
        }
        graphics.dispose();
        return true;
    }

    @Override
    public String getDisplayName() {
        return "Coffee Beans";
    }

    @Override
    public void dispose() {
        watermarkImage = null;
    }
}

