/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.DefaultCellEditor;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.lafwidget.animation.AnimationFacet;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableCellRenderer;
import org.pushingpixels.trident.Timeline;
import test.Check;
import test.check.ControllablePanel;
import test.check.Deferrable;
import test.check.FlexiComboBox;
import test.check.ScrollablePanel;

public class TablePanel
extends ControllablePanel
implements Deferrable {
    private boolean isInitialized;
    private JTable table;

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public synchronized void initialize() {
        this.table = new JTable(new MyTableModel(20));
        this.table.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return true;
            }

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                return true;
            }

            @Override
            public boolean importData(JComponent comp, Transferable t) {
                return false;
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                return false;
            }
        });
        this.table.setDropMode(DropMode.ON);
        this.table.setDefaultRenderer(Color.class, new MyColorTableRenderer());
        this.table.setDefaultRenderer(Float.class, new MyFloatTableRenderer());
        final JScrollPane tableScrollpane = new JScrollPane(this.table);
        tableScrollpane.setName("Main table in table panel");
        JComboBox<Object> combo = new JComboBox<Object>(new Object[]{"aa", "bb", "cc"});
        combo.setBorder(null);
        this.table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(combo));
        this.table.setSelectionMode(2);
        this.table.setCellSelectionEnabled(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setShowGrid(false);
        this.table.setDragEnabled(false);
        this.table.setTableHeader(new JTableHeader(this.table.getColumnModel()));
        this.setLayout(new BorderLayout());
        this.add((Component)tableScrollpane, "Center");
        JLabel instructional = new JLabel("Every odd row is editable");
        instructional.putClientProperty("substancelaf.colorizationFactor", 1.0);
        this.add((Component)instructional, "North");
        Timeline instructionalTimeline = new Timeline(instructional);
        instructionalTimeline.addPropertyToInterpolate("foreground", Color.black, Color.blue);
        instructionalTimeline.setDuration(1000L);
        instructionalTimeline.playLoop(Timeline.RepeatBehavior.REVERSE);
        FormLayout lm = new FormLayout("right:pref, 4dlu, fill:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm, new ScrollablePanel());
        builder.appendSeparator("Table settings");
        final JCheckBox isEnabled = new JCheckBox("is enabled");
        isEnabled.setSelected(this.table.isEnabled());
        isEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePanel.this.table.setEnabled(isEnabled.isSelected());
                TablePanel.this.table.getTableHeader().repaint();
            }
        });
        builder.append("Enabled", (Component)isEnabled);
        JButton changeFirstColumn = new JButton("change 1st column");
        changeFirstColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int i = 0;
                        while (i < TablePanel.this.table.getModel().getRowCount()) {
                            TablePanel.this.table.getModel().setValueAt(String.valueOf(Thread.currentThread().getName()) + " " + i, i, 0);
                            try {
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ++i;
                        }
                    }
                }).start();
            }
        });
        builder.append("Change values", (Component)changeFirstColumn);
        final JSlider rowCountSlider = new JSlider(20, 1000, this.table.getModel().getRowCount());
        rowCountSlider.setPaintLabels(false);
        rowCountSlider.setPaintTicks(false);
        rowCountSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (rowCountSlider.getValueIsAdjusting()) {
                    return;
                }
                TablePanel.this.table.setModel(new MyTableModel(rowCountSlider.getValue()));
            }
        });
        builder.append("Row count", (Component)rowCountSlider);
        final JCheckBox areRowsSelectable = new JCheckBox("Rows selectable");
        areRowsSelectable.setSelected(this.table.getRowSelectionAllowed());
        areRowsSelectable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePanel.this.table.setRowSelectionAllowed(areRowsSelectable.isSelected());
            }
        });
        builder.append("Selectable", (Component)areRowsSelectable);
        final JCheckBox areColsSelectable = new JCheckBox("Cols selectable");
        areColsSelectable.setSelected(this.table.getColumnSelectionAllowed());
        areColsSelectable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePanel.this.table.setColumnSelectionAllowed(areColsSelectable.isSelected());
            }
        });
        builder.append("", (Component)areColsSelectable);
        final JCheckBox isSorted = new JCheckBox("Sorted");
        final JCheckBox toHideOddModelRows = new JCheckBox("Hide odd rows");
        isSorted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (isSorted.isSelected()) {
                    TablePanel.this.table.setRowSorter(new TableRowSorter<TableModel>(TablePanel.this.table.getModel()));
                    toHideOddModelRows.setEnabled(true);
                } else {
                    TablePanel.this.table.setRowSorter(null);
                    toHideOddModelRows.setSelected(false);
                    toHideOddModelRows.setEnabled(false);
                }
                TablePanel.this.table.repaint();
                TablePanel.this.table.getTableHeader().repaint();
            }
        });
        builder.append("Sorted", (Component)isSorted);
        toHideOddModelRows.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableRowSorter rowSorter = (TableRowSorter)TablePanel.this.table.getRowSorter();
                if (toHideOddModelRows.isSelected()) {
                    rowSorter.setRowFilter(new RowFilter(){

                        public boolean include(RowFilter.Entry entry) {
                            return (Integer)entry.getIdentifier() % 2 == 0;
                        }
                    });
                } else {
                    rowSorter.setRowFilter(new RowFilter(){

                        public boolean include(RowFilter.Entry entry) {
                            return true;
                        }
                    });
                }
            }
        });
        builder.append("", (Component)toHideOddModelRows);
        final JCheckBox customBackgroundCb = new JCheckBox("Has pink background");
        customBackgroundCb.addActionListener(new ActionListener(){
            Color oldBackColor;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (customBackgroundCb.isSelected()) {
                    this.oldBackColor = TablePanel.this.table.getBackground();
                    TablePanel.this.table.setBackground(new Color(255, 128, 128));
                } else {
                    TablePanel.this.table.setBackground(this.oldBackColor);
                }
            }
        });
        builder.append("Background", (Component)customBackgroundCb);
        final JCheckBox watermarkBleed = new JCheckBox("Watermark bleed");
        watermarkBleed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePanel.this.table.putClientProperty("substancelaf.watermark.visible", watermarkBleed.isSelected());
                tableScrollpane.putClientProperty("substancelaf.watermark.visible", watermarkBleed.isSelected());
                tableScrollpane.repaint();
            }
        });
        builder.append("Watermark", (Component)watermarkBleed);
        final JCheckBox linesVertical = new JCheckBox("Vertical visible");
        linesVertical.setSelected(this.table.getShowVerticalLines());
        linesVertical.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePanel.this.table.setShowVerticalLines(linesVertical.isSelected());
            }
        });
        builder.append("Lines", (Component)linesVertical);
        final JCheckBox linesHorizontal = new JCheckBox("Horizontal visible");
        linesHorizontal.setSelected(this.table.getShowHorizontalLines());
        linesHorizontal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePanel.this.table.setShowHorizontalLines(linesHorizontal.isSelected());
            }
        });
        builder.append("", (Component)linesHorizontal);
        final FlexiComboBox<Integer> resizeModeCombo = new FlexiComboBox<Integer>(new Integer[]{0, 1, 2, 3, 4}){

            @Override
            public String getCaption(Integer item) {
                int iv = item;
                switch (iv) {
                    case 0: {
                        return "off";
                    }
                    case 1: {
                        return "next";
                    }
                    case 2: {
                        return "subsequent";
                    }
                    case 3: {
                        return "last";
                    }
                    case 4: {
                        return "all";
                    }
                }
                return null;
            }
        };
        resizeModeCombo.setSelectedItem(this.table.getAutoResizeMode());
        resizeModeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = (Integer)resizeModeCombo.getSelectedItem();
                TablePanel.this.table.setAutoResizeMode(selected);
            }
        });
        builder.append("Resize mode", (Component)resizeModeCombo);
        final JCheckBox hasRollovers = new JCheckBox("Has rollover effect");
        hasRollovers.setSelected(AnimationConfigurationManager.getInstance().isAnimationAllowed(AnimationFacet.ROLLOVER, (Component)this.table));
        hasRollovers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (hasRollovers.isSelected()) {
                    AnimationConfigurationManager.getInstance().allowAnimations(AnimationFacet.ROLLOVER, (Component)TablePanel.this.table);
                } else {
                    AnimationConfigurationManager.getInstance().disallowAnimations(AnimationFacet.ROLLOVER, (Component)TablePanel.this.table);
                }
            }
        });
        builder.append("Rollovers", (Component)hasRollovers);
        final JCheckBox hasSelectionAnimations = new JCheckBox("Has selection effect");
        hasSelectionAnimations.setSelected(AnimationConfigurationManager.getInstance().isAnimationAllowed(AnimationFacet.SELECTION, (Component)this.table));
        hasSelectionAnimations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (hasSelectionAnimations.isSelected()) {
                    AnimationConfigurationManager.getInstance().allowAnimations(AnimationFacet.SELECTION, (Component)TablePanel.this.table);
                } else {
                    AnimationConfigurationManager.getInstance().disallowAnimations(AnimationFacet.SELECTION, (Component)TablePanel.this.table);
                }
            }
        });
        builder.append("Selections", (Component)hasSelectionAnimations);
        builder.appendSeparator("Font settings");
        JButton tahoma12 = new JButton("Tahoma 12");
        tahoma12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePanel.this.table.setFont(new Font("Tahoma", 0, 12));
            }
        });
        builder.append("Set font", (Component)tahoma12);
        JButton tahoma13 = new JButton("Tahoma 13");
        tahoma13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePanel.this.table.setFont(new Font("Tahoma", 0, 13));
            }
        });
        builder.append("Set font", (Component)tahoma13);
        this.controlPanel = builder.getPanel();
        this.isInitialized = true;
    }

    private static class MyColorTableRenderer
    extends SubstanceDefaultTableCellRenderer {
        private MyColorTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color color = (Color)value;
            this.setForeground(color);
            this.setBackground(new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue(), color.getAlpha()));
            this.setText("row " + row);
            return this;
        }
    }

    private static class MyFloatTableRenderer
    extends SubstanceDefaultTableCellRenderer {
        private MyFloatTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int c = 10 * row % 255;
            Color color = new Color(c, c, c);
            this.setForeground(new Color(255 - c, 0, 0));
            this.setBackground(color);
            if (value != null) {
                this.setText(value.toString());
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private static class MyTableModel
    extends AbstractTableModel {
        private int rows;
        private int cols = 10;
        private Object[][] data;
        private Class<?>[] columns = new Class[]{String.class, JComboBox.class, Boolean.class, Byte.class, Float.class, Double.class, String.class, Date.class, Color.class, ImageIcon.class};

        public MyTableModel(int rows) {
            this.rows = rows;
            this.data = new Object[rows][this.cols];
            Icon[] icons = new Icon[]{Check.getIcon("flag_brazil"), Check.getIcon("flag_bulgaria"), Check.getIcon("flag_canada"), Check.getIcon("flag_china"), Check.getIcon("flag_denmark"), Check.getIcon("flag_finland"), Check.getIcon("flag_france"), Check.getIcon("flag_germany"), Check.getIcon("flag_greece"), Check.getIcon("flag_hungary"), Check.getIcon("flag_israel"), Check.getIcon("flag_italy"), Check.getIcon("flag_japan"), Check.getIcon("flag_mexico"), Check.getIcon("flag_netherlands"), Check.getIcon("flag_norway")};
            int i = 0;
            while (i < rows) {
                this.data[i][0] = "cell " + i + ":" + 0;
                this.data[i][1] = "predef";
                this.data[i][2] = new Boolean(i % 2 == 0);
                this.data[i][3] = new Byte((byte)i);
                this.data[i][4] = new Float(i);
                this.data[i][5] = new Double(i);
                this.data[i][6] = "cell " + i + ":" + 6;
                Calendar cal = Calendar.getInstance();
                cal.set(2000 + i, 1 + i, 1 + i);
                this.data[i][7] = cal.getTime();
                int comp = i * 20;
                int red = comp / 3 % 255;
                int green = comp / 2 % 255;
                int blue = comp % 255;
                this.data[i][8] = new Color(red, green, blue);
                this.data[i][9] = icons[i % icons.length];
                ++i;
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.columns[columnIndex];
        }

        @Override
        public int getColumnCount() {
            return this.cols;
        }

        @Override
        public int getRowCount() {
            return this.rows;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        @Override
        public String getColumnName(int column) {
            return this.getColumnClass(column).getSimpleName();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return rowIndex % 2 == 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }
}

