/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DropMode;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTreeCellRenderer;
import test.Check;
import test.check.ControllablePanel;
import test.check.ScrollablePanel;

public class TreePanel
extends ControllablePanel {
    private JTree tree;
    private JScrollPane jsp;

    public TreePanel() {
        this.setLayout(new BorderLayout());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        DefaultMutableTreeNode son1 = new DefaultMutableTreeNode("son1");
        DefaultMutableTreeNode son2 = new DefaultMutableTreeNode("son2");
        DefaultMutableTreeNode son3 = new DefaultMutableTreeNode("son3");
        DefaultMutableTreeNode gson11 = new DefaultMutableTreeNode("gson11");
        DefaultMutableTreeNode gson12 = new DefaultMutableTreeNode("gson12");
        DefaultMutableTreeNode gson21 = new DefaultMutableTreeNode("gson21");
        DefaultMutableTreeNode gson22 = new DefaultMutableTreeNode("gson22");
        DefaultMutableTreeNode gson31 = new DefaultMutableTreeNode("gson31");
        DefaultMutableTreeNode gson32 = new DefaultMutableTreeNode("gson32");
        DefaultMutableTreeNode ggson111 = new DefaultMutableTreeNode("ggson111");
        DefaultMutableTreeNode ggson112 = new DefaultMutableTreeNode("ggson112");
        DefaultMutableTreeNode ggson113 = new DefaultMutableTreeNode("ggson113");
        gson11.add(ggson111);
        gson11.add(ggson112);
        gson11.add(ggson113);
        son1.add(gson11);
        son1.add(gson12);
        son2.add(gson21);
        son2.add(gson22);
        son3.add(gson31);
        son3.add(gson32);
        root.add(son1);
        root.add(son2);
        root.add(son3);
        this.tree = new JTree(root);
        this.tree.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return true;
            }

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                return true;
            }

            @Override
            public boolean importData(JComponent comp, Transferable t) {
                return false;
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                return false;
            }
        });
        this.tree.setDropMode(DropMode.ON);
        this.tree.putClientProperty("lafwidgets.treeAutoDnDSupport", Boolean.TRUE);
        this.jsp = new JScrollPane(this.tree);
        this.jsp.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)this.jsp, "Center");
        FormLayout lm = new FormLayout("right:pref, 4dlu, fill:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm, new ScrollablePanel());
        builder.appendSeparator("General");
        final JCheckBox isEnabled = new JCheckBox("is enabled");
        isEnabled.setSelected(this.tree.isEnabled());
        isEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePanel.this.tree.setEnabled(isEnabled.isSelected());
            }
        });
        builder.append("Enabled", (Component)isEnabled);
        final JCheckBox isOpaque = new JCheckBox("is opaque");
        isOpaque.setSelected(this.tree.isOpaque());
        isOpaque.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePanel.this.tree.setOpaque(isOpaque.isSelected());
                TreePanel.this.tree.repaint();
            }
        });
        builder.append("Opacity", (Component)isOpaque);
        final JCheckBox isEditable = new JCheckBox("is editable");
        isEditable.setSelected(this.tree.isEditable());
        isEditable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePanel.this.tree.setEditable(isEditable.isSelected());
            }
        });
        builder.append("Editable", (Component)isEditable);
        final JCheckBox isDragEnabled = new JCheckBox("is drag enabled");
        isDragEnabled.setSelected(this.tree.getDragEnabled());
        isDragEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePanel.this.tree.setDragEnabled(isDragEnabled.isSelected());
            }
        });
        builder.append("Drag enabled", (Component)isDragEnabled);
        final JCheckBox watermarkBleed = new JCheckBox("is visible");
        watermarkBleed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePanel.this.tree.putClientProperty("substancelaf.watermark.visible", watermarkBleed.isSelected());
                TreePanel.this.jsp.putClientProperty("substancelaf.watermark.visible", watermarkBleed.isSelected());
                TreePanel.this.tree.repaint();
            }
        });
        builder.append("Watermark", (Component)watermarkBleed);
        final JCheckBox isWrappedInScrollPane = new JCheckBox("is in scroll pane");
        isWrappedInScrollPane.setSelected(true);
        isWrappedInScrollPane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (isWrappedInScrollPane.isSelected()) {
                    TreePanel.this.remove(TreePanel.this.tree);
                    TreePanel.this.jsp.setViewportView(TreePanel.this.tree);
                    TreePanel.this.add((Component)TreePanel.this.jsp, "Center");
                } else {
                    TreePanel.this.remove(TreePanel.this.jsp);
                    TreePanel.this.add((Component)TreePanel.this.tree, "Center");
                }
                TreePanel.this.revalidate();
                TreePanel.this.repaint();
            }
        });
        builder.append("Container", (Component)isWrappedInScrollPane);
        final JCheckBox rendererCB = new JCheckBox("has custom renderer");
        rendererCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (rendererCB.isSelected()) {
                            TreePanel.this.tree.setCellRenderer(new TestTreeCellRenderer());
                        } else {
                            TreePanel.this.tree.setCellRenderer(new SubstanceDefaultTreeCellRenderer());
                        }
                    }
                });
            }
        });
        builder.append("Renderer", (Component)rendererCB);
        builder.appendSeparator("Insets");
        Insets ins = this.tree.getInsets();
        final JSpinner topInsets = new JSpinner(new SpinnerNumberModel(ins.top, 0, 10, 1));
        final JSpinner leftInsets = new JSpinner(new SpinnerNumberModel(ins.left, 0, 10, 1));
        final JSpinner bottomInsets = new JSpinner(new SpinnerNumberModel(ins.bottom, 0, 10, 1));
        final JSpinner rightInsets = new JSpinner(new SpinnerNumberModel(ins.right, 0, 10, 1));
        builder.append("Top", (Component)topInsets);
        builder.append("Left", (Component)leftInsets);
        builder.append("Bottom", (Component)bottomInsets);
        builder.append("Right", (Component)rightInsets);
        ChangeListener cl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TreePanel.this.tree.setBorder(new EmptyBorder((Integer)topInsets.getValue(), (Integer)leftInsets.getValue(), (Integer)bottomInsets.getValue(), (Integer)rightInsets.getValue()));
            }
        };
        topInsets.addChangeListener(cl);
        leftInsets.addChangeListener(cl);
        bottomInsets.addChangeListener(cl);
        rightInsets.addChangeListener(cl);
        this.controlPanel = builder.getPanel();
    }

    private static class TestTreeCellRenderer
    extends SubstanceDefaultTreeCellRenderer {
        private TestTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel result = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (sel) {
                result.setText("<html><b>" + this.getText() + "</b></html>");
                result.setIcon(Check.getIcon("flag_sweden"));
            }
            return result;
        }
    }
}

