/*
 * Decompiled with CFR 0.152.
 */
package test.samples.lafwidget.clientprop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import org.pushingpixels.lafwidget.text.PasswordStrengthChecker;
import org.pushingpixels.lafwidget.utils.LafConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;

public class PasswordStrengthCheckerProperty
extends JFrame {
    public PasswordStrengthCheckerProperty() {
        super("Password strength checker");
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new FlowLayout());
        this.add((Component)panel, "Center");
        final JPasswordField jpf = new JPasswordField();
        jpf.setColumns(20);
        panel.add(new JLabel("Start typing password"));
        panel.add(jpf);
        JPanel controls = new JPanel(new FlowLayout(2));
        final JCheckBox hasPasswordStrengthChecker = new JCheckBox("Has password strength checker");
        hasPasswordStrengthChecker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (hasPasswordStrengthChecker.isSelected()) {
                    jpf.putClientProperty("lafwidgets.passwordStrengthChecker", new PasswordStrengthChecker(){

                        public LafConstants.PasswordStrength getStrength(char[] password) {
                            if (password == null) {
                                return LafConstants.PasswordStrength.WEAK;
                            }
                            int length = password.length;
                            if (length < 3) {
                                return LafConstants.PasswordStrength.WEAK;
                            }
                            if (length < 6) {
                                return LafConstants.PasswordStrength.MEDIUM;
                            }
                            return LafConstants.PasswordStrength.STRONG;
                        }

                        public String getDescription(LafConstants.PasswordStrength strength) {
                            if (strength == LafConstants.PasswordStrength.WEAK) {
                                return "<html>This password is <b>way</b> too weak</html>";
                            }
                            if (strength == LafConstants.PasswordStrength.MEDIUM) {
                                return "<html>Come on, you can do<br> a little better than that</html>";
                            }
                            if (strength == LafConstants.PasswordStrength.STRONG) {
                                return "OK";
                            }
                            return null;
                        }
                    });
                } else {
                    jpf.putClientProperty("lafwidgets.passwordStrengthChecker", null);
                }
            }
        });
        controls.add(hasPasswordStrengthChecker);
        this.add((Component)controls, "South");
        this.setSize(400, 200);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                new PasswordStrengthCheckerProperty().setVisible(true);
            }
        });
    }
}

