/*
 * Decompiled with CFR 0.152.
 */
package test.samples.substance.api;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;
import org.pushingpixels.substance.api.tabbed.TabCloseListener;
import org.pushingpixels.substance.api.tabbed.VetoableMultipleTabCloseListener;

public class GetAllTabCloseListeners_Specific
extends JFrame {
    public GetAllTabCloseListeners_Specific() {
        super("Get all tab close listeners");
        this.setLayout(new BorderLayout());
        final JTabbedPane jtp = new JTabbedPane();
        jtp.addTab("tab1", new JPanel());
        jtp.addTab("tab2", new JPanel());
        jtp.addTab("tab3", new JPanel());
        jtp.putClientProperty("substancelaf.tabbedpanehasclosebuttons", Boolean.TRUE);
        SubstanceLookAndFeel.registerTabCloseChangeListener(null, new TabCloseListener(){

            @Override
            public void tabClosing(JTabbedPane tabbedPane, Component tabComponent) {
                System.out.println("Tab closing");
            }

            @Override
            public void tabClosed(JTabbedPane tabbedPane, Component tabComponent) {
                System.out.println("Tab closed");
            }
        });
        SubstanceLookAndFeel.registerTabCloseChangeListener(jtp, new VetoableMultipleTabCloseListener(){

            @Override
            public void tabsClosed(JTabbedPane tabbedPane, Set<Component> tabComponents) {
                System.out.println("Tabs closed");
            }

            @Override
            public void tabsClosing(JTabbedPane tabbedPane, Set<Component> tabComponents) {
                System.out.println("Tabs closing");
            }

            @Override
            public boolean vetoTabsClosing(JTabbedPane tabbedPane, Set<Component> tabComponents) {
                System.out.println("Vetoing tabs closing");
                return true;
            }
        });
        this.add((Component)jtp, "Center");
        JPanel controls = new JPanel(new FlowLayout(2));
        JButton getTabCloseListeners = new JButton("Get tab close listeners");
        getTabCloseListeners.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(GetAllTabCloseListeners_Specific.this, String.valueOf(SubstanceLookAndFeel.getAllTabCloseListeners(jtp).size()) + " specific tab close listeners registered");
            }
        });
        controls.add(getTabCloseListeners);
        this.add((Component)controls, "South");
        this.setSize(400, 200);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                new GetAllTabCloseListeners_Specific().setVisible(true);
            }
        });
    }
}

