/*
 * Decompiled with CFR 0.152.
 */
package test.samples.substance.clientprop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;

public class TabbedPaneCloseButtonsModifiedAnimation
extends JFrame {
    public TabbedPaneCloseButtonsModifiedAnimation() {
        super("Tabbed pane close buttons modified animation");
        this.setLayout(new BorderLayout());
        final JTabbedPane jtp = new JTabbedPane();
        jtp.addTab("First", new JPanel());
        jtp.addTab("Second", new JPanel());
        jtp.putClientProperty("substancelaf.tabbedpanehasclosebuttons", Boolean.TRUE);
        this.add((Component)jtp, "Center");
        JPanel controls = new JPanel(new FlowLayout(2));
        final JCheckBox firstTabModified = new JCheckBox("First tab modified");
        firstTabModified.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component comp = jtp.getComponentAt(0);
                ((JComponent)comp).putClientProperty("windowModified", firstTabModified.isSelected() ? Boolean.TRUE : null);
                jtp.repaint();
            }
        });
        final JCheckBox animationOnCloseButton = new JCheckBox("Animation on close button");
        animationOnCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jtp.putClientProperty("substancelaf.tabbedpaneclosebuttonsmodifiedanimation", animationOnCloseButton.isSelected() ? Boolean.TRUE : null);
                jtp.repaint();
            }
        });
        controls.add(firstTabModified);
        controls.add(animationOnCloseButton);
        this.add((Component)controls, "South");
        this.setSize(400, 200);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                new TabbedPaneCloseButtonsModifiedAnimation().setVisible(true);
            }
        });
    }
}

