/*
 * Decompiled with CFR 0.152.
 */
package test.samples.tips;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.decoration.SubstanceDecorationPainter;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;
import org.pushingpixels.substance.internal.ui.SubstanceInternalFrameUI;

public class CustomInternalFrameTitlePane
extends JFrame {
    public CustomInternalFrameTitlePane() {
        super("Custom title pane");
        this.setLayout(new BorderLayout());
        JDesktopPane jdp = new JDesktopPane();
        this.add((Component)jdp, "Center");
        JInternalFrame jif = new JInternalFrame("internal frame");
        jdp.add(jif);
        jif.setBounds(100, 100, 300, 200);
        jif.setVisible(true);
        this.setSize(500, 400);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame.setDefaultLookAndFeelDecorated(true);
                SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                UIManager.put("InternalFrameUI", MyInternalFrameUI.class.getName());
                new CustomInternalFrameTitlePane().setVisible(true);
            }
        });
    }

    private static class MyInternalFrameTitlePane
    extends JComponent {
        private MyInternalFrameTitlePane() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            SubstanceSkin currentSkin = SubstanceLookAndFeel.getCurrentSkin(this);
            SubstanceDecorationPainter decoPainter = currentSkin.getDecorationPainter();
            Graphics2D g2d = (Graphics2D)g.create();
            decoPainter.paintDecorationArea(g2d, this, DecorationAreaType.SECONDARY_TITLE_PANE, this.getWidth(), this.getHeight(), currentSkin);
            g2d.dispose();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(30, 80);
        }
    }

    public static class MyInternalFrameUI
    extends SubstanceInternalFrameUI {
        public MyInternalFrameUI(JInternalFrame jif) {
            super(jif);
        }

        public static ComponentUI createUI(JComponent comp) {
            return new MyInternalFrameUI((JInternalFrame)comp);
        }

        @Override
        protected JComponent createNorthPane(JInternalFrame w) {
            return new MyInternalFrameTitlePane();
        }
    }
}

