/*
 * Decompiled with CFR 0.152.
 */
package test.samples.tips;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;
import org.pushingpixels.substance.api.watermark.SubstanceImageWatermark;

public class WatermarkedTabbedPane
extends JFrame {
    public WatermarkedTabbedPane() throws Exception {
        super("Transparent tabs");
        JTabbedPane jtp = new JTabbedPane();
        jtp.putClientProperty("substancelaf.tabbedPaneContentBorderKind", (Object)SubstanceConstants.TabContentPaneBorderKind.SINGLE_PLACEMENT);
        jtp.addTab("Tab 1", new JPanel());
        jtp.setTabComponentAt(0, new TabControl("System", "Description"));
        jtp.addTab("Tab 2", new JPanel());
        jtp.setTabComponentAt(1, new TabControl("Monitors", "Description"));
        this.setLayout(new BorderLayout(10, 10));
        this.add(jtp);
        this.setSize(400, 300);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SubstanceLookAndFeel.setSkin(new MySkin());
                    new WatermarkedTabbedPane().setVisible(true);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });
    }

    private static class MySkin
    extends BusinessBlackSteelSkin {
        public MySkin() {
            try {
                SubstanceImageWatermark imageWatermark = new SubstanceImageWatermark(new URL("http://www.wallpaperpimper.com/wallpaper/Art_&_3D/Abstract/Lime-Green-Abstract-1-F8T4BX57YH-800x600.jpg").openStream());
                imageWatermark.setOpacity(1.0f);
                imageWatermark.setKind(SubstanceConstants.ImageWatermarkKind.APP_ANCHOR);
                this.watermark = imageWatermark;
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }

        @Override
        public String getDisplayName() {
            return "My";
        }
    }

    private static class TabControl
    extends JPanel {
        public TabControl(String topLabel, String bottomLabel) {
            this.setOpaque(false);
            this.setLayout(new GridLayout(2, 1));
            JLabel top = new JLabel(topLabel);
            top.setFont(top.getFont().deriveFont(15.0f).deriveFont(1));
            JLabel bottom = new JLabel(bottomLabel);
            this.add(top);
            this.add(bottom);
        }
    }
}

