/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi;

import cz.cesnet.cloud.occi.collection.SetCover;
import cz.cesnet.cloud.occi.core.Action;
import cz.cesnet.cloud.occi.core.Kind;
import cz.cesnet.cloud.occi.core.Link;
import cz.cesnet.cloud.occi.core.Mixin;
import cz.cesnet.cloud.occi.core.Resource;
import cz.cesnet.cloud.occi.exception.AmbiguousIdentifierException;
import cz.cesnet.cloud.occi.parser.CollectionType;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class Model {
    private final SetCover<Kind> kinds = new SetCover();
    private final SetCover<Mixin> mixins = new SetCover();
    private final SetCover<Action> actions = new SetCover();

    public boolean containsKind(Kind kind) {
        return this.kinds.contains(kind);
    }

    public boolean containsKind(String kindIdentifier) {
        return this.kinds.contains(kindIdentifier);
    }

    public boolean addKind(Kind kind) {
        return this.kinds.add(kind);
    }

    public Kind getKind(String kindIdentifier) {
        return this.kinds.get(kindIdentifier);
    }

    public boolean removeKind(Kind kind) {
        return this.kinds.remove(kind);
    }

    public void clearKinds() {
        this.kinds.clear();
    }

    public Set<Kind> getKinds() {
        return this.kinds.getSet();
    }

    public boolean containsMixin(Mixin mixin) {
        return this.mixins.contains(mixin);
    }

    public boolean containsMixin(String mixinIdentifier) {
        return this.mixins.contains(mixinIdentifier);
    }

    public boolean addMixin(Mixin mixin) {
        return this.mixins.add(mixin);
    }

    public Mixin getMixin(String mixinIdentifier) {
        return this.mixins.get(mixinIdentifier);
    }

    public boolean removeMixin(Mixin mixin) {
        return this.mixins.remove(mixin);
    }

    public void clearMixins() {
        this.mixins.clear();
    }

    public Set<Mixin> getMixins() {
        return this.mixins.getSet();
    }

    public boolean containsAction(Action action) {
        return this.actions.contains(action);
    }

    public boolean containsAction(String actionIdentifier) {
        return this.actions.contains(actionIdentifier);
    }

    public boolean addAction(Action action) {
        return this.actions.add(action);
    }

    public Action getAction(String actionIdentifier) {
        return this.actions.get(actionIdentifier);
    }

    public boolean removeAction(Action action) {
        return this.actions.remove(action);
    }

    public void clearActions() {
        this.actions.clear();
    }

    public Set<Action> getActions() {
        return this.actions.getSet();
    }

    public Kind findKind(URI identifier) {
        if (identifier == null) {
            return null;
        }
        String identifierString = identifier.toString();
        for (Kind kind : this.kinds.getSet()) {
            if (!kind.getIdentifier().equals(identifierString)) continue;
            return kind;
        }
        return null;
    }

    public Kind findKind(String term) throws AmbiguousIdentifierException {
        Kind foundKind = null;
        for (Kind kind : this.kinds.getSet()) {
            if (!kind.getTerm().equals(term)) continue;
            if (foundKind != null) {
                throw new AmbiguousIdentifierException("term '" + term + "' is ambiguous");
            }
            foundKind = kind;
        }
        return foundKind;
    }

    public List<Kind> findRelatedKinds(URI identifier) {
        Kind main = this.findKind(identifier);
        return this.getRelatedKinds(main);
    }

    public List<Kind> findRelatedKinds(String term) throws AmbiguousIdentifierException {
        Kind main = this.findKind(term);
        return this.getRelatedKinds(main);
    }

    private List<Kind> getRelatedKinds(Kind main) {
        ArrayList<Kind> related = new ArrayList<Kind>();
        if (main == null) {
            return related;
        }
        for (Kind kind : this.kinds.getSet()) {
            if (!kind.relatesTo(main)) continue;
            related.add(kind);
        }
        return related;
    }

    public CollectionType findKindType(Kind kind) {
        while (kind != null) {
            if (kind.getIdentifier().equals(Resource.KIND_IDENTIFIER_DEFAULT)) {
                return CollectionType.RESOURCE;
            }
            if (kind.getIdentifier().equals(Link.KIND_IDENTIFIER_DEFAULT)) {
                return CollectionType.LINK;
            }
            kind = kind.getParentKind();
        }
        return null;
    }

    public CollectionType findKindType(String location) {
        Kind kind = null;
        for (Kind k : this.kinds.getSet()) {
            if (!k.getLocation().getPath().equals(location)) continue;
            kind = k;
            break;
        }
        return this.findKindType(kind);
    }

    public Mixin findMixin(URI identifier) {
        if (identifier == null) {
            return null;
        }
        String identigfierString = identifier.toString();
        for (Mixin mixin : this.mixins.getSet()) {
            if (!mixin.getIdentifier().equals(identigfierString)) continue;
            return mixin;
        }
        return null;
    }

    public Mixin findMixin(String term) throws AmbiguousIdentifierException {
        Mixin foundMixin = null;
        for (Mixin mixin : this.mixins.getSet()) {
            if (!mixin.getTerm().equals(term)) continue;
            if (foundMixin != null) {
                throw new AmbiguousIdentifierException("term '" + term + "' is ambiguous");
            }
            foundMixin = mixin;
        }
        return foundMixin;
    }

    public Mixin findMixin(String term, String rel) throws AmbiguousIdentifierException {
        Mixin relMixin = this.findMixin(rel);
        if (relMixin == null) {
            return null;
        }
        Mixin foundMixin = null;
        for (Mixin mixin : this.mixins.getSet()) {
            if (!mixin.getTerm().equals(term) || !mixin.relatesTo(relMixin)) continue;
            if (foundMixin != null) {
                throw new AmbiguousIdentifierException("term '" + term + "' is ambiguous");
            }
            foundMixin = mixin;
        }
        return foundMixin;
    }

    public Mixin findMixin(String term, URI rel) throws AmbiguousIdentifierException {
        if (rel == null) {
            return null;
        }
        Mixin foundMixin = null;
        for (Mixin mixin : this.mixins.getSet()) {
            if (!mixin.getTerm().equals(term) || !mixin.relatesTo(rel.toString())) continue;
            if (foundMixin != null) {
                throw new AmbiguousIdentifierException("term '" + term + "' is ambiguous");
            }
            foundMixin = mixin;
        }
        return foundMixin;
    }

    public List<Mixin> findRelatedMixins(URI identifier) {
        Mixin main = this.findMixin(identifier);
        return this.getRelatedMixins(main);
    }

    public List<Mixin> findRelatedMixins(String term) throws AmbiguousIdentifierException {
        Mixin main = this.findMixin(term);
        return this.getRelatedMixins(main);
    }

    private List<Mixin> getRelatedMixins(Mixin main) {
        ArrayList<Mixin> related = new ArrayList<Mixin>();
        if (main == null) {
            return related;
        }
        for (Mixin mixin : this.mixins.getSet()) {
            if (!mixin.relatesTo(main)) continue;
            related.add(mixin);
        }
        return related;
    }

    public Action findAction(String term) throws AmbiguousIdentifierException {
        Action foundAction = null;
        for (Action action : this.actions.getSet()) {
            if (!action.getTerm().equals(term)) continue;
            if (foundAction != null) {
                throw new AmbiguousIdentifierException("term '" + term + "' is ambiguous");
            }
            foundAction = action;
        }
        return foundAction;
    }

    public Action findAction(URI identifier) {
        if (identifier == null) {
            return null;
        }
        String identigfierString = identifier.toString();
        for (Action action : this.actions.getSet()) {
            if (!action.getIdentifier().equals(identigfierString)) continue;
            return action;
        }
        return null;
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + Objects.hashCode(this.kinds);
        hash = 59 * hash + Objects.hashCode(this.mixins);
        hash = 59 * hash + Objects.hashCode(this.actions);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Model other = (Model)obj;
        if (!Objects.equals(this.kinds, other.kinds)) {
            return false;
        }
        if (!Objects.equals(this.mixins, other.mixins)) {
            return false;
        }
        return Objects.equals(this.actions, other.actions);
    }

    public String toString() {
        return "Model{kinds=" + this.kinds + ", mixins=" + this.mixins + ", actions=" + this.actions + '}';
    }
}

