/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.infrastructure;

import cz.cesnet.cloud.occi.Model;
import cz.cesnet.cloud.occi.core.Attribute;
import cz.cesnet.cloud.occi.core.Category;
import cz.cesnet.cloud.occi.core.Kind;
import cz.cesnet.cloud.occi.core.Resource;
import cz.cesnet.cloud.occi.exception.InvalidAttributeValueException;
import cz.cesnet.cloud.occi.infrastructure.enumeration.Architecture;
import cz.cesnet.cloud.occi.infrastructure.enumeration.ComputeState;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class Compute
extends Resource {
    public static final String ARCHITECTURE_ATTRIBUTE_NAME = "occi.compute.architecture";
    public static final String CORES_ATTRIBUTE_NAME = "occi.compute.cores";
    public static final String HOSTNAME_ATTRIBUTE_NAME = "occi.compute.hostname";
    public static final String SPEED_ATTRIBUTE_NAME = "occi.compute.speed";
    public static final String MEMORY_ATTRIBUTE_NAME = "occi.compute.memory";
    public static final String STATE_ATTRIBUTE_NAME = "occi.compute.state";
    public static final URI SCHEME_DEFAULT = Category.SCHEME_INFRASTRUCTURE_DEFAULT;
    public static final String TERM_DEFAULT = "compute";
    public static final String KIND_IDENTIFIER_DEFAULT = SCHEME_DEFAULT + "compute";

    public Compute(String id, Kind kind, String title, Model model, String summary) throws InvalidAttributeValueException {
        super(id, kind, title, model, summary);
    }

    public Compute(String id, Kind kind) throws InvalidAttributeValueException {
        super(id, kind);
    }

    public String getState() {
        return this.getValue(STATE_ATTRIBUTE_NAME);
    }

    public void setState(ComputeState state) throws InvalidAttributeValueException {
        if (state == null) {
            throw new NullPointerException("state cannot be null");
        }
        this.addAttribute(STATE_ATTRIBUTE_NAME, state.toString());
    }

    public void setState(String stateName) throws InvalidAttributeValueException {
        this.addAttribute(STATE_ATTRIBUTE_NAME, stateName);
    }

    public String getMemory() {
        return this.getValue(MEMORY_ATTRIBUTE_NAME);
    }

    public void setMemory(float memory) throws InvalidAttributeValueException {
        this.addAttribute(MEMORY_ATTRIBUTE_NAME, String.valueOf(memory));
    }

    public void setMemory(String memory) throws InvalidAttributeValueException {
        this.addAttribute(MEMORY_ATTRIBUTE_NAME, memory);
    }

    public String getSpeed() {
        return this.getValue(SPEED_ATTRIBUTE_NAME);
    }

    public void setSpeed(float speed) throws InvalidAttributeValueException {
        this.addAttribute(SPEED_ATTRIBUTE_NAME, String.valueOf(speed));
    }

    public void setSpeed(String speed) throws InvalidAttributeValueException {
        this.addAttribute(SPEED_ATTRIBUTE_NAME, speed);
    }

    public String getHostname() {
        return this.getValue(HOSTNAME_ATTRIBUTE_NAME);
    }

    public void setHostname(String hostname) throws InvalidAttributeValueException {
        this.addAttribute(HOSTNAME_ATTRIBUTE_NAME, hostname);
    }

    public String getCores() {
        return this.getValue(CORES_ATTRIBUTE_NAME);
    }

    public void setCores(int cores) throws InvalidAttributeValueException {
        this.addAttribute(CORES_ATTRIBUTE_NAME, String.valueOf(cores));
    }

    public void setCores(String cores) throws InvalidAttributeValueException {
        this.addAttribute(CORES_ATTRIBUTE_NAME, cores);
    }

    public String getArchitecture() {
        return this.getValue(ARCHITECTURE_ATTRIBUTE_NAME);
    }

    public void setArchitecture(Architecture architecture) throws InvalidAttributeValueException {
        if (architecture == null) {
            throw new NullPointerException("architecture cannot be null");
        }
        this.addAttribute(ARCHITECTURE_ATTRIBUTE_NAME, architecture.toString());
    }

    public void setArchitecture(String architectureName) throws InvalidAttributeValueException {
        this.addAttribute(ARCHITECTURE_ATTRIBUTE_NAME, architectureName);
    }

    @Override
    public String getDefaultKindIdentifier() {
        return KIND_IDENTIFIER_DEFAULT;
    }

    public static List<Attribute> getDefaultAttributes() {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        list.addAll(Resource.getDefaultAttributes());
        list.add(new Attribute(ARCHITECTURE_ATTRIBUTE_NAME, false, false));
        list.add(new Attribute(CORES_ATTRIBUTE_NAME, false, false));
        list.add(new Attribute(HOSTNAME_ATTRIBUTE_NAME, false, false));
        list.add(new Attribute(SPEED_ATTRIBUTE_NAME, false, false));
        list.add(new Attribute(MEMORY_ATTRIBUTE_NAME, false, false));
        list.add(new Attribute(STATE_ATTRIBUTE_NAME, true, true));
        return list;
    }

    public static Kind getDefaultKind() {
        Kind kind = new Kind(SCHEME_DEFAULT, TERM_DEFAULT, "Compute Resource", URI.create("/compute/"), Compute.getDefaultAttributes());
        return kind;
    }
}

