/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.infrastructure;

import cz.cesnet.cloud.occi.Model;
import cz.cesnet.cloud.occi.core.Attribute;
import cz.cesnet.cloud.occi.core.Category;
import cz.cesnet.cloud.occi.core.Kind;
import cz.cesnet.cloud.occi.core.Link;
import cz.cesnet.cloud.occi.exception.InvalidAttributeValueException;
import cz.cesnet.cloud.occi.infrastructure.Storage;
import cz.cesnet.cloud.occi.infrastructure.enumeration.StorageLinkState;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class StorageLink
extends Link {
    public static final String DEVICE_ID_ATTRIBUTE_NAME = "occi.storagelink.deviceid";
    public static final String MOUNTPOINT_ATTRIBUTE_NAME = "occi.storagelink.mountpoint";
    public static final String STATE_ATTRIBUTE_NAME = "occi.storagelink.state";
    public static final URI SCHEME_DEFAULT = Category.SCHEME_INFRASTRUCTURE_DEFAULT;
    public static final String TERM_DEFAULT = "storagelink";
    public static final String KIND_IDENTIFIER_DEFAULT = SCHEME_DEFAULT + "storagelink";

    public StorageLink(String id, Kind kind, String title, Model model) throws InvalidAttributeValueException {
        super(id, kind, title, model);
    }

    public StorageLink(String id, Kind kind) throws InvalidAttributeValueException {
        super(id, kind);
    }

    public String getDeviceId() {
        return this.getValue(DEVICE_ID_ATTRIBUTE_NAME);
    }

    public void setDeviceId(String id) throws InvalidAttributeValueException {
        this.addAttribute(DEVICE_ID_ATTRIBUTE_NAME, id);
    }

    public String getMountpoint() {
        return this.getValue(MOUNTPOINT_ATTRIBUTE_NAME);
    }

    public void setMountpoint(String mountpoint) throws InvalidAttributeValueException {
        this.addAttribute(MOUNTPOINT_ATTRIBUTE_NAME, mountpoint);
    }

    public String getState() {
        return this.getValue(STATE_ATTRIBUTE_NAME);
    }

    public void setState(StorageLinkState state) throws InvalidAttributeValueException {
        if (state == null) {
            throw new NullPointerException("state cannot be null");
        }
        this.addAttribute(STATE_ATTRIBUTE_NAME, state.toString());
    }

    public void setState(String stateName) throws InvalidAttributeValueException {
        this.addAttribute(STATE_ATTRIBUTE_NAME, stateName);
    }

    @Override
    public String getDefaultKindIdentifier() {
        return KIND_IDENTIFIER_DEFAULT;
    }

    public static List<Attribute> getDefaultAttributes() {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        list.addAll(Storage.getDefaultAttributes());
        list.add(new Attribute(DEVICE_ID_ATTRIBUTE_NAME, true, false));
        list.add(new Attribute(MOUNTPOINT_ATTRIBUTE_NAME, false, false));
        list.add(new Attribute(STATE_ATTRIBUTE_NAME, true, true));
        return list;
    }

    public static Kind getDefaultKind() {
        Kind kind = new Kind(SCHEME_DEFAULT, TERM_DEFAULT, "Storage Link", URI.create("/storagelink/"), StorageLink.getDefaultAttributes());
        return kind;
    }
}

