/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.collection;

import com.sun.net.httpserver.Headers;
import cz.cesnet.cloud.occi.core.Attribute;
import cz.cesnet.cloud.occi.renderer.TextRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AttributeMapCover {
    private final Map<Attribute, String> attributes = new HashMap<Attribute, String>();

    public void add(Attribute attribute, String value) {
        if (attribute == null) {
            throw new NullPointerException("Cannot add null attribute.");
        }
        if (value == null) {
            throw new NullPointerException("Cannot add null value.");
        }
        this.attributes.put(attribute, value);
    }

    public void remove(Attribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("Cannot remove null attribute.");
        }
        this.attributes.remove(attribute);
    }

    public void remove(String attributeName) {
        Attribute attTmp = new Attribute(attributeName);
        this.attributes.remove(attTmp);
    }

    public boolean containsAttribute(Attribute attribute) {
        return this.attributes.containsKey(attribute);
    }

    public boolean containsAttribute(String attributeName) {
        Attribute attTmp = new Attribute(attributeName);
        return this.containsAttribute(attTmp);
    }

    public String getValue(Attribute attribute) {
        return this.attributes.get(attribute);
    }

    public String getValue(String attributeName) {
        Attribute attTmp = new Attribute(attributeName);
        return this.getValue(attTmp);
    }

    public Map<Attribute, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void clear() {
        this.attributes.clear();
    }

    public int size() {
        return this.attributes.size();
    }

    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + Objects.hashCode(this.attributes);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeMapCover other = (AttributeMapCover)obj;
        return Objects.equals(this.attributes, other.attributes);
    }

    public String toString() {
        return "AttributeMapCover{" + this.attributes + '}';
    }

    private List<String> toList() {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>(this.attributes.keySet());
        Collections.sort(attributeList);
        for (Attribute attribute : attributeList) {
            String name = attribute.getName();
            StringBuilder sb = new StringBuilder(name);
            String value = this.attributes.get(attribute);
            if (value.matches("[0-9]+\\.[0-9]+|[0-9]+")) {
                sb.append(TextRenderer.surroundString(value, "=", ""));
            } else {
                sb.append(TextRenderer.surroundString(value, "=\"", "\""));
            }
            list.add(sb.toString());
        }
        Collections.sort(list);
        return list;
    }

    public String toPrefixText() {
        String prefix = "X-OCCI-Attribute: ";
        StringBuilder sb = new StringBuilder();
        for (String s : this.toList()) {
            sb.append(prefix);
            sb.append(s);
            sb.append("\n");
        }
        if (!sb.toString().isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public Headers toHeaders() {
        Headers headers = new Headers();
        for (String s : this.toList()) {
            headers.add("X-OCCI-Attribute", s);
        }
        return headers;
    }

    public String toOneLineText() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.toList()) {
            sb.append(s);
            sb.append(";");
        }
        return sb.toString();
    }
}

