/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.core;

import com.sun.net.httpserver.Headers;
import cz.cesnet.cloud.occi.core.Attribute;
import cz.cesnet.cloud.occi.core.Category;
import cz.cesnet.cloud.occi.renderer.TextRenderer;
import cz.cesnet.cloud.occi.type.Identifiable;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Action
implements Identifiable,
Comparable<Action> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Action.class);
    private Category category;

    public Action(URI scheme, String term, String title, Collection<Attribute> attributes) {
        LOGGER.debug("Creating action: scheme={}, term={}, title={}, attributes={}", new Object[]{scheme, term, title, attributes});
        this.category = new Category(scheme, term, title, null, attributes);
    }

    public Action(URI scheme, String term) {
        this(scheme, term, null, null);
    }

    public URI getScheme() {
        return this.category.getScheme();
    }

    public void setScheme(URI scheme) {
        this.category.setScheme(scheme);
    }

    public String getTerm() {
        return this.category.getTerm();
    }

    public void setTerm(String term) {
        this.category.setTerm(term);
    }

    @Override
    public String getIdentifier() {
        return this.category.getIdentifier();
    }

    public String getTitle() {
        return this.category.getTitle();
    }

    public void setTitle(String title) {
        this.category.setTitle(title);
    }

    public boolean containsAttribute(Attribute attribute) {
        return this.category.containsAttribute(attribute);
    }

    public boolean containsAttribute(String attributeName) {
        return this.category.containsAttribute(attributeName);
    }

    public boolean addAttribute(Attribute attribute) {
        return this.category.addAttribute(attribute);
    }

    public Attribute getAttribute(String attributeName) {
        return this.category.getAttribute(attributeName);
    }

    public boolean removeAttribute(Attribute attribute) {
        return this.category.removeAttribute(attribute);
    }

    public Set<Attribute> getAttributes() {
        return this.category.getAttributes();
    }

    public URI getSchemeDefault() {
        return Category.SCHEME_CORE_DEFAULT;
    }

    public String getTermDefault() {
        return "action";
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.category);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Action other = (Action)obj;
        return Objects.equals(this.category, other.category);
    }

    public String toString() {
        return "Action{category=" + this.category + '}';
    }

    public String toText(String resourceLocation) {
        StringBuilder sb = new StringBuilder("Link: ");
        sb.append(this.textBody(resourceLocation));
        return sb.toString();
    }

    public Headers toHeaders(String resourceLocation) {
        Headers headers = new Headers();
        headers.add("Link", this.textBody(resourceLocation));
        return headers;
    }

    private String textBody(String resourceLocation) {
        StringBuilder sb = new StringBuilder("");
        String descriptor = resourceLocation + "?action=" + this.getTerm();
        sb.append(TextRenderer.surroundString(descriptor, "<", ">;"));
        sb.append("rel");
        sb.append(TextRenderer.surroundString(this.getScheme().toString() + this.getTerm()));
        return sb.toString();
    }

    @Override
    public int compareTo(Action a) {
        return this.getIdentifier().compareTo(a.getIdentifier());
    }
}

