/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.core;

import com.sun.net.httpserver.Headers;
import cz.cesnet.cloud.occi.Model;
import cz.cesnet.cloud.occi.collection.AttributeMapCover;
import cz.cesnet.cloud.occi.core.Action;
import cz.cesnet.cloud.occi.core.Attribute;
import cz.cesnet.cloud.occi.renderer.TextRenderer;
import cz.cesnet.cloud.occi.type.Identifiable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionInstance
implements Identifiable,
Comparable<ActionInstance> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionInstance.class);
    private final AttributeMapCover attributes = new AttributeMapCover();
    private Action action;
    private Model model;

    public ActionInstance(Action action) {
        LOGGER.debug("Creating ActionInstance: action={}", (Object)action);
        if (action == null) {
            throw new NullPointerException("ActionInstance action cannot be null.");
        }
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        if (action == null) {
            throw new NullPointerException("ActionInstance action cannot be null.");
        }
        this.action = action;
    }

    @Override
    public String getIdentifier() {
        return this.action.getIdentifier();
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public void addAttribute(Attribute attribute, String value) {
        this.attributes.add(attribute, value);
    }

    public void addAttributes(Map<String, String> attributes) {
        for (String name : attributes.keySet()) {
            this.addAttribute(new Attribute(name), attributes.get(name));
        }
    }

    public void removeAttribute(Attribute attribute) {
        this.attributes.remove(attribute);
    }

    public boolean containsAttribute(Attribute attribute) {
        return this.attributes.containsAttribute(attribute);
    }

    public boolean containsAttribute(String attributeName) {
        return this.attributes.containsAttribute(attributeName);
    }

    public String getValue(Attribute attribute) {
        return this.attributes.getValue(attribute);
    }

    public String getValue(String attributeName) {
        return this.attributes.getValue(attributeName);
    }

    public Map<Attribute, String> getAttributes() {
        return this.attributes.getAttributes();
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public String toText() {
        StringBuilder sb = new StringBuilder("Category: ");
        sb.append(this.textBody());
        String attributesString = this.attributes.toPrefixText();
        if (!attributesString.isEmpty()) {
            sb.append("\n");
            sb.append(attributesString);
        }
        return sb.toString();
    }

    public Headers toHeaders() {
        Headers headers = new Headers();
        headers.add("Category", this.textBody());
        Headers attributesHeaders = this.attributes.toHeaders();
        if (!attributesHeaders.isEmpty()) {
            headers.putAll(attributesHeaders);
        }
        return headers;
    }

    private String textBody() {
        Set<Attribute> actionAttributes;
        StringBuilder sb = new StringBuilder(this.action.getTerm());
        sb.append(";");
        sb.append("scheme");
        sb.append(TextRenderer.surroundString(this.action.getScheme().toString()));
        sb.append("class");
        sb.append(TextRenderer.surroundString(this.action.getClass().getSimpleName().toLowerCase()));
        String title = this.action.getTitle();
        if (title != null && !title.isEmpty()) {
            sb.append("title");
            sb.append(TextRenderer.surroundString(title));
        }
        if ((actionAttributes = this.action.getAttributes()) != null && !actionAttributes.isEmpty()) {
            sb.append("attributes");
            StringBuilder attrSB = new StringBuilder();
            ArrayList<Attribute> attributeList = new ArrayList<Attribute>(actionAttributes);
            Collections.sort(attributeList);
            for (Attribute attribute : attributeList) {
                attrSB.append(attribute.toText());
                attrSB.append(" ");
            }
            attrSB.deleteCharAt(attrSB.length() - 1);
            sb.append(TextRenderer.surroundString(attrSB.toString()));
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.attributes);
        hash = 41 * hash + Objects.hashCode(this.action);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActionInstance other = (ActionInstance)obj;
        if (!Objects.equals(this.attributes, other.attributes)) {
            return false;
        }
        return Objects.equals(this.action, other.action);
    }

    public String toString() {
        return "ActionInstance{attributes=" + this.attributes + ", action=" + this.action + '}';
    }

    @Override
    public int compareTo(ActionInstance a) {
        return this.getIdentifier().compareTo(a.getIdentifier());
    }
}

