/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.core;

import com.sun.net.httpserver.Headers;
import cz.cesnet.cloud.occi.Model;
import cz.cesnet.cloud.occi.core.Attribute;
import cz.cesnet.cloud.occi.core.Category;
import cz.cesnet.cloud.occi.core.Entity;
import cz.cesnet.cloud.occi.core.Kind;
import cz.cesnet.cloud.occi.core.Mixin;
import cz.cesnet.cloud.occi.core.Resource;
import cz.cesnet.cloud.occi.exception.InvalidAttributeValueException;
import cz.cesnet.cloud.occi.exception.RenderingException;
import cz.cesnet.cloud.occi.renderer.TextRenderer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Link
extends Entity {
    public static final String SOURCE_ATTRIBUTE_NAME = "occi.core.source";
    public static final String TARGET_ATTRIBUTE_NAME = "occi.core.target";
    public static final URI SCHEME_DEFAULT = Category.SCHEME_CORE_DEFAULT;
    public static final String TERM_DEFAULT = "link";
    public static final String KIND_IDENTIFIER_DEFAULT = SCHEME_DEFAULT + "link";
    private String relation;

    public Link(String id, Kind kind, String title, Model model) throws InvalidAttributeValueException {
        super(id, kind, title, model);
    }

    public Link(String id, Kind kind) throws InvalidAttributeValueException {
        super(id, kind);
    }

    public String getSource() {
        return this.getValue(SOURCE_ATTRIBUTE_NAME);
    }

    public void setSource(Resource source) throws InvalidAttributeValueException {
        if (source == null) {
            throw new NullPointerException("source cannot be null");
        }
        this.addAttribute(SOURCE_ATTRIBUTE_NAME, source.getLocation());
    }

    public void setSource(String sourceLocation) throws InvalidAttributeValueException {
        this.addAttribute(SOURCE_ATTRIBUTE_NAME, sourceLocation);
    }

    public String getTarget() {
        return this.getValue(TARGET_ATTRIBUTE_NAME);
    }

    public void setTarget(Resource target) throws InvalidAttributeValueException {
        if (target == null) {
            throw new NullPointerException("target cannot be null");
        }
        this.addAttribute(TARGET_ATTRIBUTE_NAME, target.getLocation());
    }

    public void setTarget(String targetLocation) throws InvalidAttributeValueException {
        this.addAttribute(TARGET_ATTRIBUTE_NAME, targetLocation);
    }

    public String getRelation() {
        return this.relation;
    }

    public void setRelation(String relation) {
        this.relation = relation;
    }

    @Override
    public String getDefaultKindIdentifier() {
        return KIND_IDENTIFIER_DEFAULT;
    }

    public static List<Attribute> getDefaultAttributes() {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        list.addAll(Entity.getDefaultAttributes());
        list.add(new Attribute(SOURCE_ATTRIBUTE_NAME, true, false));
        list.add(new Attribute(TARGET_ATTRIBUTE_NAME, true, false));
        return list;
    }

    public static Kind getDefaultKind() {
        Kind kind = new Kind(SCHEME_DEFAULT, TERM_DEFAULT, "Link", URI.create("/link/"), Link.getDefaultAttributes());
        return kind;
    }

    @Override
    public String toText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getKind().toText(false));
        ArrayList<Mixin> mixinList = new ArrayList<Mixin>(this.getMixins());
        Collections.sort(mixinList);
        for (Mixin m : mixinList) {
            sb.append("\n");
            sb.append(m.toText(false));
        }
        String attributesString = this.attributesToPrefixText();
        if (!attributesString.isEmpty()) {
            sb.append("\n");
            sb.append(attributesString);
        }
        return sb.toString();
    }

    @Override
    public Headers toHeaders() {
        Headers headers = new Headers();
        headers.putAll(this.getKind().toHeaders(false));
        ArrayList<Mixin> mixinList = new ArrayList<Mixin>(this.getMixins());
        Collections.sort(mixinList);
        for (Mixin m : mixinList) {
            Headers mixinHeaders = m.toHeaders(false);
            for (String name : mixinHeaders.keySet()) {
                Iterator i$ = mixinHeaders.get(name).iterator();
                while (i$.hasNext()) {
                    String value = (String)i$.next();
                    headers.add(name, value);
                }
            }
        }
        Headers attributeHeaders = this.attributesToHeaders();
        if (!attributeHeaders.isEmpty()) {
            headers.putAll(attributeHeaders);
        }
        return headers;
    }

    public String toInlineText() throws RenderingException {
        StringBuilder sb = new StringBuilder("Link: ");
        sb.append(this.inlineTextBody());
        return sb.toString();
    }

    public Headers toInlineHeaders() throws RenderingException {
        Headers headers = new Headers();
        headers.add("Link", this.inlineTextBody());
        return headers;
    }

    private String inlineTextBody() throws RenderingException {
        StringBuilder sb = new StringBuilder("");
        if (this.getTarget() == null || this.getTarget().isEmpty()) {
            throw new RenderingException("Link " + this + " is missing a target attribute.");
        }
        sb.append(TextRenderer.surroundString(this.getTarget(), "<", ">;"));
        if (this.relation == null || this.relation.isEmpty()) {
            throw new RenderingException("Link " + this + " is missing a relation.");
        }
        sb.append("rel");
        sb.append(TextRenderer.surroundString(this.relation));
        if (this.getKind().getLocation() != null && this.getId() != null && !this.getId().isEmpty()) {
            sb.append("self");
            sb.append(TextRenderer.surroundString(this.getKind().getLocation().toString() + this.getId()));
        }
        sb.append("category");
        sb.append("=\"");
        sb.append(this.getKind().getIdentifier());
        for (Mixin mixin : this.getMixins()) {
            sb.append(" ");
            sb.append(mixin.getIdentifier());
        }
        sb.append("\";");
        sb.append(this.attributesToOneLineText());
        return sb.toString();
    }

    @Override
    public String toJSON() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

