/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.extension.DeweyDecimal;
import org.apache.tools.ant.taskdefs.optional.extension.Extension;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

public class ExtensionAdapter
extends DataType {
    private String m_extensionName;
    private DeweyDecimal m_specificationVersion;
    private String m_specificationVendor;
    private String m_implementationVendorID;
    private String m_implementationVendor;
    private DeweyDecimal m_implementationVersion;
    private String m_implementationURL;

    public void setExtensionName(String extensionName) {
        this.verifyNotAReference();
        this.m_extensionName = extensionName;
    }

    public void setSpecificationVersion(String specificationVersion) {
        this.verifyNotAReference();
        this.m_specificationVersion = new DeweyDecimal(specificationVersion);
    }

    public void setSpecificationVendor(String specificationVendor) {
        this.verifyNotAReference();
        this.m_specificationVendor = specificationVendor;
    }

    public void setImplementationVendorId(String implementationVendorID) {
        this.verifyNotAReference();
        this.m_implementationVendorID = implementationVendorID;
    }

    public void setImplementationVendor(String implementationVendor) {
        this.verifyNotAReference();
        this.m_implementationVendor = implementationVendor;
    }

    public void setImplementationVersion(String implementationVersion) {
        this.verifyNotAReference();
        this.m_implementationVersion = new DeweyDecimal(implementationVersion);
    }

    public void setImplementationUrl(String implementationURL) {
        this.verifyNotAReference();
        this.m_implementationURL = implementationURL;
    }

    public void setRefid(Reference reference) throws BuildException {
        if (null != this.m_extensionName || null != this.m_specificationVersion || null != this.m_specificationVendor || null != this.m_implementationVersion || null != this.m_implementationVendorID || null != this.m_implementationVendor || null != this.m_implementationURL) {
            throw this.tooManyAttributes();
        }
        Object o = reference.getReferencedObject(this.getProject());
        if (!(o instanceof ExtensionAdapter)) {
            String message = reference.getRefId() + " doesn't refer to a Extension";
            throw new BuildException(message);
        }
        ExtensionAdapter other = (ExtensionAdapter)((Object)o);
        this.m_extensionName = other.m_extensionName;
        this.m_specificationVersion = other.m_specificationVersion;
        this.m_specificationVendor = other.m_specificationVendor;
        this.m_implementationVersion = other.m_implementationVersion;
        this.m_implementationVendorID = other.m_implementationVendorID;
        this.m_implementationVendor = other.m_implementationVendor;
        this.m_implementationURL = other.m_implementationURL;
        super.setRefid(reference);
    }

    private void verifyNotAReference() throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
    }

    Extension toExtension() throws BuildException {
        if (null == this.m_extensionName) {
            throw new BuildException("Extension is missing name.");
        }
        String specificationVersion = null;
        if (null != this.m_specificationVersion) {
            specificationVersion = this.m_specificationVersion.toString();
        }
        String implementationVersion = null;
        if (null != this.m_implementationVersion) {
            implementationVersion = this.m_implementationVersion.toString();
        }
        return new Extension(this.m_extensionName, specificationVersion, this.m_specificationVendor, implementationVersion, this.m_implementationVendorID, this.m_implementationVendor, this.m_implementationURL);
    }

    public String toString() {
        return "{" + this.toExtension().toString() + "}";
    }
}

