/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class IndentedWriter
extends FilterWriter {
    static final String EOL;
    int indent_level = 0;
    boolean at_line_start = true;

    public IndentedWriter(Writer out) {
        super(out);
    }

    private boolean isEol(char c) {
        return c == '\r' || c == '\n';
    }

    public void upIndent() {
        ++this.indent_level;
    }

    public void downIndent() {
        --this.indent_level;
    }

    public void write(int c) throws IOException {
        this.out.write(c);
        this.at_line_start = this.isEol((char)c);
    }

    public void write(char[] chars, int off, int len) throws IOException {
        this.out.write(chars, off, len);
        this.at_line_start = this.isEol(chars[off + len - 1]);
    }

    public void write(String s, int off, int len) throws IOException {
        if (len > 0) {
            this.out.write(s, off, len);
            this.at_line_start = this.isEol(s.charAt(off + len - 1));
        }
    }

    private void printIndent() throws IOException {
        for (int i = 0; i < this.indent_level; ++i) {
            this.out.write(9);
        }
    }

    public void print(String s) throws IOException {
        if (this.at_line_start) {
            this.printIndent();
        }
        this.out.write(s);
        char last = s.charAt(s.length() - 1);
        this.at_line_start = this.isEol(last);
    }

    public void println(String s) throws IOException {
        if (this.at_line_start) {
            this.printIndent();
        }
        this.out.write(s);
        this.out.write(EOL);
        this.at_line_start = true;
    }

    public void print(boolean x) throws IOException {
        this.print(String.valueOf(x));
    }

    public void print(byte x) throws IOException {
        this.print(String.valueOf(x));
    }

    public void print(char x) throws IOException {
        this.print(String.valueOf(x));
    }

    public void print(short x) throws IOException {
        this.print(String.valueOf(x));
    }

    public void print(int x) throws IOException {
        this.print(String.valueOf(x));
    }

    public void print(long x) throws IOException {
        this.print(String.valueOf(x));
    }

    public void print(float x) throws IOException {
        this.print(String.valueOf(x));
    }

    public void print(double x) throws IOException {
        this.print(String.valueOf(x));
    }

    public void print(Object x) throws IOException {
        this.print(String.valueOf(x));
    }

    public void println(boolean x) throws IOException {
        this.println(String.valueOf(x));
    }

    public void println(byte x) throws IOException {
        this.println(String.valueOf(x));
    }

    public void println(char x) throws IOException {
        this.println(String.valueOf(x));
    }

    public void println(short x) throws IOException {
        this.println(String.valueOf(x));
    }

    public void println(int x) throws IOException {
        this.println(String.valueOf(x));
    }

    public void println(long x) throws IOException {
        this.println(String.valueOf(x));
    }

    public void println(float x) throws IOException {
        this.println(String.valueOf(x));
    }

    public void println(double x) throws IOException {
        this.println(String.valueOf(x));
    }

    public void println(Object x) throws IOException {
        this.println(String.valueOf(x));
    }

    public void println() throws IOException {
        this.println("");
    }

    static {
        String eol = System.getProperty("line.separator");
        EOL = eol != null ? eol : "\r\n";
    }
}

