/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen.bean;

import com.mchange.v1.lang.ClassUtils;
import com.mchange.v2.codegen.CodegenUtils;
import com.mchange.v2.codegen.IndentedWriter;
import com.mchange.v2.codegen.bean.BeangenUtils;
import com.mchange.v2.codegen.bean.ClassInfo;
import com.mchange.v2.codegen.bean.GeneratorExtension;
import com.mchange.v2.codegen.bean.Property;
import com.mchange.v2.codegen.bean.PropertyBeanGenerator;
import com.mchange.v2.codegen.bean.SerializableExtension;
import com.mchange.v2.codegen.bean.SimpleClassInfo;
import com.mchange.v2.codegen.bean.SimpleProperty;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class SimplePropertyBeanGenerator
implements PropertyBeanGenerator {
    static final Comparator PROPERTY_COMPARATOR = new Comparator(){

        public int compare(Object a, Object b) {
            Property aa = (Property)a;
            Property bb = (Property)b;
            return aa.getName().compareTo(bb.getName());
        }
    };
    private boolean inner = false;
    private int java_version = 130;
    private boolean force_unmodifiable = false;
    private String generatorName = this.getClass().getName();
    protected ClassInfo info;
    protected Property[] props;
    protected IndentedWriter iw;
    protected Set generalImports;
    protected Set specificImports;
    protected Set interfaceNames;
    protected Class superclassType;
    protected List interfaceTypes;
    protected Class[] propertyTypes;
    protected List generatorExtensions = new ArrayList();

    public synchronized void setInner(boolean inner) {
        this.inner = inner;
    }

    public synchronized boolean isInner() {
        return this.inner;
    }

    public synchronized void setJavaVersion(int version) {
        this.java_version = this.java_version;
    }

    public synchronized int getJavaVersion() {
        return this.java_version;
    }

    public synchronized void setGeneratorName(String generatorName) {
        this.generatorName = generatorName;
    }

    public synchronized String getGeneratorName() {
        return this.generatorName;
    }

    public synchronized void setForceUnmodifiable(boolean force_unmodifiable) {
        this.force_unmodifiable = force_unmodifiable;
    }

    public synchronized boolean isForceUnmodifiable() {
        return this.force_unmodifiable;
    }

    public synchronized void addExtension(GeneratorExtension ext) {
        this.generatorExtensions.add(ext);
    }

    public synchronized void removeExtension(GeneratorExtension ext) {
        this.generatorExtensions.remove(ext);
    }

    public synchronized void generate(ClassInfo info, Property[] props, Writer w) throws IOException {
        this.info = info;
        this.props = props;
        Arrays.sort(props, PROPERTY_COMPARATOR);
        this.iw = w instanceof IndentedWriter ? (IndentedWriter)w : new IndentedWriter(w);
        this.generalImports = new TreeSet();
        if (info.getGeneralImports() != null) {
            this.generalImports.addAll(Arrays.asList(info.getGeneralImports()));
        }
        this.specificImports = new TreeSet();
        if (info.getSpecificImports() != null) {
            this.specificImports.addAll(Arrays.asList(info.getSpecificImports()));
        }
        this.interfaceNames = new TreeSet();
        if (info.getInterfaceNames() != null) {
            this.interfaceNames.addAll(Arrays.asList(info.getInterfaceNames()));
        }
        this.addInternalImports();
        this.addInternalInterfaces();
        this.resolveTypes();
        if (!this.inner) {
            this.writeHeader();
            this.iw.println();
        }
        this.writeClassDeclaration();
        this.iw.println('{');
        this.iw.upIndent();
        this.writeCoreBody();
        this.iw.downIndent();
        this.iw.println('}');
    }

    protected void resolveTypes() {
        String[] gen = this.generalImports.toArray(new String[this.generalImports.size()]);
        String[] spc = this.specificImports.toArray(new String[this.specificImports.size()]);
        if (this.info.getSuperclassName() != null) {
            try {
                this.superclassType = ClassUtils.forName((String)this.info.getSuperclassName(), (String[])gen, (String[])spc);
            }
            catch (Exception e) {
                System.err.println("WARNING: " + this.getClass().getName() + " could not resolve " + "superclass '" + this.info.getSuperclassName() + "'.");
                this.superclassType = null;
            }
        }
        this.interfaceTypes = new ArrayList(this.interfaceNames.size());
        Iterator ii = this.interfaceNames.iterator();
        while (ii.hasNext()) {
            String name = (String)ii.next();
            try {
                this.interfaceTypes.add(ClassUtils.forName((String)name, (String[])gen, (String[])spc));
            }
            catch (Exception e) {
                System.err.println("WARNING: " + this.getClass().getName() + " could not resolve " + "interface '" + name + "'.");
                this.interfaceTypes.add(null);
            }
        }
        this.propertyTypes = new Class[this.props.length];
        int len = this.props.length;
        for (int i = 0; i < len; ++i) {
            String name = this.props[i].getSimpleTypeName();
            try {
                this.propertyTypes[i] = ClassUtils.forName((String)name, (String[])gen, (String[])spc);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("WARNING: " + this.getClass().getName() + " could not resolve " + "property type '" + name + "'.");
                this.propertyTypes[i] = null;
            }
        }
    }

    protected void addInternalImports() {
        if (this.boundProperties()) {
            this.specificImports.add("java.beans.PropertyChangeEvent");
            this.specificImports.add("java.beans.PropertyChangeSupport");
            this.specificImports.add("java.beans.PropertyChangeListener");
        }
        if (this.constrainedProperties()) {
            this.specificImports.add("java.beans.PropertyChangeEvent");
            this.specificImports.add("java.beans.PropertyVetoException");
            this.specificImports.add("java.beans.VetoableChangeSupport");
            this.specificImports.add("java.beans.VetoableChangeListener");
        }
        Iterator ii = this.generatorExtensions.iterator();
        while (ii.hasNext()) {
            GeneratorExtension ge = (GeneratorExtension)ii.next();
            this.specificImports.addAll(ge.extraSpecificImports());
            this.generalImports.addAll(ge.extraGeneralImports());
        }
    }

    protected void addInternalInterfaces() {
        Iterator ii = this.generatorExtensions.iterator();
        while (ii.hasNext()) {
            GeneratorExtension ge = (GeneratorExtension)ii.next();
            this.interfaceNames.addAll(ge.extraInterfaceNames());
        }
    }

    protected void writeCoreBody() throws IOException {
        this.writeJavaBeansChangeSupport();
        this.writePropertyMembers();
        this.iw.println();
        this.writeGetterSetterPairs();
        if (this.boundProperties()) {
            this.iw.println();
            this.writeBoundPropertyEventSourceMethods();
        }
        if (this.constrainedProperties()) {
            this.iw.println();
            this.writeConstrainedPropertyEventSourceMethods();
        }
        this.writeInternalUtilityFunctions();
        Iterator ii = this.generatorExtensions.iterator();
        while (ii.hasNext()) {
            GeneratorExtension ext = (GeneratorExtension)ii.next();
            this.iw.println();
            ext.generate(this.info, this.superclassType, this.props, this.propertyTypes, this.iw);
        }
    }

    protected void writeInternalUtilityFunctions() throws IOException {
        this.iw.println("private boolean eqOrBothNull( Object a, Object b )");
        this.iw.println("{");
        this.iw.upIndent();
        this.iw.println("return");
        this.iw.upIndent();
        this.iw.println("a == b ||");
        this.iw.println("(a != null && a.equals(b));");
        this.iw.downIndent();
        this.iw.downIndent();
        this.iw.println("}");
    }

    protected void writeConstrainedPropertyEventSourceMethods() throws IOException {
        this.iw.println("public void addVetoableChangeListener( VetoableChangeListener vcl )");
        this.iw.println("{ vcs.addVetoableChangeListener( vcl ); }");
        this.iw.println();
        this.iw.println("public void removeVetoableChangeListener( VetoableChangeListener vcl )");
        this.iw.println("{ vcs.removeVetoableChangeListener( vcl ); }");
        this.iw.println();
        if (this.java_version >= 140) {
            this.iw.println("public VetoableChangeListener[] getVetoableChangeListeners()");
            this.iw.println("{ return vcs.getPropertyChangeListeners(); }");
        }
    }

    protected void writeBoundPropertyEventSourceMethods() throws IOException {
        this.iw.println("public void addPropertyChangeListener( PropertyChangeListener pcl )");
        this.iw.println("{ pcs.addPropertyChangeListener( pcl ); }");
        this.iw.println();
        this.iw.println("public void removePropertyChangeListener( PropertyChangeListener pcl )");
        this.iw.println("{ pcs.removePropertyChangeListener( pcl ); }");
        this.iw.println();
        if (this.java_version >= 140) {
            this.iw.println("public PropertyChangeListener[] getPropertyChangeListeners()");
            this.iw.println("{ return pcs.getPropertyChangeListeners(); }");
        }
    }

    protected void writeJavaBeansChangeSupport() throws IOException {
        if (this.boundProperties()) {
            this.iw.println("protected PropertyChangeSupport pcs = new PropertyChangeSupport( this );");
        }
        if (this.constrainedProperties()) {
            this.iw.println("protected VetoableChangeSupport vcs = new VetoableChangeSupport( this );");
        }
    }

    protected void writePropertyMembers() throws IOException {
        int len = this.props.length;
        for (int i = 0; i < len; ++i) {
            this.writePropertyMember(this.props[i]);
        }
    }

    protected void writePropertyMember(Property prop) throws IOException {
        this.iw.print(CodegenUtils.getModifierString(prop.getVariableModifiers()));
        this.iw.print(' ' + prop.getSimpleTypeName() + ' ' + prop.getName());
        String dflt = prop.getDefaultValueExpression();
        if (dflt != null) {
            this.iw.print(" = " + dflt);
        }
        this.iw.println(';');
    }

    protected void writeGetterSetterPairs() throws IOException {
        int len = this.props.length;
        for (int i = 0; i < len; ++i) {
            this.writeGetterSetterPair(this.props[i], this.propertyTypes[i]);
            if (i == len - 1) continue;
            this.iw.println();
        }
    }

    protected void writeGetterSetterPair(Property prop, Class propType) throws IOException {
        this.writePropertyGetter(prop, propType);
        if (!prop.isReadOnly() && !this.force_unmodifiable) {
            this.iw.println();
            this.writePropertySetter(prop, propType);
        }
    }

    protected void writePropertyGetter(Property prop, Class propType) throws IOException {
        String pfx = "boolean".equals(prop.getSimpleTypeName()) ? "is" : "get";
        this.iw.print(CodegenUtils.getModifierString(prop.getGetterModifiers()));
        this.iw.println(' ' + prop.getSimpleTypeName() + ' ' + pfx + BeangenUtils.capitalize(prop.getName()) + "()");
        String retVal = this.getGetterDefensiveCopyExpression(prop, propType);
        if (retVal == null) {
            retVal = prop.getName();
        }
        this.iw.println("{ return " + retVal + "; }");
    }

    boolean changeMarked(Property prop) {
        return prop.isBound() || prop.isConstrained();
    }

    protected void writePropertySetter(Property prop, Class propType) throws IOException {
        this.iw.print(CodegenUtils.getModifierString(prop.getSetterModifiers()));
        this.iw.print(" void set" + BeangenUtils.capitalize(prop.getName()) + "( " + prop.getSimpleTypeName() + ' ' + prop.getName() + " )");
        if (prop.isConstrained()) {
            this.iw.println(" throws PropertyVetoException");
        } else {
            this.iw.println();
        }
        String setVal = this.getSetterDefensiveCopyExpression(prop, propType);
        if (setVal == null) {
            setVal = prop.getName();
        }
        this.iw.println('{');
        this.iw.upIndent();
        if (this.changeMarked(prop)) {
            String changeCheck;
            this.iw.println(prop.getSimpleTypeName() + " oldVal = this." + prop.getName() + ';');
            String oldValExpr = "oldVal";
            String newValExpr = prop.getName();
            if (propType.isPrimitive()) {
                if (propType == Byte.TYPE) {
                    oldValExpr = "new Byte( " + oldValExpr + " )";
                    newValExpr = "new Byte( " + newValExpr + " )";
                } else if (propType == Character.TYPE) {
                    oldValExpr = "new Character( " + oldValExpr + " )";
                    newValExpr = "new Character( " + newValExpr + " )";
                } else if (propType == Short.TYPE) {
                    oldValExpr = "new Short( " + oldValExpr + " )";
                    newValExpr = "new Short( " + newValExpr + " )";
                } else if (propType == Float.TYPE) {
                    oldValExpr = "new Float( " + oldValExpr + " )";
                    newValExpr = "new Float( " + newValExpr + " )";
                } else if (propType == Double.TYPE) {
                    oldValExpr = "new Double( " + oldValExpr + " )";
                    newValExpr = "new Double( " + newValExpr + " )";
                }
                changeCheck = "oldVal != " + prop.getName();
            } else {
                changeCheck = "! eqOrBothNull( oldVal, " + prop.getName() + " )";
            }
            if (prop.isConstrained()) {
                this.iw.println("if ( " + changeCheck + " )");
                this.iw.upIndent();
                this.iw.println("vcs.fireVetoableChange( \"" + prop.getName() + "\", " + oldValExpr + ", " + newValExpr + " );");
                this.iw.downIndent();
            }
            this.iw.println("this." + prop.getName() + " = " + setVal + ';');
            if (prop.isBound()) {
                this.iw.println("if ( " + changeCheck + " )");
                this.iw.upIndent();
                this.iw.println("pcs.firePropertyChange( \"" + prop.getName() + "\", " + oldValExpr + ", " + newValExpr + " );");
                this.iw.downIndent();
            }
        } else {
            this.iw.println("this." + prop.getName() + " = " + setVal + ';');
        }
        this.iw.downIndent();
        this.iw.println('}');
    }

    protected String getGetterDefensiveCopyExpression(Property prop, Class propType) {
        return prop.getDefensiveCopyExpression();
    }

    protected String getSetterDefensiveCopyExpression(Property prop, Class propType) {
        return prop.getDefensiveCopyExpression();
    }

    protected String getConstructorDefensiveCopyExpression(Property prop, Class propType) {
        return prop.getDefensiveCopyExpression();
    }

    protected void writeHeader() throws IOException {
        this.writeBannerComments();
        this.iw.println();
        this.iw.println("package " + this.info.getPackageName() + ';');
        this.iw.println();
        this.writeImports();
    }

    protected void writeBannerComments() throws IOException {
        this.iw.println("/*");
        this.iw.println(" * This class autogenerated by " + this.generatorName + '.');
        this.iw.println(" * DO NOT HAND EDIT!");
        this.iw.println(" */");
    }

    protected void writeImports() throws IOException {
        Iterator ii = this.generalImports.iterator();
        while (ii.hasNext()) {
            this.iw.println("import " + ii.next() + ".*;");
        }
        ii = this.specificImports.iterator();
        while (ii.hasNext()) {
            this.iw.println("import " + ii.next() + ";");
        }
    }

    protected void writeClassDeclaration() throws IOException {
        this.iw.print(CodegenUtils.getModifierString(this.info.getModifiers()) + " class " + this.info.getClassName());
        String superclassName = this.info.getSuperclassName();
        if (superclassName != null) {
            this.iw.print(" extends " + superclassName);
        }
        if (this.interfaceNames.size() > 0) {
            this.iw.print(" implements ");
            boolean first = true;
            Iterator ii = this.interfaceNames.iterator();
            while (ii.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    this.iw.print(", ");
                }
                this.iw.print((String)ii.next());
            }
        }
        this.iw.println();
    }

    boolean boundProperties() {
        int len = this.props.length;
        for (int i = 0; i < len; ++i) {
            if (!this.props[i].isBound()) continue;
            return true;
        }
        return false;
    }

    boolean constrainedProperties() {
        int len = this.props.length;
        for (int i = 0; i < len; ++i) {
            if (!this.props[i].isConstrained()) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] argv) {
        try {
            SimpleClassInfo info = new SimpleClassInfo("test", 1, argv[0], null, null, new String[]{"java.awt"}, null);
            Property[] props = new Property[]{new SimpleProperty("number", "int", null, "7", false, true, false), new SimpleProperty("fpNumber", "float", null, null, true, true, false), new SimpleProperty("location", "Point", "new Point( location.x, location.y )", "new Point( 0, 0 )", false, true, true)};
            FileWriter fw = new FileWriter(argv[0] + ".java");
            SimplePropertyBeanGenerator g = new SimplePropertyBeanGenerator();
            g.addExtension(new SerializableExtension());
            g.generate(info, props, fw);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

