/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.yun.push.model;

import com.baidu.yun.core.annotation.HttpParamKeyName;
import com.baidu.yun.core.annotation.R;
import com.baidu.yun.core.annotation.RangeRestrict;
import com.baidu.yun.push.model.PushRequest;
import net.sf.json.JSONArray;

public class PushBatchUniMsgRequest
extends PushRequest {
    @HttpParamKeyName(name="msg_type", param=R.OPTIONAL)
    @RangeRestrict(minLength=0L, maxLength=1L)
    private Integer msgType = new Integer(0);
    @HttpParamKeyName(name="msg", param=R.REQUIRE)
    private String message = null;
    @HttpParamKeyName(name="msg_expires", param=R.OPTIONAL)
    @RangeRestrict(minLength=1L, maxLength=604800L)
    private Integer msgExpires = 18000;
    @HttpParamKeyName(name="channel_ids", param=R.REQUIRE)
    private String channelIds = null;
    @HttpParamKeyName(name="topic_id", param=R.OPTIONAL)
    @RangeRestrict(minLength=1L, maxLength=128L)
    private String topicId = null;

    public Integer getMessageType() {
        return this.msgType;
    }

    public String getMessage() {
        return this.message;
    }

    public Integer getMsgExpires() {
        return this.msgExpires;
    }

    public String getChannelIdsInString() {
        return this.channelIds;
    }

    public String[] getChannelIdsInArray() {
        JSONArray jsonChannelIds = JSONArray.fromObject((Object)this.channelIds);
        return (String[])jsonChannelIds.toArray();
    }

    public String getTopicId() {
        return this.topicId;
    }

    public void setMessageType(Integer msgType) {
        this.msgType = msgType;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMsgExpires(Integer msgExpires) {
        this.msgExpires = msgExpires;
    }

    public void setChannelIds(String[] channelIds) {
        JSONArray tmpChannelIds = new JSONArray();
        for (int i = 0; i < channelIds.length; ++i) {
            tmpChannelIds.add(i, (Object)channelIds[i]);
        }
        this.channelIds = tmpChannelIds.toString();
    }

    public void setTopicId(String topicId) {
        this.topicId = topicId;
    }

    public PushBatchUniMsgRequest addMessageType(Integer msgType) {
        this.msgType = msgType;
        return this;
    }

    public PushBatchUniMsgRequest addMessage(String message) {
        this.message = message;
        return this;
    }

    public PushBatchUniMsgRequest addMsgExpires(Integer msgExpires) {
        this.msgExpires = msgExpires;
        return this;
    }

    public PushBatchUniMsgRequest addDeviceType(Integer deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public PushBatchUniMsgRequest addExpires(Long requestTimeOut) {
        this.expires = requestTimeOut;
        return this;
    }

    public PushBatchUniMsgRequest addChannelIds(String[] channelIds) {
        JSONArray tmpChannelIds = new JSONArray();
        for (int i = 0; i < channelIds.length; ++i) {
            tmpChannelIds.add(i, (Object)channelIds[i]);
        }
        this.channelIds = tmpChannelIds.toString();
        return this;
    }

    public PushBatchUniMsgRequest addTopicId(String topicId) {
        this.topicId = topicId;
        return this;
    }
}

