/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DotExpanderProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    @Nullable
    private final String path;
    public static final JsonpDeserializer<DotExpanderProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DotExpanderProcessor::setupDotExpanderProcessorDeserializer);

    private DotExpanderProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.path = builder.path;
    }

    public static DotExpanderProcessor of(Function<Builder, ObjectBuilder<DotExpanderProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.DotExpander;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final String path() {
        return this.path;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.path != null) {
            generator.writeKey("path");
            generator.write(this.path);
        }
    }

    protected static void setupDotExpanderProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DotExpanderProcessor> {
        private String field;
        @Nullable
        private String path;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder path(@Nullable String value) {
            this.path = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DotExpanderProcessor build() {
            this._checkSingleUse();
            return new DotExpanderProcessor(this);
        }
    }
}

