/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.FilterRef;
import co.elastic.clients.elasticsearch.ml.RuleAction;
import co.elastic.clients.elasticsearch.ml.RuleCondition;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DetectionRule
implements JsonpSerializable {
    private final List<RuleAction> actions;
    private final List<RuleCondition> conditions;
    private final Map<String, FilterRef> scope;
    public static final JsonpDeserializer<DetectionRule> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DetectionRule::setupDetectionRuleDeserializer);

    private DetectionRule(Builder builder) {
        this.actions = ApiTypeHelper.unmodifiable(builder.actions);
        this.conditions = ApiTypeHelper.unmodifiable(builder.conditions);
        this.scope = ApiTypeHelper.unmodifiable(builder.scope);
    }

    public static DetectionRule of(Function<Builder, ObjectBuilder<DetectionRule>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<RuleAction> actions() {
        return this.actions;
    }

    public final List<RuleCondition> conditions() {
        return this.conditions;
    }

    public final Map<String, FilterRef> scope() {
        return this.scope;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.actions)) {
            generator.writeKey("actions");
            generator.writeStartArray();
            for (RuleAction ruleAction : this.actions) {
                ruleAction.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.conditions)) {
            generator.writeKey("conditions");
            generator.writeStartArray();
            for (RuleCondition ruleCondition : this.conditions) {
                ruleCondition.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.scope)) {
            generator.writeKey("scope");
            generator.writeStartObject();
            for (Map.Entry entry : this.scope.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((FilterRef)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDetectionRuleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.arrayDeserializer(RuleAction._DESERIALIZER), "actions");
        op.add(Builder::conditions, JsonpDeserializer.arrayDeserializer(RuleCondition._DESERIALIZER), "conditions");
        op.add(Builder::scope, JsonpDeserializer.stringMapDeserializer(FilterRef._DESERIALIZER), "scope");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DetectionRule> {
        @Nullable
        private List<RuleAction> actions;
        @Nullable
        private List<RuleCondition> conditions;
        @Nullable
        private Map<String, FilterRef> scope;

        public final Builder actions(List<RuleAction> list) {
            this.actions = Builder._listAddAll(this.actions, list);
            return this;
        }

        public final Builder actions(RuleAction value, RuleAction ... values) {
            this.actions = Builder._listAdd(this.actions, value, values);
            return this;
        }

        public final Builder conditions(List<RuleCondition> list) {
            this.conditions = Builder._listAddAll(this.conditions, list);
            return this;
        }

        public final Builder conditions(RuleCondition value, RuleCondition ... values) {
            this.conditions = Builder._listAdd(this.conditions, value, values);
            return this;
        }

        public final Builder conditions(Function<RuleCondition.Builder, ObjectBuilder<RuleCondition>> fn) {
            return this.conditions(fn.apply(new RuleCondition.Builder()).build(), new RuleCondition[0]);
        }

        public final Builder scope(Map<String, FilterRef> map) {
            this.scope = Builder._mapPutAll(this.scope, map);
            return this;
        }

        public final Builder scope(String key, FilterRef value) {
            this.scope = Builder._mapPut(this.scope, key, value);
            return this;
        }

        public final Builder scope(String key, Function<FilterRef.Builder, ObjectBuilder<FilterRef>> fn) {
            return this.scope(key, fn.apply(new FilterRef.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DetectionRule build() {
            this._checkSingleUse();
            return new DetectionRule(this);
        }
    }
}

