/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Audit;
import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.elasticsearch.xpack.usage.FeatureToggle;
import co.elastic.clients.elasticsearch.xpack.usage.IpFilter;
import co.elastic.clients.elasticsearch.xpack.usage.Realm;
import co.elastic.clients.elasticsearch.xpack.usage.RoleMapping;
import co.elastic.clients.elasticsearch.xpack.usage.SecurityRoles;
import co.elastic.clients.elasticsearch.xpack.usage.Ssl;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Security
extends Base {
    private final FeatureToggle apiKeyService;
    private final FeatureToggle anonymous;
    private final Audit audit;
    private final FeatureToggle fips140;
    private final IpFilter ipfilter;
    private final Map<String, Realm> realms;
    private final Map<String, RoleMapping> roleMapping;
    private final SecurityRoles roles;
    private final Ssl ssl;
    @Nullable
    private final FeatureToggle systemKey;
    private final FeatureToggle tokenService;
    private final Base operatorPrivileges;
    public static final JsonpDeserializer<Security> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Security::setupSecurityDeserializer);

    private Security(Builder builder) {
        super(builder);
        this.apiKeyService = ApiTypeHelper.requireNonNull(builder.apiKeyService, this, "apiKeyService");
        this.anonymous = ApiTypeHelper.requireNonNull(builder.anonymous, this, "anonymous");
        this.audit = ApiTypeHelper.requireNonNull(builder.audit, this, "audit");
        this.fips140 = ApiTypeHelper.requireNonNull(builder.fips140, this, "fips140");
        this.ipfilter = ApiTypeHelper.requireNonNull(builder.ipfilter, this, "ipfilter");
        this.realms = ApiTypeHelper.unmodifiableRequired(builder.realms, (Object)this, "realms");
        this.roleMapping = ApiTypeHelper.unmodifiableRequired(builder.roleMapping, (Object)this, "roleMapping");
        this.roles = ApiTypeHelper.requireNonNull(builder.roles, this, "roles");
        this.ssl = ApiTypeHelper.requireNonNull(builder.ssl, this, "ssl");
        this.systemKey = builder.systemKey;
        this.tokenService = ApiTypeHelper.requireNonNull(builder.tokenService, this, "tokenService");
        this.operatorPrivileges = ApiTypeHelper.requireNonNull(builder.operatorPrivileges, this, "operatorPrivileges");
    }

    public static Security of(Function<Builder, ObjectBuilder<Security>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final FeatureToggle apiKeyService() {
        return this.apiKeyService;
    }

    public final FeatureToggle anonymous() {
        return this.anonymous;
    }

    public final Audit audit() {
        return this.audit;
    }

    public final FeatureToggle fips140() {
        return this.fips140;
    }

    public final IpFilter ipfilter() {
        return this.ipfilter;
    }

    public final Map<String, Realm> realms() {
        return this.realms;
    }

    public final Map<String, RoleMapping> roleMapping() {
        return this.roleMapping;
    }

    public final SecurityRoles roles() {
        return this.roles;
    }

    public final Ssl ssl() {
        return this.ssl;
    }

    @Nullable
    public final FeatureToggle systemKey() {
        return this.systemKey;
    }

    public final FeatureToggle tokenService() {
        return this.tokenService;
    }

    public final Base operatorPrivileges() {
        return this.operatorPrivileges;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("api_key_service");
        this.apiKeyService.serialize(generator, mapper);
        generator.writeKey("anonymous");
        this.anonymous.serialize(generator, mapper);
        generator.writeKey("audit");
        this.audit.serialize(generator, mapper);
        generator.writeKey("fips_140");
        this.fips140.serialize(generator, mapper);
        generator.writeKey("ipfilter");
        this.ipfilter.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.realms)) {
            generator.writeKey("realms");
            generator.writeStartObject();
            for (Map.Entry<String, Realm> entry : this.realms.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.roleMapping)) {
            generator.writeKey("role_mapping");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.roleMapping.entrySet()) {
                generator.writeKey(entry.getKey());
                ((RoleMapping)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("roles");
        this.roles.serialize(generator, mapper);
        generator.writeKey("ssl");
        this.ssl.serialize(generator, mapper);
        if (this.systemKey != null) {
            generator.writeKey("system_key");
            this.systemKey.serialize(generator, mapper);
        }
        generator.writeKey("token_service");
        this.tokenService.serialize(generator, mapper);
        generator.writeKey("operator_privileges");
        this.operatorPrivileges.serialize(generator, mapper);
    }

    protected static void setupSecurityDeserializer(ObjectDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::apiKeyService, FeatureToggle._DESERIALIZER, "api_key_service");
        op.add(Builder::anonymous, FeatureToggle._DESERIALIZER, "anonymous");
        op.add(Builder::audit, Audit._DESERIALIZER, "audit");
        op.add(Builder::fips140, FeatureToggle._DESERIALIZER, "fips_140");
        op.add(Builder::ipfilter, IpFilter._DESERIALIZER, "ipfilter");
        op.add(Builder::realms, JsonpDeserializer.stringMapDeserializer(Realm._DESERIALIZER), "realms");
        op.add(Builder::roleMapping, JsonpDeserializer.stringMapDeserializer(RoleMapping._DESERIALIZER), "role_mapping");
        op.add(Builder::roles, SecurityRoles._DESERIALIZER, "roles");
        op.add(Builder::ssl, Ssl._DESERIALIZER, "ssl");
        op.add(Builder::systemKey, FeatureToggle._DESERIALIZER, "system_key");
        op.add(Builder::tokenService, FeatureToggle._DESERIALIZER, "token_service");
        op.add(Builder::operatorPrivileges, Base._DESERIALIZER, "operator_privileges");
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Security> {
        private FeatureToggle apiKeyService;
        private FeatureToggle anonymous;
        private Audit audit;
        private FeatureToggle fips140;
        private IpFilter ipfilter;
        private Map<String, Realm> realms;
        private Map<String, RoleMapping> roleMapping;
        private SecurityRoles roles;
        private Ssl ssl;
        @Nullable
        private FeatureToggle systemKey;
        private FeatureToggle tokenService;
        private Base operatorPrivileges;

        public final Builder apiKeyService(FeatureToggle value) {
            this.apiKeyService = value;
            return this;
        }

        public final Builder apiKeyService(Function<FeatureToggle.Builder, ObjectBuilder<FeatureToggle>> fn) {
            return this.apiKeyService(fn.apply(new FeatureToggle.Builder()).build());
        }

        public final Builder anonymous(FeatureToggle value) {
            this.anonymous = value;
            return this;
        }

        public final Builder anonymous(Function<FeatureToggle.Builder, ObjectBuilder<FeatureToggle>> fn) {
            return this.anonymous(fn.apply(new FeatureToggle.Builder()).build());
        }

        public final Builder audit(Audit value) {
            this.audit = value;
            return this;
        }

        public final Builder audit(Function<Audit.Builder, ObjectBuilder<Audit>> fn) {
            return this.audit(fn.apply(new Audit.Builder()).build());
        }

        public final Builder fips140(FeatureToggle value) {
            this.fips140 = value;
            return this;
        }

        public final Builder fips140(Function<FeatureToggle.Builder, ObjectBuilder<FeatureToggle>> fn) {
            return this.fips140(fn.apply(new FeatureToggle.Builder()).build());
        }

        public final Builder ipfilter(IpFilter value) {
            this.ipfilter = value;
            return this;
        }

        public final Builder ipfilter(Function<IpFilter.Builder, ObjectBuilder<IpFilter>> fn) {
            return this.ipfilter(fn.apply(new IpFilter.Builder()).build());
        }

        public final Builder realms(Map<String, Realm> map) {
            this.realms = Builder._mapPutAll(this.realms, map);
            return this;
        }

        public final Builder realms(String key, Realm value) {
            this.realms = Builder._mapPut(this.realms, key, value);
            return this;
        }

        public final Builder realms(String key, Function<Realm.Builder, ObjectBuilder<Realm>> fn) {
            return this.realms(key, fn.apply(new Realm.Builder()).build());
        }

        public final Builder roleMapping(Map<String, RoleMapping> map) {
            this.roleMapping = Builder._mapPutAll(this.roleMapping, map);
            return this;
        }

        public final Builder roleMapping(String key, RoleMapping value) {
            this.roleMapping = Builder._mapPut(this.roleMapping, key, value);
            return this;
        }

        public final Builder roleMapping(String key, Function<RoleMapping.Builder, ObjectBuilder<RoleMapping>> fn) {
            return this.roleMapping(key, fn.apply(new RoleMapping.Builder()).build());
        }

        public final Builder roles(SecurityRoles value) {
            this.roles = value;
            return this;
        }

        public final Builder roles(Function<SecurityRoles.Builder, ObjectBuilder<SecurityRoles>> fn) {
            return this.roles(fn.apply(new SecurityRoles.Builder()).build());
        }

        public final Builder ssl(Ssl value) {
            this.ssl = value;
            return this;
        }

        public final Builder ssl(Function<Ssl.Builder, ObjectBuilder<Ssl>> fn) {
            return this.ssl(fn.apply(new Ssl.Builder()).build());
        }

        public final Builder systemKey(@Nullable FeatureToggle value) {
            this.systemKey = value;
            return this;
        }

        public final Builder systemKey(Function<FeatureToggle.Builder, ObjectBuilder<FeatureToggle>> fn) {
            return this.systemKey(fn.apply(new FeatureToggle.Builder()).build());
        }

        public final Builder tokenService(FeatureToggle value) {
            this.tokenService = value;
            return this;
        }

        public final Builder tokenService(Function<FeatureToggle.Builder, ObjectBuilder<FeatureToggle>> fn) {
            return this.tokenService(fn.apply(new FeatureToggle.Builder()).build());
        }

        public final Builder operatorPrivileges(Base value) {
            this.operatorPrivileges = value;
            return this;
        }

        public final Builder operatorPrivileges(Function<Base.Builder, ObjectBuilder<Base>> fn) {
            return this.operatorPrivileges(fn.apply(new Base.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Security build() {
            this._checkSingleUse();
            return new Security(this);
        }
    }
}

