/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.statement.SQLDDLStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLCreateTableStatement
extends SQLStatementImpl
implements SQLDDLStatement {
    protected Type type;
    protected SQLExprTableSource tableSource;
    protected List<SQLTableElement> tableElementList = new ArrayList<SQLTableElement>();

    public SQLName getName() {
        if (this.tableSource == null) {
            return null;
        }
        return (SQLName)this.tableSource.getExpr();
    }

    public void setName(SQLName name) {
        this.setTableSource(new SQLExprTableSource(name));
    }

    public SQLExprTableSource getTableSource() {
        return this.tableSource;
    }

    public void setTableSource(SQLExprTableSource tableSource) {
        if (tableSource != null) {
            tableSource.setParent(this);
        }
        this.tableSource = tableSource;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public List<SQLTableElement> getTableElementList() {
        return this.tableElementList;
    }

    @Override
    public void output(StringBuffer buf) {
        buf.append("CREATE TABLE ");
        if (Type.GLOBAL_TEMPORARY.equals((Object)this.type)) {
            buf.append("GLOBAL TEMPORARY ");
        } else if (Type.LOCAL_TEMPORARY.equals((Object)this.type)) {
            buf.append("LOCAL TEMPORARY ");
        }
        this.tableSource.output(buf);
        buf.append(" ");
        buf.append("(");
        int size = this.tableElementList.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            this.tableElementList.get(i).output(buf);
        }
        buf.append(")");
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.tableSource);
            this.acceptChild(visitor, this.tableElementList);
        }
        visitor.endVisit(this);
    }

    public static enum Type {
        GLOBAL_TEMPORARY,
        LOCAL_TEMPORARY;

    }
}

