/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.sqlserver.visitor;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLColumnConstraint;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerColumnDefinition;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerSelectQueryBlock;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerTop;
import com.alibaba.druid.sql.dialect.sqlserver.ast.expr.SQLServerObjectReferenceExpr;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerExecStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerInsertStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerUpdateStatement;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;

public class SQLServerOutputVisitor
extends SQLASTOutputVisitor
implements SQLServerASTVisitor {
    public SQLServerOutputVisitor(Appendable appender) {
        super(appender);
    }

    @Override
    public boolean visit(SQLServerSelectQueryBlock x) {
        this.print("SELECT ");
        if (1 == x.getDistionOption()) {
            this.print("ALL ");
        } else if (2 == x.getDistionOption()) {
            this.print("DISTINCT ");
        } else if (3 == x.getDistionOption()) {
            this.print("UNIQUE ");
        }
        if (x.getTop() != null) {
            x.getTop().accept(this);
            this.print(' ');
        }
        this.printSelectList(x.getSelectList());
        if (x.getInto() != null) {
            this.println();
            this.print("INTO ");
            x.getInto().accept(this);
        }
        if (x.getFrom() != null) {
            this.println();
            this.print("FROM ");
            x.getFrom().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print("WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        if (x.getGroupBy() != null) {
            this.println();
            x.getGroupBy().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerSelectQueryBlock x) {
    }

    @Override
    public boolean visit(SQLServerTop x) {
        this.print("TOP ");
        boolean paren = false;
        if (x.getParent() instanceof SQLServerUpdateStatement) {
            paren = true;
            this.print("(");
        }
        x.getExpr().accept(this);
        if (paren) {
            this.print(")");
        }
        if (x.isPercent()) {
            this.print(" PERCENT");
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerTop x) {
    }

    @Override
    public boolean visit(SQLServerObjectReferenceExpr x) {
        this.print(x.toString());
        return false;
    }

    @Override
    public void endVisit(SQLServerObjectReferenceExpr x) {
    }

    @Override
    public boolean visit(SQLServerInsertStatement x) {
        int i;
        int size;
        this.print("INSERT INTO ");
        x.getTableSource().accept(this);
        if (x.getColumns().size() > 0) {
            this.incrementIndent();
            this.println();
            this.print("(");
            size = x.getColumns().size();
            for (i = 0; i < size; ++i) {
                if (i != 0) {
                    if (i % 5 == 0) {
                        this.println();
                    }
                    this.print(", ");
                }
                x.getColumns().get(i).accept(this);
            }
            this.print(")");
            this.decrementIndent();
        }
        if (x.getValuesList().size() != 0) {
            this.println();
            this.print("VALUES");
            this.println();
            size = x.getValuesList().size();
            for (i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print(",");
                    this.println();
                }
                x.getValuesList().get(i).accept(this);
            }
        }
        if (x.getQuery() != null) {
            this.println();
            x.getQuery().accept(this);
        }
        if (x.isDefaultValues()) {
            this.print(" DEFAULT VALUES");
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerInsertStatement x) {
    }

    @Override
    public boolean visit(SQLServerUpdateStatement x) {
        this.print("UPDATE ");
        if (x.getTop() != null) {
            x.getTop().setParent(x);
            x.getTop().accept(this);
            this.print(' ');
        }
        x.getTableSource().accept(this);
        this.println();
        this.print("SET ");
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            x.getItems().get(i).accept(this);
        }
        if (x.getFrom() != null) {
            this.println();
            this.print("FROM ");
            x.getFrom().setParent(x);
            x.getFrom().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print("WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerUpdateStatement x) {
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        x.getExpr().accept(this);
        if (x.getHints() != null && x.getHints().size() > 0) {
            this.print(" WITH (");
            this.printAndAccept(x.getHints(), ", ");
            this.print(")");
        }
        if (x.getAlias() != null) {
            this.print(' ');
            this.print(x.getAlias());
        }
        return false;
    }

    @Override
    public boolean visit(SQLServerColumnDefinition.Identity x) {
        this.print("IDENTITY (");
        this.print(x.getSeed());
        this.print(", ");
        this.print(x.getIncrement());
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(SQLServerColumnDefinition.Identity x) {
    }

    @Override
    public boolean visit(SQLServerColumnDefinition x) {
        x.getName().accept(this);
        if (x.getDataType() != null) {
            this.print(' ');
            x.getDataType().accept(this);
        }
        if (x.getDefaultExpr() != null) {
            this.visitColumnDefault(x);
        }
        for (SQLColumnConstraint item : x.getConstaints()) {
            this.print(' ');
            item.accept(this);
        }
        if (x.getIdentity() != null) {
            this.print(' ');
            x.getIdentity().accept(this);
        }
        if (x.getEnable() != null && x.getEnable().booleanValue()) {
            this.print(" ENABLE");
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerColumnDefinition x) {
    }

    @Override
    public boolean visit(SQLColumnDefinition x) {
        if (x instanceof SQLServerColumnDefinition) {
            return this.visit((SQLServerColumnDefinition)x);
        }
        return super.visit(x);
    }

    @Override
    public boolean visit(SQLServerExecStatement x) {
        this.print("EXEC ");
        SQLName moduleName = x.getModuleName();
        if (moduleName != null) {
            moduleName.accept(this);
            this.print(' ');
        } else {
            this.print(" (");
        }
        this.printAndAccept(x.getParameters(), ", ");
        if (moduleName == null) {
            this.print(')');
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerExecStatement x) {
    }
}

