/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.ast.stmt;

import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.statement.SQLErrorLoggingClause;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleReturningClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleStatement;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OracleInsertStatement
extends SQLInsertStatement
implements OracleStatement {
    private OracleReturningClause returning;
    private SQLErrorLoggingClause errorLogging;
    private List<SQLHint> hints = new ArrayList<SQLHint>();

    public OracleInsertStatement() {
        this.dbType = "oracle";
    }

    public void cloneTo(OracleInsertStatement x) {
        super.cloneTo(x);
        if (this.returning != null) {
            x.setReturning(this.returning.clone());
        }
        if (this.errorLogging != null) {
            x.setErrorLogging(this.errorLogging.clone());
        }
        for (SQLHint hint : this.hints) {
            SQLHint h2 = hint.clone();
            h2.setParent(x);
            x.hints.add(h2);
        }
    }

    public List<SQLHint> getHints() {
        return this.hints;
    }

    public void setHints(List<SQLHint> hints) {
        this.hints = hints;
    }

    public OracleReturningClause getReturning() {
        return this.returning;
    }

    public void setReturning(OracleReturningClause returning) {
        this.returning = returning;
    }

    public SQLErrorLoggingClause getErrorLogging() {
        return this.errorLogging;
    }

    public void setErrorLogging(SQLErrorLoggingClause errorLogging) {
        this.errorLogging = errorLogging;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        this.accept0((OracleASTVisitor)visitor);
    }

    @Override
    public void accept0(OracleASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.getTableSource());
            this.acceptChild((SQLASTVisitor)visitor, this.getColumns());
            this.acceptChild((SQLASTVisitor)visitor, this.getValues());
            this.acceptChild((SQLASTVisitor)visitor, this.getQuery());
            this.acceptChild((SQLASTVisitor)visitor, this.returning);
            this.acceptChild((SQLASTVisitor)visitor, this.errorLogging);
        }
        visitor.endVisit(this);
    }

    @Override
    public void output(StringBuffer buf) {
        new OracleOutputVisitor(buf).visit(this);
    }

    @Override
    public OracleInsertStatement clone() {
        OracleInsertStatement x = new OracleInsertStatement();
        this.cloneTo(x);
        return x;
    }
}

