/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ExtraProcessor;
import com.alibaba.fastjson.parser.deserializer.ExtraTypeProvider;
import com.alibaba.fastjson.serializer.AfterFilter;
import com.alibaba.fastjson.serializer.BeforeFilter;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.LabelFilter;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.ValueFilter;
import java.lang.reflect.Type;
import java.util.List;

public class FilterUtils {
    public static Type getExtratype(DefaultJSONParser parser, Object object, String key) {
        List<ExtraTypeProvider> extraTypeProviders = parser.getExtraTypeProvidersDirect();
        if (extraTypeProviders == null) {
            return null;
        }
        Type type = null;
        for (ExtraTypeProvider extraProvider : extraTypeProviders) {
            type = extraProvider.getExtraType(object, key);
        }
        return type;
    }

    public static void processExtra(DefaultJSONParser parser, Object object, String key, Object value) {
        List<ExtraProcessor> extraProcessors = parser.getExtraProcessorsDirect();
        if (extraProcessors == null) {
            return;
        }
        for (ExtraProcessor process : extraProcessors) {
            process.processExtra(object, key, value);
        }
    }

    public static char writeBefore(JSONSerializer serializer, Object object, char seperator) {
        List<BeforeFilter> beforeFilters = serializer.getBeforeFiltersDirect();
        if (beforeFilters != null) {
            for (BeforeFilter beforeFilter : beforeFilters) {
                seperator = beforeFilter.writeBefore(serializer, object, seperator);
            }
        }
        return seperator;
    }

    public static char writeAfter(JSONSerializer serializer, Object object, char seperator) {
        List<AfterFilter> afterFilters = serializer.getAfterFiltersDirect();
        if (afterFilters != null) {
            for (AfterFilter afterFilter : afterFilters) {
                seperator = afterFilter.writeAfter(serializer, object, seperator);
            }
        }
        return seperator;
    }

    public static Object processValue(JSONSerializer serializer, Object object, String key, Object propertyValue) {
        List<ValueFilter> valueFilters = serializer.getValueFiltersDirect();
        if (valueFilters != null) {
            for (ValueFilter valueFilter : valueFilters) {
                propertyValue = valueFilter.process(object, key, propertyValue);
            }
        }
        return propertyValue;
    }

    public static String processKey(JSONSerializer serializer, Object object, String key, Object propertyValue) {
        List<NameFilter> nameFilters = serializer.getNameFiltersDirect();
        if (nameFilters != null) {
            for (NameFilter nameFilter : nameFilters) {
                key = nameFilter.process(object, key, propertyValue);
            }
        }
        return key;
    }

    public static String processKey(JSONSerializer serializer, Object object, String key, byte intValue) {
        List<NameFilter> nameFilters = serializer.getNameFiltersDirect();
        if (nameFilters != null) {
            Byte propertyValue = intValue;
            for (NameFilter nameFilter : nameFilters) {
                key = nameFilter.process(object, key, propertyValue);
            }
        }
        return key;
    }

    public static String processKey(JSONSerializer serializer, Object object, String key, short intValue) {
        List<NameFilter> nameFilters = serializer.getNameFiltersDirect();
        if (nameFilters != null) {
            Short propertyValue = intValue;
            for (NameFilter nameFilter : nameFilters) {
                key = nameFilter.process(object, key, propertyValue);
            }
        }
        return key;
    }

    public static String processKey(JSONSerializer serializer, Object object, String key, int intValue) {
        List<NameFilter> nameFilters = serializer.getNameFiltersDirect();
        if (nameFilters != null) {
            Integer propertyValue = intValue;
            for (NameFilter nameFilter : nameFilters) {
                key = nameFilter.process(object, key, propertyValue);
            }
        }
        return key;
    }

    public static String processKey(JSONSerializer serializer, Object object, String key, long intValue) {
        List<NameFilter> nameFilters = serializer.getNameFiltersDirect();
        if (nameFilters != null) {
            Long propertyValue = intValue;
            for (NameFilter nameFilter : nameFilters) {
                key = nameFilter.process(object, key, propertyValue);
            }
        }
        return key;
    }

    public static String processKey(JSONSerializer serializer, Object object, String key, float intValue) {
        List<NameFilter> nameFilters = serializer.getNameFiltersDirect();
        if (nameFilters != null) {
            Float propertyValue = Float.valueOf(intValue);
            for (NameFilter nameFilter : nameFilters) {
                key = nameFilter.process(object, key, propertyValue);
            }
        }
        return key;
    }

    public static String processKey(JSONSerializer serializer, Object object, String key, double intValue) {
        List<NameFilter> nameFilters = serializer.getNameFiltersDirect();
        if (nameFilters != null) {
            Double propertyValue = intValue;
            for (NameFilter nameFilter : nameFilters) {
                key = nameFilter.process(object, key, propertyValue);
            }
        }
        return key;
    }

    public static String processKey(JSONSerializer serializer, Object object, String key, boolean intValue) {
        List<NameFilter> nameFilters = serializer.getNameFiltersDirect();
        if (nameFilters != null) {
            Boolean propertyValue = intValue;
            for (NameFilter nameFilter : nameFilters) {
                key = nameFilter.process(object, key, propertyValue);
            }
        }
        return key;
    }

    public static String processKey(JSONSerializer serializer, Object object, String key, char intValue) {
        List<NameFilter> nameFilters = serializer.getNameFiltersDirect();
        if (nameFilters != null) {
            Character propertyValue = Character.valueOf(intValue);
            for (NameFilter nameFilter : nameFilters) {
                key = nameFilter.process(object, key, propertyValue);
            }
        }
        return key;
    }

    public static boolean applyName(JSONSerializer serializer, Object object, String key) {
        List<PropertyPreFilter> filters = serializer.getPropertyPreFiltersDirect();
        if (filters == null) {
            return true;
        }
        for (PropertyPreFilter filter : filters) {
            if (filter.apply(serializer, object, key)) continue;
            return false;
        }
        return true;
    }

    public static boolean apply(JSONSerializer serializer, Object object, String key, Object propertyValue) {
        List<PropertyFilter> propertyFilters = serializer.getPropertyFiltersDirect();
        if (propertyFilters == null) {
            return true;
        }
        for (PropertyFilter propertyFilter : propertyFilters) {
            if (propertyFilter.apply(object, key, propertyValue)) continue;
            return false;
        }
        return true;
    }

    public static boolean apply(JSONSerializer serializer, Object object, String key, byte value) {
        List<PropertyFilter> propertyFilters = serializer.getPropertyFiltersDirect();
        if (propertyFilters != null) {
            boolean apply = true;
            Byte propertyValue = value;
            for (PropertyFilter propertyFilter : propertyFilters) {
                if (propertyFilter.apply(object, key, propertyValue)) continue;
                return false;
            }
            return apply;
        }
        return true;
    }

    public static boolean apply(JSONSerializer serializer, Object object, String key, short value) {
        List<PropertyFilter> propertyFilters = serializer.getPropertyFiltersDirect();
        if (propertyFilters != null) {
            boolean apply = true;
            Short propertyValue = value;
            for (PropertyFilter propertyFilter : propertyFilters) {
                if (propertyFilter.apply(object, key, propertyValue)) continue;
                return false;
            }
            return apply;
        }
        return true;
    }

    public static boolean apply(JSONSerializer serializer, Object object, String key, int value) {
        List<PropertyFilter> propertyFilters = serializer.getPropertyFiltersDirect();
        if (propertyFilters != null) {
            boolean apply = true;
            Integer propertyValue = value;
            for (PropertyFilter propertyFilter : propertyFilters) {
                if (propertyFilter.apply(object, key, propertyValue)) continue;
                return false;
            }
            return apply;
        }
        return true;
    }

    public static boolean apply(JSONSerializer serializer, Object object, String key, char value) {
        List<PropertyFilter> propertyFilters = serializer.getPropertyFiltersDirect();
        if (propertyFilters != null) {
            boolean apply = true;
            Character propertyValue = Character.valueOf(value);
            for (PropertyFilter propertyFilter : propertyFilters) {
                if (propertyFilter.apply(object, key, propertyValue)) continue;
                return false;
            }
            return apply;
        }
        return true;
    }

    public static boolean apply(JSONSerializer serializer, Object object, String key, long value) {
        List<PropertyFilter> propertyFilters = serializer.getPropertyFiltersDirect();
        if (propertyFilters != null) {
            boolean apply = true;
            Long propertyValue = value;
            for (PropertyFilter propertyFilter : propertyFilters) {
                if (propertyFilter.apply(object, key, propertyValue)) continue;
                return false;
            }
            return apply;
        }
        return true;
    }

    public static boolean apply(JSONSerializer serializer, Object object, String key, float value) {
        List<PropertyFilter> propertyFilters = serializer.getPropertyFiltersDirect();
        if (propertyFilters != null) {
            boolean apply = true;
            Float propertyValue = Float.valueOf(value);
            for (PropertyFilter propertyFilter : propertyFilters) {
                if (propertyFilter.apply(object, key, propertyValue)) continue;
                return false;
            }
            return apply;
        }
        return true;
    }

    public static boolean apply(JSONSerializer serializer, Object object, String key, double value) {
        List<PropertyFilter> propertyFilters = serializer.getPropertyFiltersDirect();
        if (propertyFilters != null) {
            boolean apply = true;
            Double propertyValue = value;
            for (PropertyFilter propertyFilter : propertyFilters) {
                if (propertyFilter.apply(object, key, propertyValue)) continue;
                return false;
            }
            return apply;
        }
        return true;
    }

    public static boolean applyLabel(JSONSerializer serializer, String label) {
        List<LabelFilter> viewFilters = serializer.getLabelFiltersDirect();
        if (viewFilters != null) {
            boolean apply = true;
            for (LabelFilter propertyFilter : viewFilters) {
                if (propertyFilter.apply(label)) continue;
                return false;
            }
            return apply;
        }
        return true;
    }
}

