/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics;

import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.MetricAdminMBean;
import com.amazonaws.metrics.MetricCollector;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.metrics.ServiceMetricCollector;
import com.amazonaws.regions.Regions;
import java.io.FileNotFoundException;
import java.io.IOException;

public class MetricAdmin
implements MetricAdminMBean {
    public boolean enableDefaultMetrics() {
        return AwsSdkMetrics.enableDefaultMetrics();
    }

    public void disableMetrics() {
        AwsSdkMetrics.disableMetrics();
    }

    public String getRequestMetricCollector() {
        MetricCollector mc = AwsSdkMetrics.getInternalMetricCollector();
        RequestMetricCollector rmc = mc == null ? null : mc.getRequestMetricCollector();
        return mc == null || rmc == RequestMetricCollector.NONE ? "NONE" : rmc.getClass().getName();
    }

    public String getServiceMetricCollector() {
        MetricCollector mc = AwsSdkMetrics.getInternalMetricCollector();
        ServiceMetricCollector smc = mc == null ? null : mc.getServiceMetricCollector();
        return mc == null || smc == ServiceMetricCollector.NONE ? "NONE" : smc.getClass().getName();
    }

    public boolean isMetricsEnabled() {
        return AwsSdkMetrics.isMetricsEnabled();
    }

    public boolean isMachineMetricsExcluded() {
        return AwsSdkMetrics.isMachineMetricExcluded();
    }

    public void setMachineMetricsExcluded(boolean excludeJvmMetrics) {
        AwsSdkMetrics.setMachineMetricsExcluded(excludeJvmMetrics);
    }

    public String getRegion() {
        Regions region = AwsSdkMetrics.getRegion();
        return region == null ? null : region.getName();
    }

    public void setRegion(String region) {
        if (region == null || region.isEmpty()) {
            AwsSdkMetrics.setRegion(null);
        } else {
            AwsSdkMetrics.setRegion(Regions.fromName(region));
        }
    }

    public Integer getMetricQueueSize() {
        return AwsSdkMetrics.getMetricQueueSize();
    }

    public void setMetricQueueSize(Integer metricQueueSize) {
        AwsSdkMetrics.setMetricQueueSize(metricQueueSize);
    }

    public Integer getQueuePollTimeoutMilli() {
        Long queuePollTimeoutMilli = AwsSdkMetrics.getQueuePollTimeoutMilli();
        return queuePollTimeoutMilli == null ? null : Integer.valueOf(queuePollTimeoutMilli.intValue());
    }

    public void setQueuePollTimeoutMilli(Integer timeoutMilli) {
        AwsSdkMetrics.setQueuePollTimeoutMilli(timeoutMilli == null ? null : Long.valueOf(timeoutMilli.longValue()));
    }

    public String getMetricNameSpace() {
        return AwsSdkMetrics.getMetricNameSpace();
    }

    public void setMetricNameSpace(String metricNameSpace) {
        AwsSdkMetrics.setMetricNameSpace(metricNameSpace);
    }

    public boolean isPerHostMetricsIncluded() {
        return AwsSdkMetrics.isPerHostMetricIncluded();
    }

    public void setPerHostMetricsIncluded(boolean includePerHostMetrics) {
        AwsSdkMetrics.setPerHostMetricsIncluded(includePerHostMetrics);
    }

    public String getJvmMetricName() {
        return AwsSdkMetrics.getJvmMetricName();
    }

    public void setJvmMetricName(String jvmMetricName) {
        AwsSdkMetrics.setJvmMetricName(jvmMetricName);
    }

    public String getHostMetricName() {
        return AwsSdkMetrics.getHostMetricName();
    }

    public void setHostMetricName(String hostMetricName) {
        AwsSdkMetrics.setHostMetricName(hostMetricName);
    }

    public String getCredentialFile() {
        return AwsSdkMetrics.getCredentailFile();
    }

    public void setCredentialFile(String filepath) throws FileNotFoundException, IOException {
        AwsSdkMetrics.setCredentialFile(filepath);
    }

    public boolean isSingleMetricNamespace() {
        return AwsSdkMetrics.isSingleMetricNamespace();
    }

    public void setSingleMetricNamespace(boolean singleMetricNamespace) {
        AwsSdkMetrics.setSingleMetricNamespace(singleMetricNamespace);
    }
}

